/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.summonerscrolls.client.render.entity.renderer;

import com.github.teamfusion.summonerscrolls.client.render.entity.layers.CreeperSummonPowerLayer;
import com.github.teamfusion.summonerscrolls.client.render.entity.layers.SummonGlowLayer;
import com.github.teamfusion.summonerscrolls.common.entity.summons.creeper.CreeperSummon;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.CreeperModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class CreeperSummonRenderer
extends MobRenderer<CreeperSummon, CreeperModel<CreeperSummon>> {
    public static final ResourceLocation SUMMON_LOCATION = new ResourceLocation("summonerscrolls", "textures/entity/summon/creeper_summon.png");

    public CreeperSummonRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new CreeperModel(context.m_174023_(ModelLayers.f_171285_)), 0.5f);
        this.m_115326_((RenderLayer)new CreeperSummonPowerLayer((RenderLayerParent<CreeperSummon, CreeperModel<CreeperSummon>>)this, context.m_174027_()));
        this.m_115326_((RenderLayer)new SummonGlowLayer(this, SUMMON_LOCATION));
    }

    protected void scale(CreeperSummon livingEntity, PoseStack matrixStack, float partialTickTime) {
        float f = livingEntity.getSwelling(partialTickTime);
        float g = 1.0f + Mth.m_14031_((float)(f * 100.0f)) * f * 0.01f;
        f = Mth.m_14036_((float)f, (float)0.0f, (float)1.0f);
        f *= f;
        f *= f;
        float h = (1.0f + f * 0.4f) * g;
        float i = (1.0f + f * 0.1f) / g;
        matrixStack.m_85841_(h, i, h);
    }

    protected float getWhiteOverlayProgress(CreeperSummon livingEntity, float partialTicks) {
        float f = livingEntity.getSwelling(partialTicks);
        if ((int)(f * 10.0f) % 2 == 0) {
            return 0.0f;
        }
        return Mth.m_14036_((float)f, (float)0.5f, (float)1.0f);
    }

    @Nullable
    protected RenderType getRenderType(CreeperSummon summon, boolean bl, boolean bl2, boolean bl3) {
        return RenderType.m_110473_((ResourceLocation)this.getTextureLocation(summon));
    }

    protected int getBlockLightLevel(CreeperSummon summon, BlockPos blockPos) {
        return 10;
    }

    public ResourceLocation getTextureLocation(CreeperSummon summon) {
        return SUMMON_LOCATION;
    }
}

