/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.summonerscrolls.common.config;

import com.github.teamfusion.summonerscrolls.SummonerScrolls;
import com.github.teamfusion.summonerscrolls.common.config.ConfigEntries;
import com.github.teamfusion.summonerscrolls.common.config.ConfigEntry;
import com.github.teamfusion.summonerscrolls.platform.Environment;
import com.google.gson.Gson;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.io.FileUtils;

public class ModConfig {
    public static final ConfigEntry<Double> VERSION = new ConfigEntry<Double>("TECHNICAL.VERSION_DO_NOT_EDIT", 0.0);
    public static final ConfigEntry<Boolean> RELOAD = new ConfigEntry<Boolean>("TECHNICAL.FORCE_RESET", false);
    public static Map CONFIG = new TreeMap();
    public static final String DEFAULT_CONFIG = "{\n  \"TECHNICAL\": {\n    \"VERSION_DO_NOT_EDIT\": 1,\n    \"FORCE_RESET\": false\n  },\n\n  // This config file uses a custom defined parser. That's why there are comments here, they wouldn't be valid in any other .json file.\n  //    To add a comment yourself, just start a line with // like I did here\n  //    (although their main use is explaining you what the entries do)\n\n  // CATEGORY: SCROLLS\n  \"scrolls\": {\n    // Level cost to add a scroll to an item in an anvil\n    \"anvil_xp_cost\": 8,\n\n    // Summon costs\n    \"zombie\": {\n      \"xp_cost\": 1,\n      \"durability_cost\": 1\n    },\n    \"spider\": {\n      \"xp_cost\": 1,\n      \"durability_cost\": 1\n    },\n    \"spider_jockey\": {\n      \"xp_cost\": 3,\n      \"durability_cost\": 1\n    },\n    \"skeleton\": {\n      \"xp_cost\": 2,\n      \"durability_cost\": 2\n    },\n    \"bee\": {\n      \"xp_cost\": 3,\n      \"durability_cost\": 5\n    },\n\n    \"husk\": {\n      \"xp_cost\": 2,\n      \"durability_cost\": 5\n    },\n    \"stray\": {\n      \"xp_cost\": 4,\n      \"durability_cost\": 5\n    },\n    \"cave_spider\": {\n      \"xp_cost\": 3,\n      \"durability_cost\": 5\n    },\n    \"enderman\": {\n      \"xp_cost\": 4,\n      \"durability_cost\": 5\n    },\n    \"piglin\": {\n      \"xp_cost\": 3,\n      \"durability_cost\": 10\n    },\n\n    \"creeper\": {\n      \"xp_cost\": 4,\n      \"durability_cost\": 10\n    },\n    \"piglin_brute\": {\n      \"xp_cost\": 5,\n      \"durability_cost\": 10\n    },\n    \"shulkerman\": {\n      \"xp_cost\": 5,\n      \"durability_cost\": 10\n    },\n    \"iron_golem\": {\n      \"xp_cost\": 5,\n      \"durability_cost\": 10\n    },\n    \"charged_creeper\": {\n      \"xp_cost\": 5,\n      \"durability_cost\": 15\n    }\n  }\n}";

    public static <T> T get(String path, T fallback) {
        return new ConfigEntry<T>(path, fallback).get();
    }

    public static void register() {
        ModConfig.register(false);
    }

    public static void register(boolean force) {
        boolean create;
        String path = Environment.getConfigDir().resolve("summonerscrolls.json").toString();
        SummonerScrolls.LOGGER.info("Loading Configs for SummonerScrolls");
        File config = new File(path);
        boolean bl = create = !config.isFile();
        if (create || force) {
            try {
                config.delete();
                config.createNewFile();
                FileWriter writer = new FileWriter(path);
                writer.write(DEFAULT_CONFIG);
                writer.close();
                SummonerScrolls.LOGGER.info("SummonerScrolls Config file created");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        String configContent = DEFAULT_CONFIG;
        try {
            configContent = FileUtils.readFileToString((File)config, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        CONFIG = (Map)new Gson().fromJson(ModConfig.parseJson(configContent), Map.class);
        ConfigEntries.reload();
        if (!force && RELOAD.get().booleanValue()) {
            ModConfig.register(true);
        }
    }

    public static String parseJson(String text) {
        StringBuilder result = new StringBuilder();
        for (String line : text.split("\n")) {
            if (line.strip().startsWith("//")) continue;
            result.append("\n").append(line);
        }
        return result.toString();
    }

    public static double getVersion() {
        String text = DEFAULT_CONFIG;
        int start = 0;
        while (!List.of(Character.valueOf('0'), Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('7'), Character.valueOf('8'), Character.valueOf('9'), Character.valueOf('.')).contains(Character.valueOf(text.charAt(start)))) {
            ++start;
        }
        int end = start + 1;
        while (List.of(Character.valueOf('0'), Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('7'), Character.valueOf('8'), Character.valueOf('9'), Character.valueOf('.')).contains(Character.valueOf(text.charAt(end)))) {
            ++end;
        }
        return Double.parseDouble(text.substring(start, end));
    }
}

