/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.summonerscrolls.common.entity.base.goal;

import com.github.teamfusion.summonerscrolls.common.entity.summons.skeleton.StraySummon;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;

public class SummonerRangedBowAttackGoal<T extends PathfinderMob>
extends Goal {
    private final T mob;
    private final double speedModifier;
    private int attackIntervalMin;
    private final float attackRadiusSqr;
    private int attackTime = -1;
    private int seeTime;
    private boolean strafingClockwise;
    private boolean strafingBackwards;
    private int strafingTime = -1;
    private final Item bowItem;

    public SummonerRangedBowAttackGoal(T mob, double speedModifier, int attackIntervalMin, float attackRadius, Item bowItem) {
        this.mob = mob;
        this.speedModifier = speedModifier;
        this.attackIntervalMin = attackIntervalMin;
        this.attackRadiusSqr = attackRadius * attackRadius;
        this.bowItem = bowItem;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public void setMinAttackInterval(int attackCooldown) {
        this.attackIntervalMin = attackCooldown;
    }

    public boolean m_8036_() {
        return this.mob.m_5448_() != null && this.isHoldingBow();
    }

    protected boolean isHoldingBow() {
        return this.mob.m_21055_(this.bowItem);
    }

    public boolean m_8045_() {
        return (this.m_8036_() || !this.mob.m_21573_().m_26571_()) && this.isHoldingBow();
    }

    public void m_8056_() {
        this.mob.m_21561_(true);
    }

    public void m_8041_() {
        this.mob.m_21561_(false);
        this.seeTime = 0;
        this.attackTime = -1;
        this.mob.m_5810_();
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        LivingEntity target = this.mob.m_5448_();
        if (target != null) {
            boolean hadSeen;
            double distanceSq = this.mob.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_());
            boolean canSee = this.mob.m_21574_().m_148306_((Entity)target);
            boolean bl = hadSeen = this.seeTime > 0;
            if (canSee != hadSeen) {
                this.seeTime = 0;
            }
            this.seeTime += canSee ? 1 : -1;
            if (distanceSq <= (double)this.attackRadiusSqr && this.seeTime >= 20) {
                this.mob.m_21573_().m_26573_();
                ++this.strafingTime;
            } else {
                this.mob.m_21573_().m_5624_((Entity)target, this.speedModifier);
                this.strafingTime = -1;
            }
            if (this.strafingTime >= 20) {
                if ((double)this.mob.m_217043_().m_188501_() < 0.3) {
                    boolean bl2 = this.strafingClockwise = !this.strafingClockwise;
                }
                if ((double)this.mob.m_217043_().m_188501_() < 0.3) {
                    this.strafingBackwards = !this.strafingBackwards;
                }
                this.strafingTime = 0;
            }
            if (this.strafingTime > -1) {
                if (distanceSq > (double)(this.attackRadiusSqr * 0.75f)) {
                    this.strafingBackwards = false;
                } else if (distanceSq < (double)(this.attackRadiusSqr * 0.25f)) {
                    this.strafingBackwards = true;
                }
                this.mob.m_21566_().m_24988_(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
                this.mob.m_21391_((Entity)target, 30.0f, 30.0f);
            } else {
                this.mob.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            }
            if (this.mob.m_6117_()) {
                int chargeTime;
                if (!canSee && this.seeTime < -60) {
                    this.mob.m_5810_();
                } else if (canSee && (chargeTime = this.mob.m_21252_()) >= 20) {
                    this.mob.m_5810_();
                    float power = this.mob instanceof StraySummon ? 2.0f : 1.0f;
                    ((RangedAttackMob)this.mob).m_6504_(target, power);
                    this.attackTime = this.attackIntervalMin;
                }
            } else if (--this.attackTime <= 0 && this.seeTime >= -60) {
                this.mob.m_6672_(ProjectileUtil.m_37297_(this.mob, (Item)this.bowItem));
            }
        }
    }
}

