/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.summonerscrolls.common.entity.base.goal;

import com.github.teamfusion.summonerscrolls.common.item.SummonerCrossBow;
import com.github.teamfusion.summonerscrolls.common.registry.SummonerItems;
import java.util.EnumSet;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class SummonerRangedCrossbowAttack<T extends CrossbowAttackMob>
extends Goal {
    public static final UniformInt PATHFINDING_DELAY_RANGE = TimeUtil.m_145020_((int)1, (int)2);
    private final T mob;
    private CrossbowState crossbowState = CrossbowState.UNCHARGED;
    private final double speedModifier;
    private final float attackRadiusSqr;
    private int seeTime;
    private int attackDelay;
    private int updatePathDelay;

    public SummonerRangedCrossbowAttack(T mob, double speedModifier, float attackRadius) {
        this.mob = mob;
        this.speedModifier = speedModifier;
        this.attackRadiusSqr = attackRadius * attackRadius;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        return this.isValidTarget() && this.isHoldingCrossbow();
    }

    private boolean isHoldingCrossbow() {
        return ((LivingEntity)this.mob).m_21055_(SummonerItems.SUMMON_CROSSBOW.get());
    }

    public boolean m_8045_() {
        return this.isValidTarget() && (this.m_8036_() || !((Mob)this.mob).m_21573_().m_26571_()) && this.isHoldingCrossbow();
    }

    private boolean isValidTarget() {
        return ((Mob)this.mob).m_5448_() != null && ((Mob)this.mob).m_5448_().m_6084_();
    }

    public void m_8041_() {
        super.m_8041_();
        ((Mob)this.mob).m_21561_(false);
        ((Mob)this.mob).m_6710_(null);
        this.seeTime = 0;
        if (((LivingEntity)this.mob).m_6117_()) {
            ((LivingEntity)this.mob).m_5810_();
            this.mob.m_6136_(false);
            SummonerCrossBow.setCharged(((LivingEntity)this.mob).m_21211_(), false);
        }
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        LivingEntity livingEntity = ((Mob)this.mob).m_5448_();
        if (livingEntity == null) {
            return;
        }
        boolean bl = ((Mob)this.mob).m_21574_().m_148306_((Entity)livingEntity);
        boolean bl2 = this.seeTime > 0;
        boolean bl4 = bl2;
        if (bl != bl2) {
            this.seeTime = 0;
        }
        this.seeTime = bl ? (this.seeTime = this.seeTime + 1) : (this.seeTime = this.seeTime - 1);
        double d = ((Entity)this.mob).m_20280_((Entity)livingEntity);
        boolean bl3 = (d > (double)this.attackRadiusSqr || this.seeTime < 5) && this.attackDelay == 0;
        boolean bl5 = bl3;
        if (bl3) {
            --this.updatePathDelay;
            if (this.updatePathDelay <= 0) {
                ((Mob)this.mob).m_21573_().m_5624_((Entity)livingEntity, this.canRun() ? this.speedModifier : this.speedModifier * 0.5);
                this.updatePathDelay = PATHFINDING_DELAY_RANGE.m_214085_(((LivingEntity)this.mob).m_217043_());
            }
        } else {
            this.updatePathDelay = 0;
            ((Mob)this.mob).m_21573_().m_26573_();
        }
        ((Mob)this.mob).m_21563_().m_24960_((Entity)livingEntity, 30.0f, 30.0f);
        if (this.crossbowState == CrossbowState.UNCHARGED) {
            if (!bl3) {
                ((LivingEntity)this.mob).m_6672_(ProjectileUtil.m_37297_((LivingEntity)((LivingEntity)this.mob), (Item)SummonerItems.SUMMON_CROSSBOW.get()));
                this.crossbowState = CrossbowState.CHARGING;
                this.mob.m_6136_(true);
            }
        } else if (this.crossbowState == CrossbowState.CHARGING) {
            if (!((LivingEntity)this.mob).m_6117_()) {
                this.crossbowState = CrossbowState.UNCHARGED;
            }
            if (((LivingEntity)this.mob).m_21252_() >= SummonerCrossBow.getChargeDuration(((LivingEntity)this.mob).m_21211_())) {
                ((LivingEntity)this.mob).m_21253_();
                this.crossbowState = CrossbowState.CHARGED;
                this.attackDelay = 20 + ((LivingEntity)this.mob).m_217043_().m_188503_(20);
                this.mob.m_6136_(false);
            }
        } else if (this.crossbowState == CrossbowState.CHARGED) {
            --this.attackDelay;
            if (this.attackDelay == 0) {
                this.crossbowState = CrossbowState.READY_TO_ATTACK;
            }
        } else if (this.crossbowState == CrossbowState.READY_TO_ATTACK && bl) {
            this.mob.m_6504_(livingEntity, 1.0f);
            ItemStack itemStack2 = ((LivingEntity)this.mob).m_21120_(ProjectileUtil.m_37297_((LivingEntity)((LivingEntity)this.mob), (Item)SummonerItems.SUMMON_CROSSBOW.get()));
            SummonerCrossBow.setCharged(itemStack2, false);
            this.crossbowState = CrossbowState.UNCHARGED;
        }
    }

    private boolean canRun() {
        return this.crossbowState == CrossbowState.UNCHARGED;
    }

    static enum CrossbowState {
        UNCHARGED,
        CHARGING,
        CHARGED,
        READY_TO_ATTACK;

    }
}

