/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.summonerscrolls.common.entity.summons.enderman;

import com.github.teamfusion.summonerscrolls.common.entity.base.BaseSummonedEntity;
import com.github.teamfusion.summonerscrolls.common.entity.base.ISummon;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class EndermanSummon
extends BaseSummonedEntity {
    private static final UUID SPEED_MODIFIER_ATTACKING_UUID = UUID.fromString("020E0DFB-87AE-4653-9556-831010E291A0");
    private static final AttributeModifier SPEED_MODIFIER_ATTACKING = new AttributeModifier(SPEED_MODIFIER_ATTACKING_UUID, "Attacking speed boost", (double)0.15f, AttributeModifier.Operation.ADDITION);
    private static final EntityDataAccessor<Boolean> DATA_CREEPY = SynchedEntityData.m_135353_(EndermanSummon.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int lastStareSound = Integer.MIN_VALUE;

    public EndermanSummon(EntityType<? extends BaseSummonedEntity> entityType, Level level) {
        super(entityType, level);
        this.m_274367_(1.0f);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
    }

    @Override
    @Nullable
    public UUID m_6120_() {
        this.f_19804_.m_135381_(DATA_CREEPY, (Object)(this.persistentAngerTarget != null ? 1 : 0));
        return super.m_6120_();
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
    }

    @Override
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return SoundEvents.f_11849_;
    }

    @Override
    protected SoundEvent m_7515_() {
        return this.isCreepy() ? SoundEvents.f_11850_ : SoundEvents.f_11899_;
    }

    @Override
    public boolean m_6469_(DamageSource damageSource, float f) {
        ISummon summon;
        Entity directEntity;
        if (damageSource.m_276093_(DamageTypes.f_268724_)) {
            return super.m_6469_(damageSource, f);
        }
        if (!this.m_9236_().m_5776_() && this.f_19796_.m_188503_(10) != 0) {
            this.teleport();
        }
        if ((directEntity = damageSource.m_7639_()) == this.getOwner()) {
            return false;
        }
        if (directEntity instanceof ISummon && (summon = (ISummon)directEntity).getOwner() == this.getOwner()) {
            return false;
        }
        return super.m_6469_(damageSource, f);
    }

    public static AttributeSupplier.Builder createSummonAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22277_, 35.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22281_, 7.0).m_22268_(Attributes.f_22284_, 2.0).m_22268_(Attributes.f_22276_, 40.0).m_22266_(Attributes.f_22287_);
    }

    protected boolean teleport() {
        if (this.m_9236_().m_5776_() || !this.m_6084_()) {
            return false;
        }
        double d = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 64.0;
        double e = this.m_20186_() + (double)(this.f_19796_.m_188503_(64) - 32);
        double f = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 64.0;
        return this.teleport(d, e, f);
    }

    private boolean teleport(double x, double y, double z) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos(x, y, z);
        while (mutableBlockPos.m_123342_() > this.m_9236_().m_141937_() && !this.m_9236_().m_8055_((BlockPos)mutableBlockPos).m_280555_()) {
            mutableBlockPos.m_122173_(Direction.DOWN);
        }
        BlockState blockState = this.m_9236_().m_8055_((BlockPos)mutableBlockPos);
        boolean bl = blockState.m_280555_();
        boolean bl2 = blockState.m_60819_().m_205070_(FluidTags.f_13131_);
        if (!bl || bl2) {
            return false;
        }
        Vec3 vec3 = this.m_20182_();
        boolean bl3 = this.m_20984_(x, y, z, true);
        if (bl3) {
            this.m_9236_().m_214171_(GameEvent.f_238175_, vec3, GameEvent.Context.m_223717_((Entity)this));
            if (!this.m_20067_()) {
                this.m_9236_().m_6263_(null, this.f_19854_, this.f_19855_, this.f_19856_, SoundEvents.f_11852_, this.m_5720_(), 1.0f, 1.0f);
                this.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
            }
        }
        return bl3;
    }

    public void m_6710_(@Nullable LivingEntity target) {
        super.m_6710_(target);
        AttributeInstance attributeInstance = this.m_21051_(Attributes.f_22279_);
        if (target == null) {
            this.f_19804_.m_135381_(DATA_CREEPY, (Object)false);
            attributeInstance.m_22130_(SPEED_MODIFIER_ATTACKING);
        } else {
            this.f_19804_.m_135381_(DATA_CREEPY, (Object)true);
            if (!attributeInstance.m_22109_(SPEED_MODIFIER_ATTACKING)) {
                attributeInstance.m_22118_(SPEED_MODIFIER_ATTACKING);
            }
        }
    }

    public void playStareSound() {
        if (this.f_19797_ >= this.lastStareSound + 400) {
            this.lastStareSound = this.f_19797_;
            if (!this.m_20067_()) {
                this.m_9236_().m_7785_(this.m_20185_(), this.m_20188_(), this.m_20189_(), SoundEvents.f_11851_, this.m_5720_(), 2.5f, 1.0f, false);
            }
        }
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        if (DATA_CREEPY.equals(key) && this.m_9236_().f_46443_) {
            this.playStareSound();
        }
        super.m_7350_(key);
    }

    public boolean m_6126_() {
        return true;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_CREEPY, (Object)false);
    }

    public boolean isCreepy() {
        return (Boolean)this.f_19804_.m_135370_(DATA_CREEPY);
    }
}

