/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.summonerscrolls.common.item;

import com.github.teamfusion.summonerscrolls.common.registry.SummonerItems;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class SummonerCrossBow
extends ProjectileWeaponItem
implements Vanishable {
    private static final String TAG_CHARGED = "Charged";
    private static final String TAG_CHARGED_PROJECTILES = "ChargedProjectiles";
    private static final int MAX_CHARGE_DURATION = 25;
    public static final int DEFAULT_RANGE = 8;
    private boolean startSoundPlayed = false;
    private boolean midLoadSoundPlayed = false;
    private static final float START_SOUND_PERCENT = 0.2f;
    private static final float MID_SOUND_PERCENT = 0.5f;
    private static final float ARROW_POWER = 3.15f;
    private static final float FIREWORK_POWER = 1.6f;

    public SummonerCrossBow(Item.Properties properties) {
        super(properties);
    }

    public Predicate<ItemStack> m_6437_() {
        return arg -> arg.m_150930_(SummonerItems.SUMMON_ARROW.get());
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.m_21120_(interactionHand);
        if (SummonerCrossBow.isCharged(itemStack)) {
            SummonerCrossBow.performShooting(level, (LivingEntity)player, interactionHand, itemStack, SummonerCrossBow.getShootingPower(itemStack), 1.0f);
            SummonerCrossBow.setCharged(itemStack, false);
            return InteractionResultHolder.m_19096_((Object)itemStack);
        }
        this.startSoundPlayed = false;
        this.midLoadSoundPlayed = false;
        player.m_6672_(interactionHand);
        return InteractionResultHolder.m_19096_((Object)itemStack);
    }

    private static float getShootingPower(ItemStack itemStack) {
        return SummonerCrossBow.containsChargedProjectile(itemStack, Items.f_42688_) ? 1.6f : 3.15f;
    }

    public void m_5551_(ItemStack itemStack, Level level, LivingEntity livingEntity, int i) {
        int j = this.m_8105_(itemStack) - i;
        float f = SummonerCrossBow.getPowerForTime(j, itemStack);
        if (f >= 1.0f && !SummonerCrossBow.isCharged(itemStack) && SummonerCrossBow.tryLoadProjectiles(livingEntity, itemStack)) {
            SummonerCrossBow.setCharged(itemStack, true);
            SoundSource soundSource = livingEntity instanceof Player ? SoundSource.PLAYERS : SoundSource.HOSTILE;
            level.m_6263_(null, livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_(), SoundEvents.f_11841_, soundSource, 1.0f, 1.0f / (level.m_213780_().m_188501_() * 0.5f + 1.0f) + 0.2f);
        }
    }

    private static boolean tryLoadProjectiles(LivingEntity livingEntity, ItemStack itemStack) {
        int i = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44959_, (ItemStack)itemStack);
        int j = i == 0 ? 1 : 3;
        boolean bl = livingEntity instanceof Player && ((Player)livingEntity).m_150110_().f_35937_;
        ItemStack itemStack2 = livingEntity.m_6298_(itemStack);
        ItemStack itemStack3 = itemStack2.m_41777_();
        for (int k = 0; k < j; ++k) {
            if (k > 0) {
                itemStack2 = itemStack3.m_41777_();
            }
            if (itemStack2.m_41619_() && bl) {
                itemStack2 = new ItemStack((ItemLike)Items.f_42412_);
                itemStack3 = itemStack2.m_41777_();
            }
            SummonerCrossBow.addChargedProjectile(itemStack, SummonerItems.SUMMON_ARROW.get().m_7968_());
        }
        return true;
    }

    public static boolean isCharged(ItemStack itemStack) {
        CompoundTag compoundTag = itemStack.m_41783_();
        return compoundTag != null && compoundTag.m_128471_(TAG_CHARGED);
    }

    public static void setCharged(ItemStack itemStack, boolean bl) {
        CompoundTag compoundTag = itemStack.m_41784_();
        compoundTag.m_128379_(TAG_CHARGED, bl);
    }

    private static void addChargedProjectile(ItemStack itemStack, ItemStack itemStack2) {
        CompoundTag compoundTag = itemStack.m_41784_();
        ListTag listTag = compoundTag.m_128425_(TAG_CHARGED_PROJECTILES, 9) ? compoundTag.m_128437_(TAG_CHARGED_PROJECTILES, 10) : new ListTag();
        CompoundTag compoundTag2 = new CompoundTag();
        itemStack2.m_41739_(compoundTag2);
        listTag.add((Object)compoundTag2);
        compoundTag.m_128365_(TAG_CHARGED_PROJECTILES, (Tag)listTag);
    }

    private static List<ItemStack> getChargedProjectiles(ItemStack itemStack) {
        ArrayList list = Lists.newArrayList();
        CompoundTag compoundTag = itemStack.m_41783_();
        if (compoundTag != null && compoundTag.m_128425_(TAG_CHARGED_PROJECTILES, 9)) {
            ListTag listTag = compoundTag.m_128437_(TAG_CHARGED_PROJECTILES, 10);
            for (int i = 0; i < listTag.size(); ++i) {
                CompoundTag compoundTag2 = listTag.m_128728_(i);
                list.add(ItemStack.m_41712_((CompoundTag)compoundTag2));
            }
        }
        return list;
    }

    private static void clearChargedProjectiles(ItemStack itemStack) {
        CompoundTag compoundTag = itemStack.m_41783_();
        if (compoundTag != null) {
            ListTag listTag = compoundTag.m_128437_(TAG_CHARGED_PROJECTILES, 9);
            listTag.clear();
            compoundTag.m_128365_(TAG_CHARGED_PROJECTILES, (Tag)listTag);
        }
    }

    public static boolean containsChargedProjectile(ItemStack itemStack, Item item) {
        return SummonerCrossBow.getChargedProjectiles(itemStack).stream().anyMatch(itemStackx -> itemStackx.m_150930_(item));
    }

    private static void shootProjectile(Level level, LivingEntity livingEntity, InteractionHand interactionHand, ItemStack itemStack, ItemStack itemStack2, float f, boolean bl, float g, float h, float i) {
        if (!level.f_46443_) {
            AbstractArrow projectile;
            boolean bl2 = itemStack2.m_150930_(Items.f_42688_);
            if (bl2) {
                projectile = new FireworkRocketEntity(level, itemStack2, (Entity)livingEntity, livingEntity.m_20185_(), livingEntity.m_20188_() - (double)0.15f, livingEntity.m_20189_(), true);
            } else {
                projectile = SummonerCrossBow.getArrow(level, livingEntity, itemStack, itemStack2);
                if (bl || i != 0.0f) {
                    projectile.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                }
            }
            if (livingEntity instanceof CrossbowAttackMob) {
                CrossbowAttackMob crossbowAttackMob = (CrossbowAttackMob)livingEntity;
                crossbowAttackMob.m_5811_(crossbowAttackMob.m_5448_(), itemStack, (Projectile)projectile, i);
            } else {
                Vec3 vec3 = livingEntity.m_20289_(1.0f);
                Quaternionf quaternionf = new Quaternionf().setAngleAxis((double)(i * ((float)Math.PI / 180)), vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
                Vec3 vec32 = livingEntity.m_20252_(1.0f);
                Vector3f vector3f = vec32.m_252839_().rotate((Quaternionfc)quaternionf);
                ((Projectile)projectile).m_6686_((double)vector3f.x(), (double)vector3f.y(), (double)vector3f.z(), g, h);
            }
            itemStack.m_41622_(bl2 ? 3 : 1, livingEntity, livingEntityx -> livingEntityx.m_21190_(interactionHand));
            level.m_7967_((Entity)projectile);
            level.m_6263_((Player)null, livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_(), SoundEvents.f_11847_, SoundSource.PLAYERS, 1.0f, f);
        }
    }

    private static AbstractArrow getArrow(Level level, LivingEntity livingEntity, ItemStack itemStack, ItemStack itemStack2) {
        ArrowItem arrowItem = (ArrowItem)(itemStack2.m_41720_() instanceof ArrowItem ? itemStack2.m_41720_() : Items.f_42412_);
        AbstractArrow abstractArrow = arrowItem.m_6394_(level, itemStack2, livingEntity);
        if (livingEntity instanceof Player) {
            abstractArrow.m_36762_(true);
        }
        abstractArrow.m_36740_(SoundEvents.f_11840_);
        abstractArrow.m_36793_(true);
        int i = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44961_, (ItemStack)itemStack);
        if (i > 0) {
            abstractArrow.m_36767_((byte)i);
        }
        return abstractArrow;
    }

    public static void performShooting(Level level, LivingEntity livingEntity, InteractionHand interactionHand, ItemStack itemStack, float f, float g) {
        List<ItemStack> list = SummonerCrossBow.getChargedProjectiles(itemStack);
        float[] fs = SummonerCrossBow.getShotPitches(livingEntity.m_217043_());
        for (int i = 0; i < list.size(); ++i) {
            boolean bl;
            ItemStack itemStack2 = list.get(i);
            boolean bl2 = bl = livingEntity instanceof Player && ((Player)livingEntity).m_150110_().f_35937_;
            if (itemStack2.m_41619_()) continue;
            if (i == 0) {
                SummonerCrossBow.shootProjectile(level, livingEntity, interactionHand, itemStack, itemStack2, fs[i], bl, f, g, 0.0f);
                continue;
            }
            if (i == 1) {
                SummonerCrossBow.shootProjectile(level, livingEntity, interactionHand, itemStack, itemStack2, fs[i], bl, f, g, -10.0f);
                continue;
            }
            if (i != 2) continue;
            SummonerCrossBow.shootProjectile(level, livingEntity, interactionHand, itemStack, itemStack2, fs[i], bl, f, g, 10.0f);
        }
        SummonerCrossBow.onCrossbowShot(level, livingEntity, itemStack);
    }

    private static float[] getShotPitches(RandomSource randomSource) {
        boolean bl = randomSource.m_188499_();
        return new float[]{1.0f, SummonerCrossBow.getRandomShotPitch(bl, randomSource), SummonerCrossBow.getRandomShotPitch(!bl, randomSource)};
    }

    private static float getRandomShotPitch(boolean bl, RandomSource randomSource) {
        float f = bl ? 0.63f : 0.43f;
        return 1.0f / (randomSource.m_188501_() * 0.5f + 1.8f) + f;
    }

    private static void onCrossbowShot(Level level, LivingEntity livingEntity, ItemStack itemStack) {
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            if (!level.f_46443_) {
                CriteriaTriggers.f_10555_.m_65462_(serverPlayer, itemStack);
            }
            serverPlayer.m_36246_(Stats.f_12982_.m_12902_((Object)itemStack.m_41720_()));
        }
        SummonerCrossBow.clearChargedProjectiles(itemStack);
    }

    public void m_5929_(Level level, LivingEntity livingEntity, ItemStack itemStack, int i) {
        if (!level.f_46443_) {
            int j = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44960_, (ItemStack)itemStack);
            SoundEvent soundEvent = this.getStartSound(j);
            SoundEvent soundEvent2 = j == 0 ? SoundEvents.f_11842_ : null;
            float f = (float)(itemStack.m_41779_() - i) / (float)SummonerCrossBow.getChargeDuration(itemStack);
            if (f < 0.2f) {
                this.startSoundPlayed = false;
                this.midLoadSoundPlayed = false;
            }
            if (f >= 0.2f && !this.startSoundPlayed) {
                this.startSoundPlayed = true;
                level.m_6263_((Player)null, livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_(), soundEvent, SoundSource.PLAYERS, 0.5f, 1.0f);
            }
            if (f >= 0.5f && soundEvent2 != null && !this.midLoadSoundPlayed) {
                this.midLoadSoundPlayed = true;
                level.m_6263_((Player)null, livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_(), soundEvent2, SoundSource.PLAYERS, 0.5f, 1.0f);
            }
        }
    }

    public int m_8105_(ItemStack itemStack) {
        return SummonerCrossBow.getChargeDuration(itemStack) + 3;
    }

    public static int getChargeDuration(ItemStack itemStack) {
        int i = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44960_, (ItemStack)itemStack);
        return i == 0 ? 25 : 25 - 5 * i;
    }

    public UseAnim m_6164_(ItemStack itemStack) {
        return UseAnim.CROSSBOW;
    }

    private SoundEvent getStartSound(int i) {
        return switch (i) {
            case 1 -> SoundEvents.f_11844_;
            case 2 -> SoundEvents.f_11845_;
            case 3 -> SoundEvents.f_11846_;
            default -> SoundEvents.f_11843_;
        };
    }

    private static float getPowerForTime(int i, ItemStack itemStack) {
        float f = (float)i / (float)SummonerCrossBow.getChargeDuration(itemStack);
        if (f > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> list, TooltipFlag tooltipFlag) {
        List<ItemStack> list2 = SummonerCrossBow.getChargedProjectiles(itemStack);
        if (SummonerCrossBow.isCharged(itemStack) && !list2.isEmpty()) {
            ItemStack itemStack2 = list2.get(0);
            list.add((Component)Component.m_237115_((String)"item.minecraft.crossbow.projectile").m_7220_(CommonComponents.f_263701_).m_7220_(itemStack2.m_41611_()));
            if (tooltipFlag.m_7050_() && itemStack2.m_150930_(Items.f_42688_)) {
                ArrayList list3 = Lists.newArrayList();
                Items.f_42688_.m_7373_(itemStack2, level, (List)list3, tooltipFlag);
                if (!list3.isEmpty()) {
                    for (int i = 0; i < list3.size(); ++i) {
                        list3.set(i, Component.m_237113_((String)"  ").m_7220_((Component)list3.get(i)).m_130940_(ChatFormatting.GRAY));
                    }
                    list.addAll(list3);
                }
            }
        }
    }

    public boolean m_41463_(ItemStack itemStack) {
        return itemStack.m_150930_((Item)this);
    }

    public int m_6615_() {
        return 8;
    }
}

