/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.summonerscrolls.common.registry;

import com.github.teamfusion.summonerscrolls.common.entity.base.ISummon;
import com.github.teamfusion.summonerscrolls.common.item.ScrollItem;
import com.github.teamfusion.summonerscrolls.common.util.ScrollUtil;
import com.github.teamfusion.summonerscrolls.common.util.cooldowns.SummonerItemCooldowns;
import com.github.teamfusion.summonerscrolls.common.util.methodHolders.SummonerPlayerMixinHolder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;

public class SummonerEvents {
    public static void useScroll(Player player, InteractionHand hand) {
        Level level = player.m_9236_();
        ItemStack itemStack = player.m_21120_(hand);
        Item item = itemStack.m_41720_();
        if (!itemStack.m_41782_()) {
            return;
        }
        CompoundTag nbt = itemStack.m_41784_();
        if (!level.m_5776_() && ScrollUtil.hasScrollProperties(nbt)) {
            boolean isCreative = player.m_7500_();
            int xpCost = ScrollUtil.getCost(nbt);
            int entityCount = ScrollUtil.getEntityCount(nbt);
            int damage = ScrollUtil.getDamage(nbt);
            SummonerItemCooldowns summonerCooldowns = ((SummonerPlayerMixinHolder)player).summonerscrolls$getSummonerCooldowns();
            if (summonerCooldowns.isOnCooldown(itemStack)) {
                float cooldownTicks = summonerCooldowns.getCooldownPercent(itemStack, 0.0f);
                int remainingTicks = (int)(cooldownTicks * 600.0f);
                int remainingSeconds = Math.max(1, remainingTicks / 20);
                player.m_5661_((Component)Component.m_237110_((String)"message.summonerscrolls.cooldown", (Object[])new Object[]{remainingSeconds}), true);
                return;
            }
            if (!isCreative) {
                if (player.f_36078_ < xpCost) {
                    player.m_5661_((Component)Component.m_237110_((String)"message.summonerscrolls.not_enough_xp", (Object[])new Object[]{xpCost}), true);
                    return;
                }
                player.m_6749_(-xpCost);
                summonerCooldowns.addCooldown(itemStack, 1200);
                if (item instanceof ScrollItem) {
                    itemStack.m_220157_(1, level.f_46441_, (ServerPlayer)player);
                } else {
                    itemStack.m_220157_(damage, level.f_46441_, (ServerPlayer)player);
                }
            }
            EntityType<?> entityType = ScrollUtil.getEntityType(nbt);
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos spawnPos = player.m_20183_().m_121955_(player.m_6350_().m_122436_());
            for (int i = 0; i < entityCount; ++i) {
                Entity entity = entityType.m_20592_(serverLevel, itemStack, player, spawnPos, MobSpawnType.MOB_SUMMONED, true, true);
                if (!(entity instanceof ISummon)) continue;
                ISummon summon = (ISummon)entity;
                summon.setOwnerUUID(player.m_20148_());
                summon.setDespawnDelay(600 + level.m_213780_().m_188503_(10));
                player.m_5661_((Component)Component.m_237110_((String)"message.summonerscrolls.summon_success", (Object[])new Object[]{entity.m_5446_().getString()}), true);
                int count = 80;
                for (int j = 0; j < count; ++j) {
                    Level world = entity.m_9236_();
                    RandomSource random = world.m_213780_();
                    float horizontal = (float)random.m_216339_(-10, 10) * 0.125f;
                    float vertical = (float)random.m_216339_(-8, 8) * 0.125f;
                    ((ServerLevel)world).m_8767_((ParticleOptions)ParticleTypes.f_123759_, entity.m_20185_(), entity.m_20186_() + (double)(entity.m_20206_() / 2.0f), entity.m_20189_(), 1, (double)horizontal, (double)vertical, (double)horizontal, 0.0);
                }
            }
            player.m_6330_(SoundEvents.f_11868_, SoundSource.PLAYERS, 1.0f, 1.0f);
            level.m_142346_((Entity)player, GameEvent.f_157810_, spawnPos);
        }
    }
}

