/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.summonerscrolls.mixin;

import com.github.teamfusion.summonerscrolls.common.recipe.AnvilScrollRecipe;
import com.github.teamfusion.summonerscrolls.common.util.ScrollUtil;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import java.util.Map;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.ItemCombinerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={AnvilMenu.class})
public abstract class AnvilMenuMixin
extends ItemCombinerMenu {
    @Shadow
    private String f_39001_;
    @Shadow
    @Final
    public DataSlot f_39002_;
    @Shadow
    private int f_39000_;
    @Unique
    private boolean usedScrollRecipe = false;

    @Shadow
    public abstract int m_39028_();

    public AnvilMenuMixin(@Nullable MenuType<?> menuType, int i, Inventory inventory, ContainerLevelAccess containerLevelAccess) {
        super(menuType, i, inventory, containerLevelAccess);
    }

    @Inject(method={"createResult"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;isEmpty()Z", ordinal=1, shift=At.Shift.BEFORE)}, locals=LocalCapture.CAPTURE_FAILHARD, cancellable=true)
    private void createResult(CallbackInfo ci, ItemStack stack, int i, int j, int k, ItemStack left, ItemStack right, Map<Enchantment, Integer> map) {
        AnvilMenu anvilMenu = (AnvilMenu)this;
        ItemStack leftStack = this.f_39769_.m_8020_(0);
        ItemStack rightStack = this.f_39769_.m_8020_(1);
        SimpleContainer tempContainer = new SimpleContainer(new ItemStack[]{leftStack, rightStack});
        Level level = this.f_39771_.m_9236_();
        RecipeManager recipeManager = level.m_7465_();
        Optional scrollRecipe = recipeManager.m_44015_((RecipeType)AnvilScrollRecipe.Type.INSTANCE, (Container)tempContainer, level);
        if (scrollRecipe.isPresent()) {
            AnvilScrollRecipe recipe = (AnvilScrollRecipe)scrollRecipe.get();
            ItemStack result = recipe.m_5874_((Container)tempContainer, (RegistryAccess)RegistryAccess.f_243945_);
            this.f_39768_.m_6836_(0, result);
            this.usedScrollRecipe = true;
            int nameCost = 0;
            if (this.f_39001_ != null && !Util.m_288217_((String)this.f_39001_)) {
                if (!this.f_39001_.equals(leftStack.m_41786_().getString())) {
                    result.m_41714_((Component)Component.m_237113_((String)this.f_39001_));
                }
                ++nameCost;
            } else if (leftStack.m_41788_()) {
                result.m_41787_();
            }
            anvilMenu.f_39002_.m_6422_(Math.max(recipe.getCost() + nameCost, 0));
            this.m_38946_();
            ci.cancel();
        } else {
            this.usedScrollRecipe = false;
        }
        if (!ScrollUtil.applyScrollToItemInAnvil(anvilMenu, left, right, (Container)this.f_39768_, this.f_39001_)) {
            ci.cancel();
        }
    }

    @Inject(method={"onTake"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/Container;setItem(ILnet/minecraft/world/item/ItemStack;)V")})
    private void onTake(Player player, ItemStack itemStack, CallbackInfo ci) {
        if (this.usedScrollRecipe) {
            this.f_39000_ = 1;
        }
    }

    @ModifyReturnValue(method={"mayPickup"}, at={@At(value="RETURN")})
    private boolean allowPickup(boolean original) {
        return original || this.usedScrollRecipe && this.m_39028_() == 0;
    }
}

