/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.slope;

import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.model.data.QuadMap;
import xfacthd.framedblocks.api.model.geometry.Geometry;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.model.wrapping.GeometryFactory;
import xfacthd.framedblocks.api.model.wrapping.itemmodel.ItemModelInfo;
import xfacthd.framedblocks.api.model.wrapping.itemmodel.TranslatedItemModelInfo;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.client.model.slopepanel.FramedSlopePanelGeometry;
import xfacthd.framedblocks.client.model.slopeslab.FramedSlopeSlabGeometry;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.PillarConnection;

public class FramedPyramidGeometry
extends Geometry {
    static final Vector3f BOTTOM_CENTER = new Vector3f(0.5f, 0.0f, 0.5f);
    static final Vector3f TOP_CENTER = new Vector3f(0.5f, 1.0f, 0.5f);
    static final Vector3f ZERO = new Vector3f();
    final Direction facing;
    final boolean ySlope;
    final boolean hasPillar;
    final float slopeHeight;
    private final float pillarHeight;
    private final float pillarWidth;
    private final float pillarFaceMin;
    private final float pillarFaceMax;

    public FramedPyramidGeometry(GeometryFactory.Context ctx) {
        this.facing = (Direction)ctx.state().getValue((Property)BlockStateProperties.FACING);
        this.ySlope = (Boolean)ctx.state().getValue((Property)FramedProperties.Y_SLOPE);
        PillarConnection pillar = (PillarConnection)((Object)ctx.state().getValue(PropertyHolder.PILLAR_CONNECTION));
        this.hasPillar = pillar != PillarConnection.NONE;
        this.slopeHeight = this.computeSlopeHeight(pillar);
        this.pillarHeight = this.computePillarHeight(pillar);
        this.pillarWidth = switch (pillar) {
            default -> throw new MatchException(null, null);
            case PillarConnection.NONE -> 0.0f;
            case PillarConnection.POST -> 0.625f;
            case PillarConnection.PILLAR -> 0.75f;
        };
        float pillarFaceRadius = switch (pillar) {
            default -> throw new MatchException(null, null);
            case PillarConnection.NONE -> 0.0f;
            case PillarConnection.POST -> 0.125f;
            case PillarConnection.PILLAR -> 0.25f;
        };
        this.pillarFaceMin = 0.5f - pillarFaceRadius;
        this.pillarFaceMax = 0.5f + pillarFaceRadius;
    }

    @Override
    public final void transformQuad(QuadMap quadMap, BakedQuad quad) {
        Direction quadDir = quad.getDirection();
        this.buildBody(quadMap, quad, quadDir);
        if (this.hasPillar) {
            this.buildPillar(quadMap, quad, quadDir);
        }
    }

    protected void buildBody(QuadMap quadMap, BakedQuad quad, Direction quadDir) {
        if (Utils.isY(this.facing)) {
            boolean up;
            boolean bl = up = this.facing == Direction.UP;
            if (!this.ySlope && quadDir.getAxis() != this.facing.getAxis()) {
                QuadModifier.of(quad).applyIf(Modifiers.cutSideUpDown(!up, this.slopeHeight), this.hasPillar).apply(Modifiers.cutSideLeftRight(false, up ? 0.5f : 1.0f, up ? 1.0f : 0.5f)).apply(Modifiers.cutSideLeftRight(true, up ? 0.5f : 1.0f, up ? 1.0f : 0.5f)).apply(Modifiers.makeVerticalSlope(up, FramedSlopePanelGeometry.SLOPE_ANGLE)).export(quadMap.get(null));
            } else if (this.ySlope && quadDir == this.facing) {
                for (Direction dir : Direction.Plane.HORIZONTAL) {
                    float angle = up ? -FramedSlopePanelGeometry.SLOPE_ANGLE : FramedSlopePanelGeometry.SLOPE_ANGLE;
                    angle = (up ? -90.0f : 90.0f) - angle;
                    if (dir == Direction.NORTH || dir == Direction.EAST) {
                        angle *= -1.0f;
                    }
                    Vector3f origin = up ? TOP_CENTER : BOTTOM_CENTER;
                    QuadModifier.of(quad).applyIf(Modifiers.cutTopBottom(dir, this.slopeHeight), this.hasPillar).apply(Modifiers.cutTopBottom(dir.getCounterClockWise(), 0.5f, 1.0f)).apply(Modifiers.cutTopBottom(dir.getClockWise(), 1.0f, 0.5f)).apply(Modifiers.offset(dir.getOpposite(), 0.5f)).apply(Modifiers.rotate(dir.getClockWise().getAxis(), origin, angle, true)).export(quadMap.get(null));
                }
            }
        } else if (!this.ySlope && quadDir.getAxis() == this.facing.getAxis()) {
            QuadModifier.of(quad).applyIf(Modifiers.cutSideUpDown(true, this.slopeHeight), this.hasPillar).apply(Modifiers.cutSideLeftRight(this.facing.getClockWise(), 1.0f, 0.5f)).apply(Modifiers.cutSideLeftRight(this.facing.getCounterClockWise(), 1.0f, 0.5f)).apply(Modifiers.makeVerticalSlope(true, FramedSlopeSlabGeometry.SLOPE_ANGLE)).apply(Modifiers.offset(Direction.UP, 0.5f)).export(quadMap.get(null));
            QuadModifier.of(quad).applyIf(Modifiers.cutSideUpDown(false, this.slopeHeight), this.hasPillar).apply(Modifiers.cutSideLeftRight(this.facing.getClockWise(), 0.5f, 1.0f)).apply(Modifiers.cutSideLeftRight(this.facing.getCounterClockWise(), 0.5f, 1.0f)).apply(Modifiers.makeVerticalSlope(false, FramedSlopeSlabGeometry.SLOPE_ANGLE)).apply(Modifiers.offset(Direction.DOWN, 0.5f)).export(quadMap.get(null));
        } else if (this.ySlope && Utils.isY(quadDir)) {
            float angle;
            boolean up = quadDir == Direction.UP;
            float f = angle = up ? FramedSlopePanelGeometry.SLOPE_ANGLE : -FramedSlopePanelGeometry.SLOPE_ANGLE;
            if (this.facing == Direction.NORTH || this.facing == Direction.EAST) {
                angle *= -1.0f;
            }
            Vector3f origin = this.facing.getOpposite().step().max((Vector3fc)ZERO);
            if (up) {
                origin.add(0.0f, 1.0f, 0.0f);
            }
            QuadModifier.of(quad).applyIf(Modifiers.cutTopBottom(this.facing, this.slopeHeight), this.hasPillar).apply(Modifiers.cutTopBottom(this.facing.getCounterClockWise(), 0.5f, 1.0f)).apply(Modifiers.cutTopBottom(this.facing.getClockWise(), 1.0f, 0.5f)).apply(Modifiers.rotate(this.facing.getClockWise().getAxis(), origin, angle, true)).export(quadMap.get(null));
        } else if (quadDir.getAxis() == this.facing.getClockWise().getAxis()) {
            boolean right = quadDir == this.facing.getClockWise();
            QuadModifier.of(quad).applyIf(Modifiers.cutSideLeftRight(this.facing, this.slopeHeight), this.hasPillar).apply(Modifiers.cutSideUpDown(true, right ? 1.0f : 0.5f, right ? 0.5f : 1.0f)).apply(Modifiers.cutSideUpDown(false, right ? 1.0f : 0.5f, right ? 0.5f : 1.0f)).apply(Modifiers.makeHorizontalSlope(!right, FramedSlopePanelGeometry.SLOPE_ANGLE)).export(quadMap.get(null));
        }
    }

    private void buildPillar(QuadMap quadMap, BakedQuad quad, Direction quadDir) {
        if (Utils.isY(this.facing)) {
            if (quadDir == this.facing) {
                QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.pillarFaceMin, this.pillarFaceMin, this.pillarFaceMax, this.pillarFaceMax)).export(quadMap.get(quadDir));
            } else if (quadDir != this.facing.getOpposite()) {
                QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(this.facing == Direction.UP, this.pillarHeight)).apply(Modifiers.cutSideLeftRight(this.pillarWidth)).apply(Modifiers.setPosition(this.pillarWidth)).export(quadMap.get(null));
            }
        } else if (Utils.isY(quadDir)) {
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.facing.getOpposite(), this.pillarHeight)).apply(Modifiers.cutTopBottom(this.facing.getClockWise().getAxis(), this.pillarWidth)).apply(Modifiers.setPosition(this.pillarWidth)).export(quadMap.get(null));
        } else if (quadDir == this.facing) {
            QuadModifier.of(quad).apply(Modifiers.cutSide(this.pillarFaceMin, this.pillarFaceMin, this.pillarFaceMax, this.pillarFaceMax)).export(quadMap.get(quadDir));
        } else if (quadDir != this.facing.getOpposite()) {
            QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(this.facing.getOpposite(), this.pillarHeight)).apply(Modifiers.cutSideUpDown(this.pillarWidth)).apply(Modifiers.setPosition(this.pillarWidth)).export(quadMap.get(null));
        }
    }

    protected float computeSlopeHeight(PillarConnection pillar) {
        return switch (pillar) {
            default -> throw new MatchException(null, null);
            case PillarConnection.NONE -> 1.0f;
            case PillarConnection.POST -> 0.75f;
            case PillarConnection.PILLAR -> 0.5f;
        };
    }

    protected float computePillarHeight(PillarConnection pillar) {
        return switch (pillar) {
            default -> throw new MatchException(null, null);
            case PillarConnection.NONE -> 0.0f;
            case PillarConnection.POST -> 0.25f;
            case PillarConnection.PILLAR -> 0.5f;
        };
    }

    @Override
    public ItemModelInfo getItemModelInfo() {
        return TranslatedItemModelInfo.HAND_Y_HALF_UP;
    }
}

