/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.prism;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.AbstractFramedDoubleBlock;
import xfacthd.framedblocks.common.block.prism.FramedSlopedPrismBlock;
import xfacthd.framedblocks.common.block.prism.IFramedPrismBlock;
import xfacthd.framedblocks.common.blockentity.doubled.prism.FramedElevatedDoubleSlopedPrismBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.doubleblock.CamoGetter;
import xfacthd.framedblocks.common.data.doubleblock.DoubleBlockTopInteractionMode;
import xfacthd.framedblocks.common.data.doubleblock.SolidityCheck;
import xfacthd.framedblocks.common.data.property.CompoundDirection;

public class FramedElevatedDoubleSlopedPrismBlock
extends AbstractFramedDoubleBlock
implements IFramedPrismBlock {
    public FramedElevatedDoubleSlopedPrismBlock(BlockType type) {
        super(type);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{PropertyHolder.FACING_DIR, FramedProperties.Y_SLOPE});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return FramedSlopedPrismBlock.getStateForPlacement(context, this);
    }

    @Override
    public boolean handleBlockLeftClick(BlockState state, Level level, BlockPos pos, Player player) {
        return IFramedBlock.toggleYSlope(state, level, pos, player);
    }

    protected BlockState rotate(BlockState state, Rotation rot) {
        CompoundDirection cmpDir = (CompoundDirection)((Object)state.getValue(PropertyHolder.FACING_DIR));
        return (BlockState)state.setValue(PropertyHolder.FACING_DIR, (Comparable)((Object)cmpDir.rotate(rot)));
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        CompoundDirection cmpDir = (CompoundDirection)((Object)state.getValue(PropertyHolder.FACING_DIR));
        return (BlockState)state.setValue(PropertyHolder.FACING_DIR, (Comparable)((Object)cmpDir.mirror(mirror)));
    }

    @Override
    public Tuple<BlockState, BlockState> calculateBlockPair(BlockState state) {
        CompoundDirection cmpDir = (CompoundDirection)((Object)state.getValue(PropertyHolder.FACING_DIR));
        boolean ySlope = (Boolean)state.getValue((Property)FramedProperties.Y_SLOPE);
        return new Tuple((Object)((BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_ELEVATED_INNER_SLOPED_PRISM.value()).defaultBlockState().setValue(PropertyHolder.FACING_DIR, (Comparable)((Object)cmpDir))).setValue((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(ySlope))), (Object)((BlockState)((BlockState)((Block)FBContent.BLOCK_FRAMED_SLOPED_PRISM.value()).defaultBlockState().setValue(PropertyHolder.FACING_DIR, (Comparable)((Object)CompoundDirection.of(cmpDir.direction().getOpposite(), cmpDir.orientation())))).setValue((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(ySlope))));
    }

    @Override
    public DoubleBlockTopInteractionMode calculateTopInteractionMode(BlockState state) {
        CompoundDirection cmpDir = (CompoundDirection)((Object)state.getValue(PropertyHolder.FACING_DIR));
        if (cmpDir.direction() == Direction.UP) {
            return DoubleBlockTopInteractionMode.SECOND;
        }
        if (cmpDir.direction() == Direction.DOWN || cmpDir.orientation() != Direction.UP) {
            return DoubleBlockTopInteractionMode.FIRST;
        }
        return DoubleBlockTopInteractionMode.EITHER;
    }

    @Override
    public CamoGetter calculateCamoGetter(BlockState state, Direction side, @Nullable Direction edge) {
        CompoundDirection cmpDir = (CompoundDirection)((Object)state.getValue(PropertyHolder.FACING_DIR));
        Direction facing = cmpDir.direction();
        if (side == facing) {
            return CamoGetter.SECOND;
        }
        if (side == cmpDir.orientation()) {
            if (edge == facing) {
                return CamoGetter.SECOND;
            }
            if (edge != null) {
                return CamoGetter.FIRST;
            }
            return CamoGetter.NONE;
        }
        return CamoGetter.FIRST;
    }

    @Override
    public SolidityCheck calculateSolidityCheck(BlockState state, Direction side) {
        CompoundDirection cmpDir = (CompoundDirection)((Object)state.getValue(PropertyHolder.FACING_DIR));
        Direction facing = cmpDir.direction();
        if (side == facing) {
            return SolidityCheck.SECOND;
        }
        if (side == cmpDir.orientation()) {
            return SolidityCheck.BOTH;
        }
        return SolidityCheck.FIRST;
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new FramedElevatedDoubleSlopedPrismBlockEntity(pos, state);
    }

    @Override
    public BlockState getItemModelSource() {
        boolean inner = this.getBlockType() == BlockType.FRAMED_ELEVATED_INNER_DOUBLE_SLOPED_PRISM;
        CompoundDirection cmpDir = inner ? CompoundDirection.UP_EAST : CompoundDirection.UP_WEST;
        return (BlockState)this.defaultBlockState().setValue(PropertyHolder.FACING_DIR, (Comparable)((Object)cmpDir));
    }

    @Override
    public BlockState getJadeRenderState(BlockState state) {
        return this.getItemModelSource();
    }

    @Override
    public boolean isInnerPrism() {
        return this.getBlockType() == BlockType.FRAMED_ELEVATED_INNER_DOUBLE_SLOPED_PRISM;
    }
}

