/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds.misc;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.predicate.cull.SideSkipPredicate;
import xfacthd.framedblocks.common.blockentity.special.ICollapsibleCopycatBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.skippreds.CullTest;

@CullTest(value={BlockType.FRAMED_COLLAPSIBLE_COPYCAT_BLOCK})
public final class CollapsibleCopycatBlockSkipPredicate
implements SideSkipPredicate {
    private static final Direction[] DIRECTIONS = Direction.values();

    @Override
    @CullTest.TestTarget(value={BlockType.FRAMED_COLLAPSIBLE_COPYCAT_BLOCK})
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        if (adjState.getBlock() == state.getBlock()) {
            int solid = (Integer)state.getValue((Property)PropertyHolder.SOLID_FACES);
            if ((solid & 1 << side.ordinal()) == 0) {
                return false;
            }
            int adjSolid = (Integer)adjState.getValue((Property)PropertyHolder.SOLID_FACES);
            if ((adjSolid & 1 << side.getOpposite().ordinal()) == 0) {
                return false;
            }
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (!(blockEntity instanceof ICollapsibleCopycatBlockEntity)) {
                return false;
            }
            ICollapsibleCopycatBlockEntity be = (ICollapsibleCopycatBlockEntity)blockEntity;
            Direction[] directionArray = level.getBlockEntity(pos.relative(side));
            if (!(directionArray instanceof ICollapsibleCopycatBlockEntity)) {
                return false;
            }
            ICollapsibleCopycatBlockEntity adjBe = (ICollapsibleCopycatBlockEntity)directionArray;
            for (Direction face : DIRECTIONS) {
                int adjOffset;
                int offset;
                if (face.getAxis() == side.getAxis() || (offset = be.getFaceOffset(state, face)) == (adjOffset = adjBe.getFaceOffset(adjState, face))) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

