/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.datagen.builders.book.chapter;

import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import xfacthd.framedblocks.common.datagen.builders.book.elements.ElementBuilder;
import xfacthd.framedblocks.common.datagen.builders.book.elements.SimpleContainerElementBuilder;
import xfacthd.framedblocks.common.datagen.builders.book.elements.attributes.ElementCategory;
import xfacthd.framedblocks.common.datagen.builders.book.includes.IncludeHolder;
import xfacthd.framedblocks.common.datagen.builders.book.primitives.BookRoot;
import xfacthd.framedblocks.common.datagen.builders.book.primitives.Identifiable;
import xfacthd.framedblocks.common.datagen.builders.book.primitives.Printable;
import xfacthd.framedblocks.common.datagen.builders.book.primitives.Validatable;

public final class SectionBuilder
extends IncludeHolder<SectionBuilder>
implements Printable,
Validatable,
Identifiable {
    private final String type;
    private final String id;
    private final List<ElementBuilder> elements = new ArrayList<ElementBuilder>();
    private SimpleContainerElementBuilder title = null;
    private String condition = null;

    public SectionBuilder(String type, String id) {
        this.type = type;
        this.id = id;
    }

    public SectionBuilder condition(String condition) {
        this.condition = condition;
        return this;
    }

    public SectionBuilder pageTitle(SimpleContainerElementBuilder title) {
        this.title = title;
        return this;
    }

    public SectionBuilder element(ElementBuilder element) {
        if (!ElementCategory.PAGE.allows(element.getCategory())) {
            throw new IllegalArgumentException("Element '%s' is not a page-level element".formatted(this.getClass().getSimpleName()));
        }
        this.elements.add(element);
        return this;
    }

    @Override
    public String getName() {
        return this.id;
    }

    @Override
    public void validate(BookRoot book) {
        if (this.condition != null && !book.hasCondition(this.condition)) {
            throw new IllegalArgumentException("Unknown condition: " + this.condition);
        }
    }

    @Override
    public void print(Document doc, Element parentElem) {
        Element sectionElem = doc.createElement(this.type);
        sectionElem.setAttribute("id", this.id);
        if (this.condition != null) {
            sectionElem.setAttribute("condition", this.condition);
        }
        if (this.title != null) {
            Element pageTitleElem = doc.createElement("page_title");
            this.title.print(doc, pageTitleElem);
            sectionElem.appendChild(pageTitleElem);
        }
        this.elements.forEach(elem -> elem.print(doc, sectionElem));
        this.includes.forEach((name, inc) -> inc.print(doc, sectionElem));
        parentElem.appendChild(sectionElem);
    }
}

