/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.cube;

import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.model.data.QuadMap;
import xfacthd.framedblocks.api.model.geometry.Geometry;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.model.wrapping.GeometryFactory;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.data.PropertyHolder;

public class FramedTubeGeometry
extends Geometry {
    private final Direction.Axis axis;
    private final float thickness;

    public FramedTubeGeometry(GeometryFactory.Context ctx) {
        this.axis = (Direction.Axis)ctx.state().getValue((Property)BlockStateProperties.AXIS);
        this.thickness = (Boolean)ctx.state().getValue((Property)PropertyHolder.THICK) != false ? 3.0f : 2.0f;
    }

    @Override
    public void transformQuad(QuadMap quadMap, BakedQuad quad) {
        Direction quadDir = quad.getDirection();
        if (this.axis == Direction.Axis.Y) {
            if (quadDir.getAxis() == this.axis) {
                QuadModifier.of(quad).apply(Modifiers.cutTopBottom(Direction.NORTH, this.thickness / 16.0f)).export(quadMap.get(quadDir));
                QuadModifier.of(quad).apply(Modifiers.cutTopBottom(Direction.SOUTH, this.thickness / 16.0f)).export(quadMap.get(quadDir));
                QuadModifier.of(quad).apply(Modifiers.cutTopBottom(Direction.EAST, this.thickness / 16.0f)).apply(Modifiers.cutTopBottom(Direction.Axis.Z, (16.0f - this.thickness) / 16.0f)).export(quadMap.get(quadDir));
                QuadModifier.of(quad).apply(Modifiers.cutTopBottom(Direction.WEST, this.thickness / 16.0f)).apply(Modifiers.cutTopBottom(Direction.Axis.Z, (16.0f - this.thickness) / 16.0f)).export(quadMap.get(quadDir));
            } else {
                QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight((16.0f - this.thickness) / 16.0f)).apply(Modifiers.setPosition(this.thickness / 16.0f)).export(quadMap.get(null));
            }
        } else if (quadDir.getAxis() == this.axis) {
            QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(false, this.thickness / 16.0f)).export(quadMap.get(quadDir));
            QuadModifier.of(quad).apply(Modifiers.cutSideUpDown(true, this.thickness / 16.0f)).export(quadMap.get(quadDir));
            QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(quadDir.getClockWise(), this.thickness / 16.0f)).apply(Modifiers.cutSideUpDown((16.0f - this.thickness) / 16.0f)).export(quadMap.get(quadDir));
            QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(quadDir.getCounterClockWise(), this.thickness / 16.0f)).apply(Modifiers.cutSideUpDown((16.0f - this.thickness) / 16.0f)).export(quadMap.get(quadDir));
        } else if (Utils.isY(quadDir)) {
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(Utils.nextAxisNotEqualTo(this.axis, Direction.Axis.Y), (16.0f - this.thickness) / 16.0f)).apply(Modifiers.setPosition(this.thickness / 16.0f)).export(quadMap.get(null));
        } else {
            QuadModifier.of(quad).apply(Modifiers.cutSideUpDown((16.0f - this.thickness) / 16.0f)).apply(Modifiers.setPosition(this.thickness / 16.0f)).export(quadMap.get(null));
        }
    }

    @Override
    public boolean transformAllQuads() {
        return true;
    }
}

