/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.screen;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.util.Arrays;
import java.util.stream.IntStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.font.TextFieldHelper;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.FastColor;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.RenderTypeHelper;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.network.PacketDistributor;
import org.joml.Matrix4f;
import xfacthd.framedblocks.api.render.Quaternions;
import xfacthd.framedblocks.common.block.sign.AbstractFramedHangingSignBlock;
import xfacthd.framedblocks.common.block.sign.AbstractFramedSignBlock;
import xfacthd.framedblocks.common.blockentity.special.FramedSignBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.net.payload.ServerboundSignUpdatePayload;

public class FramedSignScreen
extends Screen {
    private static final Component TITLE_NORMAL = Component.translatable((String)"sign.edit");
    private static final Component TITLE_HANGING = Component.translatable((String)"hanging_sign.edit");
    private static final SignConfig CFG_STANDING = new SignConfig(90.0f, 56.0f, 95.0f, 0.0f, 1.0f);
    private static final SignConfig CFG_WALL = new SignConfig(90.0f, 56.0f, 95.0f, 30.0f, 1.0f);
    private static final SignConfig CFG_HANGING = new SignConfig(100.0f, 30.0f, 75.0f, 26.0f, 1.0f);
    private final AbstractFramedSignBlock signBlock;
    private final FramedSignBlockEntity sign;
    private final boolean front;
    private final SignConfig signConfig;
    private SignText text;
    private final String[] lines;
    private int blinkCounter = 0;
    private int currLine = 0;
    private TextFieldHelper inputUtil;

    public FramedSignScreen(FramedSignBlockEntity sign, boolean front) {
        super(FramedSignScreen.getTitle(sign));
        this.signBlock = (AbstractFramedSignBlock)sign.getBlockState().getBlock();
        this.sign = sign;
        this.front = front;
        this.text = sign.getText(front);
        boolean filtered = Minecraft.getInstance().isTextFilteringEnabled();
        this.lines = (String[])IntStream.range(0, 4).mapToObj(idx -> this.text.getMessage(idx, filtered)).map(Component::getString).toArray(String[]::new);
        this.signConfig = switch ((BlockType)sign.getBlockType()) {
            case BlockType.FRAMED_SIGN -> CFG_STANDING;
            case BlockType.FRAMED_WALL_SIGN -> CFG_WALL;
            case BlockType.FRAMED_HANGING_SIGN, BlockType.FRAMED_WALL_HANGING_SIGN -> CFG_HANGING;
            default -> throw new IllegalArgumentException("Invalid block type: " + String.valueOf(sign.getBlockType()));
        };
    }

    private static Component getTitle(FramedSignBlockEntity be) {
        boolean hanging = be.getBlockState().getBlock() instanceof AbstractFramedHangingSignBlock;
        return hanging ? TITLE_HANGING : TITLE_NORMAL;
    }

    protected void init() {
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_DONE, btn -> Minecraft.getInstance().setScreen(null)).pos(this.width / 2 - 100, this.height / 4 + 144).size(200, 20).build());
        this.inputUtil = new TextFieldHelper(() -> this.lines[this.currLine], this::setLine, TextFieldHelper.createClipboardGetter((Minecraft)this.minecraft), TextFieldHelper.createClipboardSetter((Minecraft)this.minecraft), line -> this.minecraft.font.width(line) <= this.signBlock.getMaxTextLineWidth());
    }

    private void setLine(String line) {
        this.lines[this.currLine] = line;
        this.text = this.text.setMessage(this.currLine, (Component)Component.literal((String)line));
        this.sign.setText(this.text, this.front);
    }

    public void removed() {
        PacketDistributor.sendToServer((CustomPacketPayload)new ServerboundSignUpdatePayload(this.sign.getBlockPos(), this.front, Arrays.copyOf(this.lines, this.lines.length)), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void tick() {
        ++this.blinkCounter;
        if (this.minecraft != null && this.minecraft.player != null && (this.sign.isRemoved() || this.sign.isTooFarAwayToEdit((Player)this.minecraft.player))) {
            Minecraft.getInstance().setScreen(null);
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    public boolean charTyped(char character, int modifiers) {
        this.inputUtil.charTyped(character);
        return true;
    }

    public boolean keyPressed(int key, int scanCode, int modifiers) {
        if (key == 265) {
            this.currLine = this.currLine - 1 & 3;
            this.inputUtil.setCursorToEnd();
            return true;
        }
        if (key == 264 || key == 257 || key == 335) {
            this.currLine = this.currLine + 1 & 3;
            this.inputUtil.setCursorToEnd();
            return true;
        }
        return this.inputUtil.keyPressed(key) || super.keyPressed(key, scanCode, modifiers);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        Lighting.setupForFlatItems();
        graphics.drawCenteredString(this.font, this.title, this.width / 2, 40, 0xFFFFFF);
        this.drawSign(graphics);
        Lighting.setupFor3DItems();
    }

    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.renderTransparentBackground(graphics);
    }

    private void drawSign(GuiGraphics graphics) {
        graphics.pose().pushPose();
        graphics.pose().translate((float)this.width / 2.0f, this.signConfig.baseYOff, 150.0f);
        graphics.pose().pushPose();
        Lighting.setupLevel();
        RenderSystem.runAsFancy(() -> this.drawSignBlock(graphics));
        Lighting.setupForFlatItems();
        graphics.pose().popPose();
        this.drawText(graphics);
        graphics.pose().popPose();
    }

    private void drawSignBlock(GuiGraphics graphics) {
        BlockState state = this.sign.getBlockState();
        PoseStack poseStack = graphics.pose();
        poseStack.translate(0.0f, this.signConfig.addYOff, 0.0f);
        poseStack.mulPose(Axis.YN.rotationDegrees(this.signBlock.getYRotationDegrees(state)));
        poseStack.mulPose(Quaternions.ZP_180);
        poseStack.scale(this.signConfig.signScale, this.signConfig.signScale, this.signConfig.signScale);
        poseStack.translate(-0.5, -0.25, -0.5);
        BlockRenderDispatcher renderer = this.minecraft.getBlockRenderer();
        MultiBufferSource.BufferSource buffer = graphics.bufferSource();
        PoseStack.Pose pose = poseStack.last();
        BakedModel model = renderer.getBlockModel(state);
        ModelData modelData = this.sign.getModelData();
        int color = this.minecraft.getBlockColors().getColor(state, (BlockAndTintGetter)this.minecraft.level, this.sign.getBlockPos(), 0);
        float red = (float)FastColor.ARGB32.red((int)color) / 255.0f;
        float green = (float)FastColor.ARGB32.green((int)color) / 255.0f;
        float blue = (float)FastColor.ARGB32.blue((int)color) / 255.0f;
        for (RenderType renderType : model.getRenderTypes(state, RandomSource.create((long)42L), modelData)) {
            VertexConsumer consumer = buffer.getBuffer(RenderTypeHelper.getEntityRenderType((RenderType)renderType, (boolean)false));
            renderer.getModelRenderer().renderModel(pose, consumer, state, model, red, green, blue, 0xF000F0, OverlayTexture.NO_OVERLAY, modelData, renderType);
        }
        buffer.endBatch();
    }

    private void drawText(GuiGraphics graphics) {
        graphics.pose().translate(0.0f, this.signConfig.textYOff, 0.0f);
        MultiBufferSource.BufferSource buffer = this.minecraft.renderBuffers().bufferSource();
        this.drawLines(graphics.pose().last().pose(), buffer, this.lines);
        this.drawCursor(graphics, buffer, this.lines);
    }

    private void drawLines(Matrix4f matrix, MultiBufferSource.BufferSource buffer, String[] lines) {
        int color = this.text.hasGlowingText() ? this.text.getColor().getTextColor() : SignRenderer.getDarkColor((SignText)this.text);
        for (int line = 0; line < lines.length; ++line) {
            String text = lines[line];
            if (text == null) continue;
            if (this.font.isBidirectional()) {
                text = this.font.bidirectionalShaping(text);
            }
            float textX = (float)(-this.font.width(text)) / 2.0f;
            this.font.drawInBatch(text, textX, (float)(line * 10 - 20), color, false, matrix, (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        }
        buffer.endBatch();
    }

    private void drawCursor(GuiGraphics graphics, MultiBufferSource.BufferSource buffer, String[] lines) {
        Matrix4f matrix = graphics.pose().last().pose();
        int color = this.text.hasGlowingText() ? this.text.getColor().getTextColor() : SignRenderer.getDarkColor((SignText)this.text);
        boolean blink = this.blinkCounter / 6 % 2 == 0;
        int dir = this.font.isBidirectional() ? -1 : 1;
        int y = this.currLine * 10 - 20;
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            if (line == null || i != this.currLine || this.inputUtil.getCursorPos() < 0) continue;
            int hw = this.font.width(line) / 2;
            int selectionEnd = this.font.width(line.substring(0, Math.max(Math.min(this.inputUtil.getCursorPos(), line.length()), 0)));
            int cursorX = (selectionEnd - hw) * dir;
            if (blink) {
                if (this.inputUtil.getCursorPos() < line.length()) {
                    graphics.fill(cursorX, y - 1, cursorX + 1, y + 9, 0xFF000000 | color);
                } else {
                    this.font.drawInBatch("_", (float)cursorX, (float)y, color, false, matrix, (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
                    buffer.endBatch();
                }
            }
            if (this.inputUtil.getSelectionPos() == this.inputUtil.getCursorPos()) continue;
            int x1 = (this.font.width(line.substring(0, this.inputUtil.getSelectionPos())) - hw) * dir;
            int x2 = (this.font.width(line.substring(0, this.inputUtil.getCursorPos())) - hw) * dir;
            int xStart = Math.min(x1, x2);
            int xEnd = Math.max(x1, x2);
            RenderSystem.enableColorLogicOp();
            RenderSystem.logicOp((GlStateManager.LogicOp)GlStateManager.LogicOp.OR_REVERSE);
            BufferBuilder tessBuffer = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
            tessBuffer.addVertex(matrix, (float)xStart, (float)y + 9.0f, 0.0f).setColor(0, 0, 255, 255);
            tessBuffer.addVertex(matrix, (float)xEnd, (float)y + 9.0f, 0.0f).setColor(0, 0, 255, 255);
            tessBuffer.addVertex(matrix, (float)xEnd, (float)y - 1.0f, 0.0f).setColor(0, 0, 255, 255);
            tessBuffer.addVertex(matrix, (float)xStart, (float)y - 1.0f, 0.0f).setColor(0, 0, 255, 255);
            BufferUploader.drawWithShader((MeshData)tessBuffer.buildOrThrow());
            RenderSystem.disableColorLogicOp();
        }
    }

    private record SignConfig(float baseYOff, float addYOff, float signScale, float textYOff, float textScale) {
    }
}

