/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.blockentity.special;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.UUID;
import java.util.function.UnaryOperator;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.FilteredText;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import xfacthd.framedblocks.FramedBlocks;
import xfacthd.framedblocks.api.block.blockentity.FramedBlockEntity;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.sign.AbstractFramedSignBlock;

public class FramedSignBlockEntity
extends FramedBlockEntity {
    @Nullable
    private UUID editingPlayer;
    private SignText frontText = new SignText();
    private SignText backText = new SignText();
    private boolean waxed;

    private FramedSignBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public boolean isFacingFrontText(Player player) {
        Block block = this.getBlockState().getBlock();
        if (block instanceof AbstractFramedSignBlock) {
            float playerAngle;
            AbstractFramedSignBlock signblock = (AbstractFramedSignBlock)block;
            Vec3 center = signblock.getSignHitboxCenterPosition(this.getBlockState());
            double dX = player.getX() - ((double)this.getBlockPos().getX() + center.x);
            double dY = player.getZ() - ((double)this.getBlockPos().getZ() + center.z);
            float blockAngle = signblock.getYRotationDegrees(this.getBlockState());
            return Mth.degreesDifferenceAbs((float)blockAngle, (float)(playerAngle = (float)(Mth.atan2((double)dY, (double)dX) * 57.2957763671875) - 90.0f)) <= 90.0f;
        }
        return false;
    }

    public SignText getText(boolean front) {
        return front ? this.frontText : this.backText;
    }

    public void updateTextFromPacket(Player player, boolean front, List<FilteredText> filteredText) {
        if (this.level == null) {
            return;
        }
        if (this.isWaxed() || !player.getUUID().equals(this.editingPlayer)) {
            FramedBlocks.LOGGER.warn("Player {} just tried to change non-editable sign at {}", (Object)player.getName().getString(), (Object)this.worldPosition);
            return;
        }
        this.updateText(text -> {
            boolean filter = player.isTextFilteringEnabled();
            for (int idx = 0; idx < filteredText.size(); ++idx) {
                FilteredText filteredtext = (FilteredText)filteredText.get(idx);
                Style style = text.getMessage(idx, filter).getStyle();
                MutableComponent filteredLine = Component.literal((String)filteredtext.filteredOrEmpty()).setStyle(style);
                MutableComponent line = filter ? filteredLine : Component.literal((String)filteredtext.raw()).setStyle(style);
                text = text.setMessage(idx, (Component)line, (Component)filteredLine);
            }
            return text;
        }, front);
        this.setEditingPlayer(null);
    }

    public boolean updateText(UnaryOperator<SignText> modifier, boolean front) {
        return this.setText((SignText)modifier.apply(this.getText(front)), front);
    }

    public boolean setText(SignText text, boolean front) {
        if (text != this.getText(front)) {
            if (front) {
                this.frontText = text;
            } else {
                this.backText = text;
            }
            this.markDirty();
            return true;
        }
        return false;
    }

    public boolean isWaxed() {
        return this.waxed;
    }

    public boolean setWaxed(boolean waxed) {
        if (this.waxed != waxed) {
            this.waxed = waxed;
            this.markDirty();
            return true;
        }
        return false;
    }

    public boolean cannotExecuteCommands(boolean front, Player pPlayer) {
        return !this.waxed || !this.getText(front).hasAnyClickCommands(pPlayer);
    }

    public boolean tryExecuteCommands(Player player, Level level, BlockPos pos, boolean front) {
        boolean executed = false;
        for (Component line : this.getText(front).getMessages(player.isTextFilteringEnabled())) {
            ClickEvent event = line.getStyle().getClickEvent();
            if (event == null || event.getAction() != ClickEvent.Action.RUN_COMMAND) continue;
            player.getServer().getCommands().performPrefixedCommand(FramedSignBlockEntity.getCommandSource((ServerPlayer)player, (ServerLevel)level, pos), event.getValue());
            executed = true;
        }
        return executed;
    }

    private static CommandSourceStack getCommandSource(ServerPlayer player, ServerLevel level, BlockPos pos) {
        String nameString = player == null ? "Sign" : player.getName().getString();
        MutableComponent name = player == null ? Component.literal((String)"Sign") : player.getDisplayName();
        Vec3 posVec = Vec3.atCenterOf((Vec3i)pos);
        return new CommandSourceStack(CommandSource.NULL, posVec, Vec2.ZERO, level, 2, nameString, (Component)name, level.getServer(), (Entity)player);
    }

    @Nullable
    public UUID getEditingPlayer() {
        return this.editingPlayer;
    }

    public void setEditingPlayer(@Nullable UUID player) {
        this.editingPlayer = player;
    }

    public boolean onlyOpCanSetNbt() {
        return true;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, FramedSignBlockEntity be) {
        Player player;
        if (be.editingPlayer != null && be.isTooFarAwayToEdit(player = level.getPlayerByUUID(be.editingPlayer))) {
            be.editingPlayer = null;
        }
    }

    public boolean isTooFarAwayToEdit(Player player) {
        return player == null || player.distanceToSqr((double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ()) > 64.0;
    }

    private void markDirty() {
        this.level().sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        this.setChangedWithoutSignalUpdate();
    }

    @Override
    protected void writeToDataPacket(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
        super.writeToDataPacket(nbt, lookupProvider);
        this.writeToNbt(nbt);
    }

    @Override
    protected boolean readFromDataPacket(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
        this.readFromNbt(nbt);
        return super.readFromDataPacket(nbt, lookupProvider);
    }

    @Override
    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag nbt = super.getUpdateTag(provider);
        this.writeToNbt(nbt);
        return nbt;
    }

    @Override
    public void handleUpdateTag(CompoundTag nbt, HolderLookup.Provider provider) {
        super.handleUpdateTag(nbt, provider);
        this.readFromNbt(nbt);
    }

    private void writeToNbt(CompoundTag nbt) {
        SignText.DIRECT_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.frontText).resultOrPartial(arg_0 -> ((Logger)FramedBlocks.LOGGER).error(arg_0)).ifPresent(tag -> nbt.put("front_text", tag));
        SignText.DIRECT_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.backText).resultOrPartial(arg_0 -> ((Logger)FramedBlocks.LOGGER).error(arg_0)).ifPresent(tag -> nbt.put("back_text", tag));
        nbt.putBoolean("waxed", this.waxed);
    }

    private void readFromNbt(CompoundTag nbt) {
        if (nbt.contains("front_text")) {
            SignText.DIRECT_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)nbt.getCompound("front_text")).resultOrPartial(arg_0 -> ((Logger)FramedBlocks.LOGGER).error(arg_0)).ifPresent(tag -> {
                this.frontText = FramedSignBlockEntity.loadLines(this.level, this.worldPosition, tag);
            });
        }
        if (nbt.contains("back_text")) {
            SignText.DIRECT_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)nbt.getCompound("back_text")).resultOrPartial(arg_0 -> ((Logger)FramedBlocks.LOGGER).error(arg_0)).ifPresent(tag -> {
                this.backText = FramedSignBlockEntity.loadLines(this.level, this.worldPosition, tag);
            });
        }
        this.waxed = nbt.getBoolean("waxed");
    }

    private static SignText loadLines(Level level, BlockPos pos, SignText text) {
        for (int i = 0; i < 4; ++i) {
            Component line = FramedSignBlockEntity.loadLine(level, pos, text.getMessage(i, false));
            Component lineFiltered = FramedSignBlockEntity.loadLine(level, pos, text.getMessage(i, true));
            text = text.setMessage(i, line, lineFiltered);
        }
        return text;
    }

    private static Component loadLine(Level level, BlockPos pos, Component line) {
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            try {
                return ComponentUtils.updateForEntity((CommandSourceStack)FramedSignBlockEntity.getCommandSource(null, serverlevel, pos), (Component)line, null, (int)0);
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
        }
        return line;
    }

    @Override
    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        this.writeToNbt(nbt);
        super.saveAdditional(nbt, provider);
    }

    @Override
    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider provider) {
        super.loadAdditional(nbt, provider);
        this.readFromNbt(nbt);
    }

    public static FramedSignBlockEntity normalSign(BlockPos pos, BlockState state) {
        return new FramedSignBlockEntity((BlockEntityType)FBContent.BE_TYPE_FRAMED_SIGN.value(), pos, state);
    }

    public static FramedSignBlockEntity hangingSign(BlockPos pos, BlockState state) {
        return new FramedSignBlockEntity((BlockEntityType)FBContent.BE_TYPE_FRAMED_HANGING_SIGN.value(), pos, state);
    }
}

