/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.conpreds.slopeedge;

import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.predicate.contex.ConnectionPredicate;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.CornerType;

public final class InnerCornerSlopeEdgeConnectionPredicate
implements ConnectionPredicate {
    @Override
    public boolean canConnectFullEdge(BlockState state, Direction side, @Nullable Direction edge) {
        if (!((Boolean)state.getValue((Property)PropertyHolder.ALT_TYPE)).booleanValue()) {
            Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
            CornerType type = (CornerType)((Object)state.getValue(PropertyHolder.CORNER_TYPE));
            if (type.isHorizontal()) {
                Direction backTwo;
                Direction backOne = type.isTop() ? Direction.UP : Direction.DOWN;
                Direction direction = backTwo = type.isRight() ? dir.getClockWise() : dir.getCounterClockWise();
                if (side == dir) {
                    return edge == backOne || edge == backTwo;
                }
                if (side == backOne || side == backTwo) {
                    return edge == dir;
                }
            } else {
                Direction bottomFace;
                Direction direction = bottomFace = type.isTop() ? Direction.UP : Direction.DOWN;
                if (side == bottomFace) {
                    return edge == dir || edge == dir.getCounterClockWise();
                }
                if (side == dir || side == dir.getCounterClockWise()) {
                    return edge == bottomFace;
                }
            }
        }
        return false;
    }

    @Override
    public boolean canConnectDetailed(BlockState state, Direction side, Direction edge) {
        Direction backTwo;
        Direction backOne;
        Direction bottom;
        Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        CornerType type = (CornerType)((Object)state.getValue(PropertyHolder.CORNER_TYPE));
        boolean alt = (Boolean)state.getValue((Property)PropertyHolder.ALT_TYPE);
        if (type.isHorizontal()) {
            bottom = dir;
            backOne = type.isTop() ? Direction.UP : Direction.DOWN;
            backTwo = type.isRight() ? dir.getClockWise() : dir.getCounterClockWise();
        } else {
            bottom = type.isTop() ? Direction.UP : Direction.DOWN;
            backOne = dir;
            backTwo = dir.getCounterClockWise();
        }
        if (side == bottom) {
            return edge == backOne.getOpposite() || edge == backTwo.getOpposite();
        }
        if (side == backOne) {
            return edge == backTwo.getOpposite() || !alt && edge == backTwo;
        }
        if (side == backTwo) {
            return edge == backOne.getOpposite() || !alt && edge == backOne;
        }
        if (side == backOne.getOpposite()) {
            return edge == backTwo.getOpposite() || !alt && (edge == backTwo || edge == bottom);
        }
        if (side == backTwo.getOpposite()) {
            return edge == backOne.getOpposite() || !alt && (edge == backOne || edge == bottom);
        }
        return side == bottom.getOpposite();
    }
}

