/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.shapes.door;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.shapes.ShapeCache;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.shapes.ShapeUtils;

public final class GateShapes {
    private static final ShapeCache<Direction> SHAPES = ShapeCache.createEnum(Direction.class, map -> {
        VoxelShape shape = Block.box((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);
        ShapeUtils.makeHorizontalRotations(shape, Direction.NORTH, map);
    });

    public static ShapeProvider generate(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : states) {
            Direction dir = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
            if (((Boolean)state.getValue((Property)BlockStateProperties.OPEN)).booleanValue()) {
                boolean rightHinge = state.getValue((Property)BlockStateProperties.DOOR_HINGE) == DoorHingeSide.RIGHT;
                dir = rightHinge ? dir.getCounterClockWise() : dir.getClockWise();
            }
            builder.put((Object)state, (Object)SHAPES.get(dir));
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }

    private GateShapes() {
    }
}

