/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.external.morelib.core.database;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CoreDatabaseHandler {
    private Map tableMap;
    private Connection connection;
    private String connectionUrl;
    private String username;
    private String password;
    private List<SQLData> tableList;

    public CoreDatabaseHandler(String connectionUrl, String username, String password) {
        this.connectionUrl = connectionUrl;
        this.username = username;
        this.password = password;
        this.tableList = new ArrayList<SQLData>();
        this.init();
    }

    private void init() {
        try {
            this.connection = DriverManager.getConnection(this.connectionUrl, this.username, this.password);
            this.tableMap = this.connection.getTypeMap();
            this.setTables();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public void setTables() throws SQLException, ClassNotFoundException {
        for (SQLData table : this.tableList) {
            this.tableMap.put(table.getSQLTypeName(), Class.forName(table.getClass().getName()));
        }
    }

    public void addTable(SQLData singleTable) {
        try {
            this.tableList.add(singleTable);
            this.tableMap.put(singleTable.getSQLTypeName(), Class.forName(singleTable.getClass().getName()));
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public ResultSet execute(String statement) {
        ResultSet result = null;
        try {
            PreparedStatement preparedStatement = this.connection.prepareStatement(statement);
            result = preparedStatement.executeQuery();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public Map getTableMap() {
        return this.tableMap;
    }

    public void setTableMap(Map tableMap) {
        this.tableMap = tableMap;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public List<SQLData> getTableList() {
        return this.tableList;
    }

    public void setTableList(List<SQLData> tableList) {
        this.tableList = tableList;
    }
}

