/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.external.morelib.core.file;

import com.morelaid.streamingmodule.external.jackson.databind.DeserializationFeature;
import com.morelaid.streamingmodule.external.jackson.databind.ObjectMapper;
import com.morelaid.streamingmodule.external.jackson.databind.SerializationFeature;
import com.morelaid.streamingmodule.external.jackson.dataformat.yaml.YAMLFactory;
import com.morelaid.streamingmodule.external.jackson.dataformat.yaml.YAMLGenerator;
import java.io.File;
import java.io.IOException;

public class JacksonHandler {
    private final ObjectMapper mapper = new ObjectMapper(new YAMLFactory().disable(YAMLGenerator.Feature.WRITE_DOC_START_MARKER));

    public JacksonHandler() {
        this.mapper.findAndRegisterModules();
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.mapper.configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true);
    }

    public <T> Object reloadFile(String path, Object configFile) throws IOException {
        this.init(path, configFile);
        Object o = this.mapper.readValue(new File(path), configFile.getClass());
        this.saveFile(path, o);
        return o;
    }

    public void saveFile(String path, Object configFile) throws IOException {
        this.mapper.writeValue(new File(path), configFile);
    }

    private <T> void init(String path, Object configFile) throws IOException {
        File file = new File(path);
        if (!file.exists()) {
            this.createDirectory(path);
            this.saveFile(path, configFile);
        }
    }

    private void createDirectory(String fullPath) {
        String pathNew = new File(fullPath).getParent() + "/";
        File dir = new File(pathNew);
        dir.mkdirs();
    }
}

