/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.external.morelib.core.updater;

import com.morelaid.streamingmodule.external.morelib.core.updater.Update;
import java.net.URL;
import java.util.Scanner;
import java.util.TimerTask;

public class UpdateChecker
extends TimerTask {
    private Update update;
    private String url = "https://api.spigotmc.org/legacy/update.php?resource=";

    public UpdateChecker(Update update) {
        this.update = update;
        this.url = this.url + update.getPluginID();
    }

    @Override
    public void run() {
        this.updateCheck();
    }

    public void updateCheck() {
        try {
            Scanner atrScan = new Scanner(new URL(this.url).openStream());
            String strLine = atrScan.next();
            if (UpdateChecker.isNewVersion(this.update.getOldVersion(), strLine)) {
                this.update.setHasUpdate(true);
                this.update.setNewVersion(strLine);
            } else {
                this.update.setHasUpdate(false);
                this.update.setNewVersion(this.update.getOldVersion());
            }
            atrScan.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static boolean isNewVersion(String currentVersion, String newVersion) {
        if (!currentVersion.trim().isEmpty() && !newVersion.trim().isEmpty() || !currentVersion.equals(newVersion)) {
            String[] ver1 = currentVersion.trim().split("[.]");
            String[] ver2 = newVersion.trim().split("[.]");
            if (ver1.length > 0 && ver2.length > 0) {
                int smalerSize = ver1.length < ver2.length ? ver2.length : ver1.length;
                for (int i = 0; i < smalerSize; ++i) {
                    try {
                        if (Integer.parseInt(ver1[i]) == Integer.parseInt(ver2[i])) continue;
                        return Integer.parseInt(ver1[i]) < Integer.parseInt(ver2[i]);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return false;
                    }
                }
                return ver1.length < ver2.length;
            }
        }
        return false;
    }
}

