/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.external.morelib.server.velocity;

import com.morelaid.streamingmodule.external.morelib.core.player.CorePlayer;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.ServerConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;

public class VelocityFunctions {
    public static List<String> getOnlinePlayerNames(Object proxyServer) {
        ArrayList<String> names = new ArrayList<String>();
        ProxyServer server = (ProxyServer)proxyServer;
        for (Player player : server.getAllPlayers()) {
            names.add(player.getUsername());
        }
        return names;
    }

    public static List<UUID> getOnlinePlayerUUIDs(Object proxyServer) {
        ArrayList<UUID> names = new ArrayList<UUID>();
        ProxyServer server = (ProxyServer)proxyServer;
        for (Player player : server.getAllPlayers()) {
            names.add(player.getUniqueId());
        }
        return names;
    }

    public static String getWorldName(CorePlayer player) {
        Player p;
        ProxyServer server;
        Optional playerOptional;
        if (player != null && player.getUuid() != null && (playerOptional = (server = (ProxyServer)player.getService().getServer()).getPlayer(player.getName())).isPresent() && (p = (Player)playerOptional.get()).getCurrentServer().isPresent()) {
            return ((ServerConnection)p.getCurrentServer().get()).getServer().getServerInfo().getName();
        }
        return "";
    }

    public static boolean isPlayerOnline(CorePlayer player) {
        if (player != null && player.getUuid() != null) {
            ProxyServer server = (ProxyServer)player.getService().getServer();
            return server.getPlayer(player.getName()).isPresent();
        }
        return false;
    }

    public static boolean hasPermission(CorePlayer player, String permission) {
        if (player != null && player.getUuid() != null) {
            Player p = (Player)player.getSender();
            return p.hasPermission(permission);
        }
        return false;
    }
}

