/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.general.async;

import com.morelaid.streamingmodule.general.file.database.ModuleUser;
import com.morelaid.streamingmodule.general.file.streamer.Streamer;
import com.morelaid.streamingmodule.general.function.ServiceHandler;
import java.util.ArrayList;
import java.util.List;

public class DropService_Async
implements Runnable {
    private final ServiceHandler service;
    private Streamer streamer = null;
    private String[] viewers = null;

    public DropService_Async(ServiceHandler service) {
        this.service = service;
    }

    public DropService_Async(ServiceHandler service, Streamer streamer) {
        this.service = service;
        this.streamer = streamer;
    }

    public DropService_Async(ServiceHandler service, Streamer streamer, String ... viewers) {
        this.service = service;
        this.streamer = streamer;
        this.viewers = viewers;
    }

    @Override
    public void run() {
        if (this.viewers != null) {
            this.service.getDropService().sendDropsToPlayer(this.streamer, this.getViewers(this.viewers), true);
            return;
        }
        if (this.streamer != null) {
            this.service.getDropService().sendDropsToPlayer(this.streamer);
        } else {
            for (Streamer streamer : this.service.getStreamer().getStreamers()) {
                this.service.debug("Generating drops for " + streamer.getName() + " via " + streamer.getTwitchBotName_Premium());
                this.service.setCurrentTime(0);
                this.service.getDropService().sendDropsToPlayer(streamer);
                this.service.debug("Drops generated for " + streamer.getName());
            }
        }
    }

    private List<ModuleUser> getViewers(String[] viewerList) {
        ArrayList<ModuleUser> viewers = new ArrayList<ModuleUser>();
        for (String user : viewerList) {
            ModuleUser singleUser = this.service.getUserByPlatform(true, user);
            if (singleUser == null) continue;
            viewers.add(singleUser);
        }
        return viewers;
    }
}

