/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.general.async;

import com.morelaid.streamingmodule.general.file.database.WatchedTimeLog;
import com.morelaid.streamingmodule.general.file.streamer.Streamer;
import com.morelaid.streamingmodule.general.function.ServiceHandler;
import java.util.List;

public class WatchTimeChecker_Async
implements Runnable {
    private final ServiceHandler service;

    public WatchTimeChecker_Async(ServiceHandler service) {
        this.service = service;
    }

    @Override
    public void run() {
        if (this.service.getSettings().getWatchTime().isEnabled()) {
            for (String streamerName : this.service.getStreamerLiveStatus()) {
                Streamer streamer = this.service.getStreamerByName(streamerName);
                List<String> viewers = this.service.getTwitchBot(streamer).getTwitchChatters(streamerName);
                for (String viewer : viewers) {
                    WatchedTimeLog userWatchTime = this.service.getDatabaseManager().getUsersWatchTime(viewer, streamer);
                    userWatchTime.setWatchTime(userWatchTime.getWatchTime() + this.service.getWatchTimeInterval());
                    this.service.getDatabaseManager().createOrUpdateWatchTime(userWatchTime);
                }
            }
        }
    }
}

