/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.server.bungee;

import com.morelaid.shared.StreamerJsonCodec;
import com.morelaid.shared.StreamerLiveTag;
import com.morelaid.streamingmodule.external.morelib.core.functions.ServerSoftware;
import com.morelaid.streamingmodule.external.morelib.server.bungee.BungeeMetrics;
import com.morelaid.streamingmodule.general.function.ServiceHandler;
import com.morelaid.streamingmodule.server.bungee.command.BC_Drops;
import com.morelaid.streamingmodule.server.bungee.command.BC_Online;
import com.morelaid.streamingmodule.server.bungee.command.BC_StreamingModule;
import com.morelaid.streamingmodule.server.bungee.command.BC_Twitch;
import com.morelaid.streamingmodule.server.bungee.command.BC_TwitchSettings;
import com.morelaid.streamingmodule.server.bungee.command.BC_sendTwitch;
import com.morelaid.streamingmodule.server.bungee.command.BC_smOptions;
import com.morelaid.streamingmodule.server.bungee.command.BC_smPrivate;
import com.morelaid.streamingmodule.server.bungee.command.BC_smPublic;
import com.morelaid.streamingmodule.server.bungee.command.BC_smRandomDrop;
import com.morelaid.streamingmodule.server.bungee.command.BC_smTwitchBot;
import com.morelaid.streamingmodule.server.bungee.command.BC_smViewers;
import com.morelaid.streamingmodule.server.bungee.events.BungeeEventHandler;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;

public class StreamingModuleBungee
extends Plugin {
    private ServiceHandler service;
    private BungeeMetrics metrics;

    public void onEnable() {
        this.service = new ServiceHandler(this.getLogger(), "SM", "StreamingModule", ServerSoftware.BUNGEECORD, (Object)this);
        this.getProxy().getPluginManager().registerListener((Plugin)this, (Listener)new BungeeEventHandler(this.service));
        if (this.service.getSettings().getProxySettings().isEnableProxyCommands()) {
            String sufix = this.service.getSettings().getProxySettings().getProxyCommandSufix().trim();
            this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new BC_StreamingModule(this.service, "sm" + sufix, "sm.admin.*", "streamingmodule" + sufix));
            this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new BC_Twitch(this.service, "twitch" + sufix, "sm.user.twitch", "smtwitch" + sufix));
            this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new BC_Drops(this.service, "drops" + sufix, "sm.user.drops", "smdrops" + sufix));
            this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new BC_smPublic(this.service, "smpublic" + sufix, "sm.admin.smpublic", new String[0]));
            this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new BC_smPrivate(this.service, "smprivate" + sufix, "sm.admin.smprivate", new String[0]));
            this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new BC_Online(this.service, "online" + sufix, "sm.user.online", "smonline" + sufix));
            this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new BC_TwitchSettings(this.service, "twitchsettings" + sufix, "sm.streamer.twitchsettings", "smtwitchsettings" + sufix));
            this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new BC_smRandomDrop(this.service, "smrandomdrop" + sufix, "sm.admin.smrandomdrop", new String[0]));
            this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new BC_smViewers(this.service, "smviewers" + sufix, "sm.streamer.smviewers", "viewers" + sufix));
            this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new BC_sendTwitch(this.service, "sendtwitch" + sufix, "sm.admin.sendtwitch", "smsendtwitch" + sufix));
            this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new BC_smOptions(this.service, "smoptions" + sufix, "sm.user.smoptions", "options" + sufix));
            this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new BC_smTwitchBot(this.service, "smchatbot" + sufix, "sm.streamer.smchatbot", "chatbot" + sufix));
        } else {
            this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new BC_StreamingModule(this.service, "sm", "sm.admin.*", "streamingmodule"));
            this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new BC_Twitch(this.service, "twitch", "sm.user.twitch", "smtwitch"));
            this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new BC_Drops(this.service, "drops", "sm.user.drops", "smdrops"));
            this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new BC_smPublic(this.service, "smpublic", "sm.admin.smpublic", new String[0]));
            this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new BC_smPrivate(this.service, "smprivate", "sm.admin.smprivate", new String[0]));
            this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new BC_Online(this.service, "online", "sm.user.online", "smonline"));
            this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new BC_TwitchSettings(this.service, "twitchsettings", "sm.streamer.twitchsettings", "smtwitchsettings"));
            this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new BC_smRandomDrop(this.service, "smrandomdrop", "sm.admin.smrandomdrop", new String[0]));
            this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new BC_smViewers(this.service, "smviewers", "sm.streamer.smviewers", "viewers"));
            this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new BC_sendTwitch(this.service, "sendtwitch", "sm.admin.sendtwitch", "smsendtwitch"));
            this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new BC_smOptions(this.service, "smoptions", "sm.user.smoptions", "options"));
            this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new BC_smTwitchBot(this.service, "smchatbot", "sm.streamer.smchatbot", "chatbot"));
        }
        this.initPlugin();
        ProxyServer.getInstance().getScheduler().schedule((Plugin)this, this::broadcastSnapshot, 10L, 60L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void broadcastSnapshot() {
        try {
            byte[] payload;
            this.service.fillStreamerLiveTagForPAPI();
            HashMap<String, StreamerLiveTag> hashMap = this.service.getStreamerLiveTagForPAPI();
            synchronized (hashMap) {
                payload = StreamerJsonCodec.encodeMap(new HashMap<String, StreamerLiveTag>(this.service.getStreamerLiveTagForPAPI()));
            }
            for (ServerInfo server : ProxyServer.getInstance().getServers().values()) {
                server.sendData("smlib:livetag", payload, true);
            }
        }
        catch (Exception ex) {
            this.service.debug("PAPI Sync failed: " + ex.getMessage());
        }
    }

    private void initPlugin() {
        try {
            this.metrics = new BungeeMetrics(this, 21950);
        }
        catch (Exception e) {
            this.service.debug(e.getMessage());
        }
    }
}

