/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.server.spigot.command;

import com.morelaid.streamingmodule.general.base.state.ActiveState;
import com.morelaid.streamingmodule.general.base.state.TwitchSettingsState;
import com.morelaid.streamingmodule.general.file.database.ModuleUser;
import com.morelaid.streamingmodule.general.file.streamer.Streamer;
import com.morelaid.streamingmodule.general.function.ServiceHandler;
import java.util.ArrayList;
import java.util.List;

public class TabHandling {
    public static List<String> Command_SM_One(ModuleUser user, String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        if (user.hasPermission("sm.admin.*") || user.hasPermission("sm.admin.streamerlist") || user.hasPermission("sm.admin.streameradd") || user.hasPermission("sm.admin.streamerremove")) {
            list.add("streamer");
        }
        if (user.hasPermission("sm.admin.*") || user.hasPermission("sm.admin.reload")) {
            list.add("reload");
        }
        if (user.hasPermission("sm.admin.*") || user.hasPermission("sm.admin.help")) {
            list.add("help");
        }
        if (user.hasPermission("sm.admin.*") || user.hasPermission("sm.admin.twitchshow") || user.hasPermission("sm.admin.twitchset")) {
            list.add("twitch");
        }
        if (user.hasPermission("sm.admin.*") || user.hasPermission("sm.admin.report")) {
            list.add("report");
        }
        if (user.hasPermission("sm.admin.*") || user.hasPermission("sm.admin.timer")) {
            list.add("timer");
        }
        if (user.hasPermission("sm.admin.*") || user.hasPermission("sm.streamer.smviewers")) {
            list.add("viewers");
        }
        if (user.hasPermission("sm.admin.*") || user.hasPermission("sm.streamer.smchatbot")) {
            list.add("chatbot");
        }
        return list;
    }

    public static List<String> Command_TS_One(ModuleUser user, String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        if (user.hasPermission("sm.admin.*") || user.hasPermission("sm.streamer.twitchsettings")) {
            list.addAll(TwitchSettingsState.toList());
        }
        return list;
    }

    public static List<String> Command_TS_Two(ModuleUser user, String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        if (user.hasPermission("sm.admin.*") || user.hasPermission("sm.streamer.twitchsettings")) {
            list.addAll(ActiveState.toList());
        }
        return list;
    }

    public static List<String> Command_smOptions_One(ModuleUser user, String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        if (user.hasPermission("sm.admin.*") || user.hasPermission("sm.user.smoptions")) {
            list.add("drops");
        }
        return list;
    }

    public static List<String> Command_drops_One(ModuleUser user, String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        if (user.hasPermission("sm.admin.*") || user.hasPermission("sm.streamer.dropstest")) {
            list.add("test");
        }
        return list;
    }

    public static List<String> Command_smOptions_Two(ModuleUser user, String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        if (user.hasPermission("sm.admin.*") || user.hasPermission("sm.user.smoptions")) {
            list.addAll(ActiveState.toList());
        }
        return list;
    }

    public static List<String> Command_SD_Two(ServiceHandler service, ModuleUser user, String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        switch (args[0].toLowerCase()) {
            case "reload": {
                return TabHandling.GetTablistReload(user, args);
            }
            case "streamer": {
                return TabHandling.GetTablistStreamer(user, args);
            }
            case "chatbot": {
                return TabHandling.GetCurrentTwitchStreamer(service, user, args);
            }
        }
        return list;
    }

    private static List<String> GetTablistReload(ModuleUser user, String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        if (user.hasPermission("sm.admin.*") || user.hasPermission("sm.admin.reload")) {
            list.add("force");
        }
        return list;
    }

    private static List<String> GetTablistStreamer(ModuleUser user, String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        if (user.hasPermission("sm.admin.*") || user.hasPermission("sm.admin.streamerlist")) {
            list.add("list");
        }
        if (user.hasPermission("sm.admin.*") || user.hasPermission("sm.admin.streameradd")) {
            list.add("add");
        }
        if (user.hasPermission("sm.admin.*") || user.hasPermission("sm.admin.streamerremove")) {
            list.add("remove");
        }
        return list;
    }

    public static List<String> Command_SD_Three(ServiceHandler service, ModuleUser user, String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        switch (args[1].toLowerCase()) {
            case "remove": {
                return TabHandling.GetStreamerToRemove(service, user, args);
            }
            case "add": {
                return TabHandling.GetTwitchNamePlaceholder(user, args);
            }
        }
        return list;
    }

    private static List<String> GetStreamerToRemove(ServiceHandler service, ModuleUser user, String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        if (user.hasPermission("sm.admin.*") || user.hasPermission("sm.admin.streamerremove")) {
            for (Streamer streamer : service.getStreamer().getStreamers()) {
                list.add(streamer.getName());
            }
        }
        return list;
    }

    private static List<String> GetTwitchNamePlaceholder(ModuleUser user, String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        if (user.hasPermission("sm.admin.*") || user.hasPermission("sm.admin.streameradd")) {
            list.add("<twitch name>");
        }
        return list;
    }

    private static List<String> GetCurrentTwitchStreamer(ServiceHandler service, ModuleUser user, String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        if (user.hasPermission("sm.admin.*") || user.hasPermission("sm.admin.streameradd")) {
            for (Streamer streamer : service.getStreamer().getStreamers()) {
                list.add(streamer.getName());
            }
        }
        return list;
    }

    private static List<String> GetOnlinePlayer(ServiceHandler service, ModuleUser user, String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        if (user.hasPermission("sm.admin.*") || user.hasPermission("sm.admin.streameradd")) {
            list.addAll(service.getOnlinePlayerNames());
        }
        return list;
    }
}

