/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.server.velocity;

import com.morelaid.shared.StreamerJsonCodec;
import com.morelaid.shared.StreamerLiveTag;
import com.morelaid.streamingmodule.external.morelib.core.functions.ServerSoftware;
import com.morelaid.streamingmodule.general.file.database.ModuleUser;
import com.morelaid.streamingmodule.general.function.ServiceHandler;
import com.morelaid.streamingmodule.server.velocity.command.VC_Drops;
import com.morelaid.streamingmodule.server.velocity.command.VC_Online;
import com.morelaid.streamingmodule.server.velocity.command.VC_SMOptions;
import com.morelaid.streamingmodule.server.velocity.command.VC_SMPrivate;
import com.morelaid.streamingmodule.server.velocity.command.VC_SMPublic;
import com.morelaid.streamingmodule.server.velocity.command.VC_SMRandomDrop;
import com.morelaid.streamingmodule.server.velocity.command.VC_SMViewers;
import com.morelaid.streamingmodule.server.velocity.command.VC_SMtwitchBot;
import com.morelaid.streamingmodule.server.velocity.command.VC_SendTwitch;
import com.morelaid.streamingmodule.server.velocity.command.VC_StreamingModule;
import com.morelaid.streamingmodule.server.velocity.command.VC_Twitch;
import com.morelaid.streamingmodule.server.velocity.command.VC_TwitchSettings;
import com.morelaid.streamingmodule.server.velocity.event.VelocityEventHandler;
import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.command.CommandManager;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.PostLoginEvent;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.plugin.PluginContainer;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.messages.ChannelIdentifier;
import com.velocitypowered.api.proxy.messages.MinecraftChannelIdentifier;
import com.velocitypowered.api.scheduler.ScheduledTask;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.slf4j.Logger;

public class StreamingModuleVelocity {
    private ProxyServer server;
    private ServiceHandler service;
    private Logger logger;
    private CommandManager commandManager;
    private VelocityEventHandler velocityEventHandler;
    private PluginContainer container;
    private ScheduledTask task;
    private ChannelIdentifier channel = MinecraftChannelIdentifier.from((String)"smlib:livetag");

    @Inject
    public StreamingModuleVelocity(ProxyServer server, Logger logger, PluginContainer container) {
        this.server = server;
        this.logger = logger;
        this.container = container;
        this.service = new ServiceHandler(java.util.logging.Logger.getLogger(this.getClass().toString()), "SM", "StreamingModule", ServerSoftware.VELOCITY, server);
        this.commandManager = this.server.getCommandManager();
        this.server.getEventManager().register((Object)container, PostLoginEvent.class, event -> this.service.getEventHandler().OnJoinEvent(new ModuleUser(this.service, event.getPlayer().getUniqueId(), event.getPlayer().getUsername(), (Object)event.getPlayer())));
        if (this.service.getSettings().getProxySettings().isEnableProxyCommands()) {
            String sufix = this.service.getSettings().getProxySettings().getProxyCommandSufix().trim();
            this.commandManager.register(this.commandManager.metaBuilder("sm" + sufix).aliases(new String[]{"streamingmodule" + sufix}).plugin((Object)this).build(), (Command)new VC_StreamingModule(this.service, "sm.admin.*"));
            this.commandManager.register(this.commandManager.metaBuilder("twitch" + sufix).aliases(new String[]{"smtwitch" + sufix}).plugin((Object)this).build(), (Command)new VC_Twitch(this.service, "sm.user.twitch"));
            this.commandManager.register(this.commandManager.metaBuilder("smpublic" + sufix).plugin((Object)this).build(), (Command)new VC_SMPublic(this.service, "sm.admin.smpublic"));
            this.commandManager.register(this.commandManager.metaBuilder("smprivate" + sufix).plugin((Object)this).build(), (Command)new VC_SMPrivate(this.service, "sm.admin.smprivate"));
            this.commandManager.register(this.commandManager.metaBuilder("drops" + sufix).aliases(new String[]{"smdrops" + sufix}).plugin((Object)this).build(), (Command)new VC_Drops(this.service, "sm.user.drops"));
            this.commandManager.register(this.commandManager.metaBuilder("online" + sufix).aliases(new String[]{"smonline" + sufix}).plugin((Object)this).build(), (Command)new VC_Online(this.service, "sm.user.online"));
            this.commandManager.register(this.commandManager.metaBuilder("twitchsettings" + sufix).aliases(new String[]{"settings" + sufix}).plugin((Object)this).build(), (Command)new VC_TwitchSettings(this.service, "sm.streamer.twitchsettings"));
            this.commandManager.register(this.commandManager.metaBuilder("smviewers" + sufix).plugin((Object)this).build(), (Command)new VC_SMViewers(this.service, "sm.streamer.smviewers"));
            this.commandManager.register(this.commandManager.metaBuilder("sendtwitch" + sufix).plugin((Object)this).build(), (Command)new VC_SendTwitch(this.service, "sm.admin.sendtwitch"));
            this.commandManager.register(this.commandManager.metaBuilder("smoptions" + sufix).aliases(new String[]{"optionsp"}).plugin((Object)this).build(), (Command)new VC_SMOptions(this.service, "sm.user.smoptions"));
            this.commandManager.register(this.commandManager.metaBuilder("smrandomdrop" + sufix).aliases(new String[]{"randomdrop" + sufix}).plugin((Object)this).build(), (Command)new VC_SMRandomDrop(this.service, "sm.admin.smrandomdrop"));
            this.commandManager.register(this.commandManager.metaBuilder("smchatbot" + sufix).aliases(new String[]{"chatbot" + sufix}).plugin((Object)this).build(), (Command)new VC_SMtwitchBot(this.service, "sm.streamer.smchatbot"));
        } else {
            this.commandManager.register(this.commandManager.metaBuilder("sm").aliases(new String[]{"streamingmodule"}).plugin((Object)this).build(), (Command)new VC_StreamingModule(this.service, "sm.admin.*"));
            this.commandManager.register(this.commandManager.metaBuilder("twitch").aliases(new String[]{"smtwitch"}).plugin((Object)this).build(), (Command)new VC_Twitch(this.service, "sm.user.twitch"));
            this.commandManager.register(this.commandManager.metaBuilder("smpublic").plugin((Object)this).build(), (Command)new VC_SMPublic(this.service, "sm.admin.smpublic"));
            this.commandManager.register(this.commandManager.metaBuilder("smprivate").plugin((Object)this).build(), (Command)new VC_SMPrivate(this.service, "sm.admin.smprivate"));
            this.commandManager.register(this.commandManager.metaBuilder("drops").aliases(new String[]{"smdrops"}).plugin((Object)this).build(), (Command)new VC_Drops(this.service, "sm.user.drops"));
            this.commandManager.register(this.commandManager.metaBuilder("online").aliases(new String[]{"smonline"}).plugin((Object)this).build(), (Command)new VC_Online(this.service, "sm.user.online"));
            this.commandManager.register(this.commandManager.metaBuilder("twitchsettings").aliases(new String[]{"settings"}).plugin((Object)this).build(), (Command)new VC_TwitchSettings(this.service, "sm.streamer.twitchsettings"));
            this.commandManager.register(this.commandManager.metaBuilder("smviewers").plugin((Object)this).build(), (Command)new VC_SMViewers(this.service, "sm.streamer.smviewers"));
            this.commandManager.register(this.commandManager.metaBuilder("sendtwitch").plugin((Object)this).build(), (Command)new VC_SendTwitch(this.service, "sm.admin.sendtwitch"));
            this.commandManager.register(this.commandManager.metaBuilder("smoptions").aliases(new String[]{"options"}).plugin((Object)this).build(), (Command)new VC_SMOptions(this.service, "sm.user.smoptions"));
            this.commandManager.register(this.commandManager.metaBuilder("smrandomdrop").aliases(new String[]{"randomdrop"}).plugin((Object)this).build(), (Command)new VC_SMRandomDrop(this.service, "sm.admin.smrandomdrop"));
            this.commandManager.register(this.commandManager.metaBuilder("smchatbot").aliases(new String[]{"chatbot"}).plugin((Object)this).build(), (Command)new VC_SMtwitchBot(this.service, "sm.streamer.smchatbot"));
        }
    }

    @Subscribe
    public void onProxyInitialize(ProxyInitializeEvent event) {
        this.server.getChannelRegistrar().register(new ChannelIdentifier[]{this.channel});
        this.task = this.server.getScheduler().buildTask((Object)this, this::broadcastSnapshot).delay(10L, TimeUnit.SECONDS).repeat(60L, TimeUnit.SECONDS).schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void broadcastSnapshot() {
        try {
            byte[] payload;
            this.service.fillStreamerLiveTagForPAPI();
            HashMap<String, StreamerLiveTag> hashMap = this.service.getStreamerLiveTagForPAPI();
            synchronized (hashMap) {
                payload = StreamerJsonCodec.encodeMap(new HashMap<String, StreamerLiveTag>(this.service.getStreamerLiveTagForPAPI()));
            }
            HashMap sentTo = new HashMap();
            for (Player p : this.server.getAllPlayers()) {
                p.getCurrentServer().ifPresent(curr -> {
                    String backend = curr.getServerInfo().getName();
                    if (!sentTo.containsKey(backend)) {
                        curr.sendPluginMessage(this.channel, payload);
                        sentTo.put(backend, true);
                    }
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

