/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.server.velocity.command;

import com.morelaid.streamingmodule.general.file.database.ModuleUser;
import com.morelaid.streamingmodule.general.function.ServiceHandler;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.command.SimpleCommand;
import com.velocitypowered.api.proxy.ConsoleCommandSource;
import com.velocitypowered.api.proxy.Player;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public abstract class VelocityCommand
implements SimpleCommand {
    protected ServiceHandler service;
    private String permission;
    private List<String> suggest = new ArrayList<String>();

    public VelocityCommand(ServiceHandler service, String permission) {
        this.service = service;
        this.permission = permission;
    }

    public VelocityCommand(ServiceHandler service, String permission, List<String> suggest) {
        this.service = service;
        this.permission = permission;
        this.suggest = suggest;
    }

    public String getPermission() {
        return this.permission;
    }

    public void setPermission(String permission) {
        this.permission = permission;
    }

    public boolean hasPermission(SimpleCommand.Invocation invocation) {
        return invocation.source().hasPermission("sm.admin.*") || invocation.source().hasPermission(this.permission);
    }

    public List<String> suggest(SimpleCommand.Invocation invocation) {
        return List.of();
    }

    protected abstract List<String> tabCompleteList(SimpleCommand.Invocation var1);

    public CompletableFuture<List<String>> suggestAsync(SimpleCommand.Invocation invocation) {
        return CompletableFuture.completedFuture(this.tabCompleteList(invocation));
    }

    public ModuleUser getModuleUser(SimpleCommand.Invocation invocation) {
        ModuleUser user = null;
        CommandSource source = invocation.source();
        if (source instanceof Player) {
            Player player = (Player)source;
            user = new ModuleUser(this.service, player.getUniqueId(), player.getUsername(), (Object)player);
            if (this.service.getUserCache().containsKey(player.getUniqueId())) {
                user.setPlatformName(this.service.getUserCache().get(user.getUuid()).getPlatformName());
            }
        } else if (source instanceof ConsoleCommandSource) {
            ConsoleCommandSource console = (ConsoleCommandSource)invocation.source();
            user = new ModuleUser(this.service, null, "Console", (Object)console);
        }
        return user;
    }

    public String[] convertArgs(String[] currentArgs) {
        if (currentArgs.length > 1) {
            String[] args = new String[currentArgs.length - 1];
            System.arraycopy(currentArgs, 1, args, 0, args.length);
            return currentArgs;
        }
        return currentArgs;
    }
}

