/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.external.jackson.databind.deser.std;

import com.morelaid.streamingmodule.external.jackson.core.JsonParser;
import com.morelaid.streamingmodule.external.jackson.core.JsonToken;
import com.morelaid.streamingmodule.external.jackson.databind.DeserializationContext;
import com.morelaid.streamingmodule.external.jackson.databind.JsonMappingException;
import com.morelaid.streamingmodule.external.jackson.databind.annotation.JacksonStdImpl;
import com.morelaid.streamingmodule.external.jackson.databind.deser.std.StdScalarDeserializer;
import com.morelaid.streamingmodule.external.jackson.databind.jsontype.TypeDeserializer;
import com.morelaid.streamingmodule.external.jackson.databind.type.LogicalType;
import java.io.IOException;

@JacksonStdImpl
public class StringDeserializer
extends StdScalarDeserializer<String> {
    private static final long serialVersionUID = 1L;
    public static final StringDeserializer instance = new StringDeserializer();

    public StringDeserializer() {
        super(String.class);
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.Textual;
    }

    @Override
    public boolean isCachable() {
        return true;
    }

    @Override
    public Object getEmptyValue(DeserializationContext ctxt) throws JsonMappingException {
        return "";
    }

    @Override
    public String deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (p.hasToken(JsonToken.VALUE_STRING)) {
            return p.getText();
        }
        if (p.hasToken(JsonToken.START_ARRAY)) {
            return (String)this._deserializeFromArray(p, ctxt);
        }
        return this._parseString(p, ctxt, this);
    }

    @Override
    public String deserializeWithType(JsonParser p, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
        return this.deserialize(p, ctxt);
    }
}

