/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.external.morelib.core.functions;

import com.morelaid.streamingmodule.external.morelib.core.command.CommandService;
import com.morelaid.streamingmodule.external.morelib.core.discord.WebhookMessage;
import com.morelaid.streamingmodule.external.morelib.core.file.JacksonHandler;
import com.morelaid.streamingmodule.external.morelib.core.functions.ServerSoftware;
import com.morelaid.streamingmodule.external.morelib.core.player.CorePlayer;
import com.morelaid.streamingmodule.external.morelib.server.bungee.BungeeFunctions;
import com.morelaid.streamingmodule.external.morelib.server.spigot.SpigotFunctions;
import com.morelaid.streamingmodule.external.morelib.server.velocity.VelocityFunctions;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.UUID;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.jasypt.util.text.StrongTextEncryptor;

public class CoreFunctions {
    private Logger logger;
    private String prefix;
    private String pluginName;
    private boolean debugEnabled;
    private final String format = "[{0}] {1}";
    protected ServerSoftware software;
    private WebhookMessage webhookMessage;
    private CommandService commandService;
    private JacksonHandler fileHandler;
    private StrongTextEncryptor textHandler;
    private Object server;

    public CoreFunctions(Logger logger, String prefix, String pluginName, ServerSoftware software, Object server) {
        this.logger = logger;
        this.prefix = prefix;
        this.pluginName = pluginName;
        this.debugEnabled = false;
        this.software = software;
        this.server = server;
        this.webhookMessage = new WebhookMessage(pluginName);
        this.commandService = new CommandService(software, server);
        this.fileHandler = new JacksonHandler();
        this.textHandler = new StrongTextEncryptor();
        this.textHandler.setPassword(pluginName);
    }

    public Object getServer() {
        return this.server;
    }

    public void setServer(Object server) {
        this.server = server;
    }

    public boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    public void setDebugEnabled(boolean debugEnabled) {
        this.debugEnabled = debugEnabled;
    }

    public void info(String message) {
        this.logger.info(MessageFormat.format("[{0}] {1}", this.prefix, message));
    }

    public void debug(String message) {
        if (this.debugEnabled) {
            this.logger.info(MessageFormat.format("[{0}] {1}", this.prefix + "-debug", message));
        }
    }

    public void warning(String message) {
        this.logger.warning(MessageFormat.format("[{0}] {1}", this.prefix, message));
    }

    public void error(String message) {
        this.logger.warning(MessageFormat.format("[{0}] {1}", this.prefix + "-error", message));
    }

    public String getDefaultPath() {
        return System.getProperty("user.dir") + "/plugins/" + this.pluginName + "/";
    }

    public void createReportFile(CorePlayer sender) {
        this.webhookMessage.sendMessageWithFileAsync(this.createReportFile(), sender.getName());
        sender.sendMessage("Your report file was send to the support team <3 \nPlease join the Discord support server to get support: https://discord.gg/5zuC36R");
    }

    public String createReportFile() {
        String zipFile = "";
        try {
            zipFile = this.getDefaultPath() + "report.zip";
            List<String> sourceFiles = this.getPathList(this.getDefaultPath());
            sourceFiles.add(System.getProperty("user.dir") + "/logs/latest.log");
            File zip = new File(zipFile);
            if (zip.exists()) {
                zip.delete();
            }
            byte[] buffer = new byte[1024];
            FileOutputStream fos = new FileOutputStream(zipFile);
            ZipOutputStream zos = new ZipOutputStream(fos);
            for (int i = 0; i < sourceFiles.size(); ++i) {
                int length;
                File srcFile = new File(sourceFiles.get(i));
                if (!srcFile.exists() || sourceFiles.get(i).equalsIgnoreCase(zipFile) || srcFile.getName().equalsIgnoreCase(".DS_STORE")) continue;
                FileInputStream fis = new FileInputStream(srcFile);
                zos.putNextEntry(new ZipEntry(srcFile.getName()));
                while ((length = fis.read(buffer)) > 0) {
                    zos.write(buffer, 0, length);
                }
                zos.closeEntry();
                fis.close();
            }
            zos.close();
        }
        catch (IOException e) {
            this.warning("Error creating zip file: " + e);
        }
        return zipFile;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public void setPluginName(String pluginName) {
        this.pluginName = pluginName;
    }

    public String getFormat() {
        return "[{0}] {1}";
    }

    public ServerSoftware getSoftware() {
        return this.software;
    }

    public void setSoftware(ServerSoftware software) {
        this.software = software;
    }

    private List<String> getPathList(String mainPath) {
        File directory = new File(mainPath);
        File[] fileList = directory.listFiles();
        ArrayList<String> pathList = new ArrayList<String>();
        for (File file : fileList) {
            if (file.isFile()) {
                pathList.add(file.getPath());
            }
            if (!file.isDirectory() || file.getPath().endsWith("lib")) continue;
            pathList.addAll(this.getPathList(file.getAbsolutePath()));
        }
        return pathList;
    }

    public WebhookMessage getWebhookMessage() {
        return this.webhookMessage;
    }

    public void setWebhookMessage(WebhookMessage webhookMessage) {
        this.webhookMessage = webhookMessage;
    }

    public CommandService getCommandService() {
        return this.commandService;
    }

    public void setCommandService(CommandService commandService) {
        this.commandService = commandService;
    }

    public JacksonHandler getFileHandler() {
        return this.fileHandler;
    }

    public StrongTextEncryptor getTextHandler() {
        return this.textHandler;
    }

    public List<UUID> getOnlinePlayerUUID() {
        switch (this.software) {
            case SPIGOT: {
                return SpigotFunctions.getAllOnlinePlayersUUID();
            }
            case BUNGEECORD: {
                return BungeeFunctions.getOnlinePlayerUUIDs();
            }
            case VELOCITY: {
                return VelocityFunctions.getOnlinePlayerUUIDs(this.server);
            }
        }
        return null;
    }

    public List<String> getOnlinePlayerNames() {
        switch (this.software) {
            case SPIGOT: {
                return SpigotFunctions.getAllOnlinePlayersName();
            }
            case BUNGEECORD: {
                return BungeeFunctions.getOnlinePlayerNames();
            }
            case VELOCITY: {
                return VelocityFunctions.getOnlinePlayerNames(this.server);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getValueFromUrl(String url) {
        String value = "";
        try (Scanner scanner = null;){
            scanner = new Scanner(new URL(url).openStream(), "UTF-8");
            value = scanner.next();
        }
        this.debug("URL Value: " + value);
        return value;
    }

    public List<String> returnContextList(List<String> list, String[] args, boolean withOnlinePlayers) {
        int index = args.length - 1;
        ArrayList<String> list2 = new ArrayList<String>();
        if (withOnlinePlayers) {
            list.addAll(this.getOnlinePlayerNames());
        }
        if (list != null) {
            for (String s : list) {
                if (!s.toLowerCase().contains(args[index].toLowerCase())) continue;
                list2.add(s);
            }
        }
        return list2;
    }

    public String parsePAPI(String message, String playerName) {
        switch (this.software) {
            case SPIGOT: {
                return SpigotFunctions.parsePAPIValues(message, playerName);
            }
        }
        return message;
    }
}

