/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.external.morelib.core.player;

import com.morelaid.streamingmodule.external.j256.ormlite.field.DataType;
import com.morelaid.streamingmodule.external.j256.ormlite.field.DatabaseField;
import com.morelaid.streamingmodule.external.morelib.core.functions.CoreFunctions;
import com.morelaid.streamingmodule.external.morelib.core.functions.ServerSoftware;
import com.morelaid.streamingmodule.external.morelib.core.player.CorePlayerEvents;
import com.morelaid.streamingmodule.external.morelib.core.player.MessageSender;
import com.morelaid.streamingmodule.external.morelib.server.bungee.BungeeFunctions;
import com.morelaid.streamingmodule.external.morelib.server.spigot.SpigotFunctions;
import com.morelaid.streamingmodule.external.morelib.server.velocity.VelocityFunctions;
import java.util.UUID;

public abstract class CorePlayer
implements CorePlayerEvents {
    @DatabaseField(id=true)
    protected UUID uuid;
    @DatabaseField(dataType=DataType.STRING)
    protected String name;
    @DatabaseField(persisted=false)
    protected transient ServerSoftware software;
    @DatabaseField(persisted=false)
    protected transient Object sender;
    @DatabaseField(persisted=false)
    protected transient CoreFunctions service;

    public CorePlayer() {
    }

    public CorePlayer(CoreFunctions service, UUID uuid, String name, Object sender) {
        this.uuid = uuid;
        this.name = name;
        this.sender = sender;
        this.software = service.getSoftware();
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Object getSender() {
        return this.sender;
    }

    public void setSender(Object sender) {
        this.sender = sender;
    }

    public boolean hasPermission(String permission) {
        if (this.uuid == null) {
            return true;
        }
        switch (this.software) {
            case SPIGOT: {
                return SpigotFunctions.hasPermission(this, permission);
            }
            case BUNGEECORD: {
                return BungeeFunctions.hasPermission(this, permission);
            }
            case VELOCITY: {
                return VelocityFunctions.hasPermission(this, permission);
            }
        }
        return false;
    }

    public String getWorldName() {
        switch (this.software) {
            case SPIGOT: {
                return SpigotFunctions.getWorldName(this);
            }
            case BUNGEECORD: {
                return BungeeFunctions.getWorldName(this);
            }
            case VELOCITY: {
                return VelocityFunctions.getWorldName(this);
            }
        }
        return "world";
    }

    public void sendMessage(String msg) {
        String message = this.onPlaceholder(msg);
        if (message.isEmpty() || message == null) {
            message = msg;
        }
        MessageSender.send(this, message);
    }

    public void sendCleanMessage(String msg) {
        MessageSender.cleanSend(this, msg);
    }

    public ServerSoftware getSoftware() {
        return this.software;
    }

    public void setSoftware(ServerSoftware software) {
        this.software = software;
    }

    public CoreFunctions getService() {
        return this.service;
    }

    public void setService(CoreFunctions service) {
        this.service = service;
    }

    public boolean isPlayer() {
        return this.uuid != null;
    }

    public boolean isOnline() {
        switch (this.software) {
            case SPIGOT: {
                return SpigotFunctions.isPlayerOnline(this);
            }
            case BUNGEECORD: {
                return BungeeFunctions.isPlayerOnline(this);
            }
            case VELOCITY: {
                return VelocityFunctions.isPlayerOnline(this);
            }
        }
        return false;
    }

    public boolean hasInventorySpace() {
        switch (this.software) {
            case SPIGOT: {
                return SpigotFunctions.hasInventorySpace(this);
            }
            case BUNGEECORD: 
            case VELOCITY: {
                return true;
            }
        }
        return false;
    }
}

