/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.general.async;

import com.morelaid.streamingmodule.general.discord.DiscordWebhook;
import com.morelaid.streamingmodule.general.file.streamer.Streamer;
import com.morelaid.streamingmodule.general.function.ServiceHandler;
import java.io.IOException;
import java.net.URL;
import java.util.Scanner;

public class DiscordWebhookSender_Async
implements Runnable {
    private ServiceHandler service;
    private Streamer streamer;
    private String twitchTitle = "";
    private String twitchGame = "";

    public DiscordWebhookSender_Async(ServiceHandler service, Streamer streamer) {
        this.service = service;
        this.streamer = streamer;
    }

    @Override
    public void run() {
        if (this.service.getSettings().getDiscord().isEnable() && !this.service.getSettings().getDiscord().getWebhookUrl().isEmpty() && !this.service.getSettings().getDiscord().getWebhookUrl().equals("https://discordapp.com/api/webhooks/...")) {
            this.generateAndSendMessage();
        }
    }

    private String getStreamTitle() {
        Scanner atrScan = null;
        Object str = "";
        try {
            atrScan = new Scanner(new URL("https://decapi.me/twitch/status/" + this.streamer.getName()).openStream());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        while (atrScan.hasNext()) {
            str = (String)str + atrScan.next() + " ";
        }
        return str;
    }

    private String getStreamGame() {
        Scanner atrScan = null;
        Object str = "";
        try {
            atrScan = new Scanner(new URL("https://decapi.me/twitch/game/" + this.streamer.getName()).openStream());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        while (atrScan.hasNext()) {
            str = (String)str + atrScan.next() + " ";
        }
        return str;
    }

    private void generateAndSendMessage() {
        Scanner atrScan = null;
        try {
            atrScan = new Scanner(new URL("https://decapi.me/twitch/avatar/" + this.streamer.getName()).openStream());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String thumbnailUrl = atrScan.next();
        this.twitchTitle = this.getStreamTitle();
        this.twitchGame = this.getStreamGame();
        DiscordWebhook webhook = new DiscordWebhook(this.service.getSettings().getDiscord().getWebhookUrl());
        if (!this.service.getMessages().getDiscord().getContent().isEmpty()) {
            webhook.setContent(this.parse(this.service.getMessages().getDiscord().getContent()));
        }
        webhook.setUsername(this.service.getSettings().getDiscord().getUsername());
        webhook.setAvatarUrl(this.service.getFunctions().getDiscordAvatar());
        if (this.service.getSettings().getDiscord().getUsername().equals("StreamingModule")) {
            webhook.addEmbed(new DiscordWebhook.EmbedObject().setTitle(this.parse(this.service.getMessages().getDiscord().getTitle())).setImage(String.format("https://static-cdn.jtvnw.net/previews-ttv/live_user_%1s-1920x1080.jpg", this.streamer.getName())).setThumbnail(thumbnailUrl).addField(this.parse(this.service.getMessages().getDiscord().getDescription()), this.parse(this.service.getMessages().getDiscord().getAdditionalText()), true).addField("____________________", "https://twitch.tv/" + this.streamer.getName(), false).setUrl("https://twitch.tv/" + this.streamer.getName()));
        } else {
            webhook.addEmbed(new DiscordWebhook.EmbedObject().setTitle(this.parse(this.service.getMessages().getDiscord().getTitle())).setImage(String.format("https://static-cdn.jtvnw.net/previews-ttv/live_user_%1s-1920x1080.jpg", this.streamer.getName())).setThumbnail(thumbnailUrl).addField(this.parse(this.service.getMessages().getDiscord().getDescription()), this.parse(this.service.getMessages().getDiscord().getAdditionalText()), true).addField("____________________", "https://twitch.tv/" + this.streamer.getName(), false).setUrl("https://twitch.tv/" + this.streamer.getName()).setFooter("Powered by StreamingModule", "https://cdn.discordapp.com/attachments/691311505655988244/745923747114123284/StreamingLoots_Logo2.png"));
        }
        try {
            webhook.execute();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String parse(String input) {
        String value = input;
        value = value.replace("%streamer%", this.streamer.getName()).replace("%streamername%", this.service.getUserByPlatform(false, this.streamer.getName()).getName()).replace("%twitchtitle%", this.twitchTitle).replace("%twitchgame%", this.twitchGame);
        return value;
    }
}

