/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.general.async;

import com.morelaid.streamingmodule.general.file.database.DropHistory;
import com.morelaid.streamingmodule.general.file.database.ModuleUser;
import com.morelaid.streamingmodule.general.function.ServiceHandler;
import java.util.List;

public class SendOfflineDrops_Async
implements Runnable {
    private ServiceHandler service;
    private ModuleUser user;
    private boolean showMessage;

    public SendOfflineDrops_Async(ServiceHandler service, ModuleUser user, boolean showMessage) {
        this.service = service;
        this.user = user;
        this.showMessage = showMessage;
    }

    @Override
    public void run() {
        this.checkAndSendDrops();
    }

    private void checkAndSendDrops() {
        List<DropHistory> drops = this.service.getFunctions().getOpenDropsForUser(this.user);
        if (this.service.getDropService().isPlayerOnline(this.user) && !drops.isEmpty()) {
            this.user.sendMessage(this.service.getMessages().getOpenDrops().replace("%opendrops%", Integer.toString(drops.size())));
            for (DropHistory history : drops) {
                this.service.getCommandService().console(history.getCommand());
                history.setTransferred(true);
                this.service.saveDropHistory(history);
            }
        } else if (this.showMessage) {
            this.user.sendMessage(this.service.getMessages().getNoOfflineDrops());
        }
    }
}

