/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.general.file.streamer;

import com.google.gson.Gson;
import com.morelaid.streamingmodule.external.j256.ormlite.field.DataType;
import com.morelaid.streamingmodule.external.j256.ormlite.field.DatabaseField;
import com.morelaid.streamingmodule.external.jackson.annotation.JsonIgnore;
import com.morelaid.streamingmodule.external.jackson.annotation.JsonIgnoreProperties;
import com.morelaid.streamingmodule.general.file.database.EncryptedStringType;
import com.morelaid.streamingmodule.general.file.streamer.StreamerSettings;
import com.morelaid.streamingmodule.general.file.streamer.streamercontainer.StreamerContainer;
import org.jasypt.util.text.StrongTextEncryptor;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Streamer {
    @DatabaseField(id=true)
    private String name = "";
    @JsonIgnore
    @DatabaseField(dataType=DataType.SERIALIZABLE, persisterClass=EncryptedStringType.class, canBeNull=false)
    private String metaData = "";
    @DatabaseField(persisted=false)
    private transient StreamerSettings settings = new StreamerSettings();
    @DatabaseField(persisted=false)
    @JsonIgnore
    private transient String twitchBotName_Premium = "StreamingModule";
    @JsonIgnore
    @DatabaseField(persisted=false)
    private transient StrongTextEncryptor textEncryptor = new StrongTextEncryptor();

    public Streamer() {
        this.textEncryptor.setPassword("StreamingModule#b9a3e3");
        if (this.metaData.equalsIgnoreCase("")) {
            this.setMetaData(new Gson().toJson((Object)new StreamerContainer()));
        }
    }

    public Streamer(String name) {
        this.name = name;
    }

    public StreamerSettings getSettings() {
        return this.settings;
    }

    public void setSettings(StreamerSettings settings) {
        this.settings = settings;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTwitchBotName_Premium() {
        return this.twitchBotName_Premium;
    }

    public void setTwitchBotName_Premium(String twitchBotName_Premium) {
        this.twitchBotName_Premium = twitchBotName_Premium;
    }

    public String getMetaData() {
        return this.textEncryptor.decrypt(this.metaData);
    }

    public void setMetaData(String metaData) {
        this.metaData = this.textEncryptor.encrypt(metaData);
    }
}

