/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.general.function;

import com.morelaid.streamingmodule.general.file.database.ModuleUser;
import com.morelaid.streamingmodule.general.file.streamer.Streamer;
import com.morelaid.streamingmodule.general.function.ServiceHandler;

public class PlaceholderFunctions {
    private final ServiceHandler service;

    public PlaceholderFunctions(ServiceHandler service) {
        this.service = service;
    }

    public String parsePlaceholder(ModuleUser user, String params) {
        String value = "";
        try {
            Streamer streamer;
            if (params.startsWith("nextdrop")) {
                return Integer.toString(this.service.getFunctions().getDropsTimeLeft());
            }
            if (params.startsWith("livetag_")) {
                String streamerName = params.split("livetag_")[1].toLowerCase();
                return this.service.getStreamerLiveStatus().contains(streamerName.toLowerCase()) ? this.service.getSettings().getPlaceholder().getLiveTag() : this.service.getSettings().getPlaceholder().getOfflineTag();
            }
            if (params.startsWith("generaldrops")) {
                return Integer.toString(this.service.getSettings().getDrops().size());
            }
            if (params.startsWith("senddrops_")) {
                String streamerName = params.split("senddrops_")[1].toLowerCase();
                return Long.toString(this.service.getDropHistory().stream().filter(item -> item.getBy().equals(this.service.getStreamerByName(streamerName))).count());
            }
            if (params.startsWith("senddrops")) {
                return Integer.toString(this.service.getDropHistory().size());
            }
            if (params.startsWith("twitch")) {
                return user.getPlatformName();
            }
            if (params.startsWith("livetag")) {
                return this.service.getStreamerLiveStatus().contains(user.getPlatformName().toLowerCase()) ? this.service.getSettings().getPlaceholder().getLiveTag() : "";
            }
            if (params.startsWith("streamerstatus") && (streamer = this.service.getStreamerByName(user.getPlatformName())) != null) {
                return this.service.getStreamerLiveStatus().contains(streamer.getName().toLowerCase()) ? this.service.getSettings().getPlaceholder().getLiveTag() : this.service.getSettings().getPlaceholder().getOfflineTag();
            }
            if (params.startsWith("dropsamount")) {
                return Integer.toString(this.service.getFunctions().getDropsAmount(user));
            }
        }
        catch (Exception e) {
            this.service.debug(e.getMessage());
        }
        return value;
    }
}

