/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.general.function;

import com.morelaid.streamingmodule.external.morelib.core.functions.ServerSoftware;
import com.morelaid.streamingmodule.general.file.database.ModuleUser;
import com.morelaid.streamingmodule.general.file.streamer.Streamer;
import com.morelaid.streamingmodule.general.function.ServiceHandler;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PlaceholderProxy {
    private final ServiceHandler service;

    public PlaceholderProxy(ServiceHandler service) {
        this.service = service;
    }

    public String parseProxyPAPI(ModuleUser user, String message) {
        if (this.service.getSoftware().equals((Object)ServerSoftware.SPIGOT)) {
            return message;
        }
        String value = message;
        try {
            Streamer streamer;
            String streamerName;
            if (value.contains("%sm_nextdrop%")) {
                value = value.replace("%sm_nextdrop%", Integer.toString(this.service.getFunctions().getDropsTimeLeft()));
            }
            if (value.contains("%sm_livetag_")) {
                streamerName = this.extractValue(value, "%sm_livetag");
                String output = this.service.getStreamerLiveStatus().contains(streamerName.toLowerCase()) ? this.service.getSettings().getPlaceholder().getLiveTag() : this.service.getSettings().getPlaceholder().getOfflineTag();
                value = value.replace("%sm_livetag_" + streamerName + "%", output);
            }
            if (value.contains("%sm_generaldrops%")) {
                value = value.replace("%sm_generaldrops%", Integer.toString(this.service.getSettings().getDrops().size()));
            }
            if (value.contains("%sm_senddrops_")) {
                streamerName = this.extractValue(value, "%sm_senddrops");
                value = value.replace("%sm_senddrops_" + streamerName + "%", Long.toString(this.service.getDropHistory().stream().filter(item -> item.getBy().equals(this.service.getStreamerByName(streamerName))).count()));
            }
            if (value.contains("%sm_senddrops%")) {
                value = value.replace("%sm_senddrops%", Integer.toString(this.service.getDropHistory().size()));
            }
            if (value.contains("%sm_twitch%")) {
                value = value.replace("%sm_twitch%", user.getPlatformName());
            }
            if (value.contains("%sm_livetag%")) {
                String tempValue = this.service.getStreamerLiveStatus().contains(user.getPlatformName().toLowerCase()) ? this.service.getSettings().getPlaceholder().getLiveTag() : "";
                value = value.replace("%sm_livetag%", tempValue);
            }
            if (value.contains("%sm_streamerstatus%") && (streamer = this.service.getStreamerByName(user.getPlatformName())) != null) {
                String tempValue = this.service.getStreamerLiveStatus().contains(streamer.getName().toLowerCase()) ? this.service.getSettings().getPlaceholder().getLiveTag() : this.service.getSettings().getPlaceholder().getOfflineTag();
                value = value.replace("%sm_streamerstatus%", tempValue);
            }
            if (value.contains("%sm_dropsamount%")) {
                value = value.replace("%sm_dropsamount%", Integer.toString(this.service.getFunctions().getDropsAmount(user)));
            }
        }
        catch (Exception e) {
            this.service.debug(e.getMessage());
        }
        return value;
    }

    private String extractValue(String input, String base) {
        String regex = Pattern.quote(base) + "_([^%]+)%";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(input);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return input;
    }
}

