/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.general.function;

import com.morelaid.streamingmodule.general.async.DiscordWebhookSender_Async;
import com.morelaid.streamingmodule.general.async.SendMinecraftMessage_Aync;
import com.morelaid.streamingmodule.general.async.SendOfflineDrops_Async;
import com.morelaid.streamingmodule.general.async.SendTwitchMessage_Async;
import com.morelaid.streamingmodule.general.file.database.DropHistory;
import com.morelaid.streamingmodule.general.file.database.ModuleUser;
import com.morelaid.streamingmodule.general.file.database.WatchedTimeLog;
import com.morelaid.streamingmodule.general.file.streamer.Streamer;
import com.morelaid.streamingmodule.general.file.streamer.streamercontainer.StreamerContainer;
import com.morelaid.streamingmodule.general.function.ServiceHandler;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class SMFunctions {
    private final ServiceHandler service;

    public SMFunctions(ServiceHandler service) {
        this.service = service;
    }

    public ModuleUser getUserByPlatformName(String platformName) {
        List tempUserList = this.service.getUserList().stream().filter(user -> user.getPlatformName().equalsIgnoreCase(platformName)).collect(Collectors.toList());
        return !tempUserList.isEmpty() ? (ModuleUser)tempUserList.get(0) : null;
    }

    public ModuleUser getUserByMinecraftName(String minecraftName) {
        List tempUserList = this.service.getUserList().stream().filter(user -> user.getName().equalsIgnoreCase(minecraftName)).collect(Collectors.toList());
        return !tempUserList.isEmpty() ? (ModuleUser)tempUserList.get(0) : null;
    }

    public ModuleUser getUserByUuid(UUID uuid) {
        List tempUserList = this.service.getUserList().stream().filter(user -> user.getUuid().toString().equalsIgnoreCase(uuid.toString())).collect(Collectors.toList());
        return !tempUserList.isEmpty() ? (ModuleUser)tempUserList.get(0) : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isTwitchNameInUse(ModuleUser user, String name) {
        ModuleUser tempUser = this.getUserByPlatformName(name);
        if (tempUser != null) {
            if (!tempUser.getName().equalsIgnoreCase(user.getName())) return true;
        }
        if (!this.service.getSettings().getBlacklistTwitchChannel().stream().anyMatch(name::equalsIgnoreCase)) return false;
        return true;
    }

    public int getDropsAmount(ModuleUser moduleUser) {
        List<DropHistory> list = this.service.getDatabaseManager().getDropsAmount(moduleUser);
        if (list != null) {
            return list.size();
        }
        return 0;
    }

    public List<DropHistory> getOpenDropsForUser(ModuleUser user) {
        return this.service.getDatabaseManager().getOpenDropsForUser(user);
    }

    public void sendOfflineDrops(ModuleUser user, boolean showMessage, boolean withDelay) {
        long delay = withDelay ? 10L : 1L;
        this.service.getScheduler().schedule(new SendOfflineDrops_Async(this.service, user, showMessage), delay, TimeUnit.SECONDS);
    }

    public void sendStartingMessage(ModuleUser user) {
        if (!user.isChanged()) {
            this.service.getScheduler().schedule(new SendMinecraftMessage_Aync(user, this.service.getMessages().getTwitchConnection()), 10L, TimeUnit.SECONDS);
        }
    }

    public int getDropsTimeLeft() {
        return this.service.getSettings().getDropOptions().getInterval() - this.service.getCurrentTime();
    }

    public boolean sendTwitchMessage(ModuleUser user, String[] args) {
        if (args.length >= 2) {
            this.service.getScheduler().schedule(new SendTwitchMessage_Async(this.service, user, args), 0L, TimeUnit.SECONDS);
            return true;
        }
        return false;
    }

    public boolean sendTwitchMessage(String streamer, String message) {
        ModuleUser user = this.service.getUserByPlatform(false, streamer);
        user.setUuid(null);
        String[] args = new String[]{streamer, message};
        return this.sendTwitchMessage(user, args);
    }

    public int getUserWatchTime(String platformName) {
        int amount = 0;
        List<WatchedTimeLog> log = this.service.getDatabaseManager().getUsersWatchTimeAll(platformName);
        for (WatchedTimeLog item : log) {
            amount += item.getWatchTime();
        }
        return amount;
    }

    public int getUserWatchTime(String platformName, Streamer streamer) {
        WatchedTimeLog watchedTimeLog = this.service.getDatabaseManager().getUsersWatchTime(platformName, streamer);
        if (watchedTimeLog != null) {
            return watchedTimeLog.getWatchTime();
        }
        return 0;
    }

    public String getDiscordAvatar() {
        return "https://cdn.discordapp.com/attachments/691311505655988244/745923747114123284/StreamingLoots_Logo2.png";
    }

    public void addGlobalStreamerStatus(Streamer streamer) {
        if (!this.service.getStreamerLiveStatus().contains(streamer.getName().toLowerCase()) && !this.service.getLiveMessageSend().contains(streamer.getName().toLowerCase())) {
            this.service.getCommandService().console("smpublic " + this.service.parsePlaceholder(null, streamer, this.service.getMessages().getLiveAnnouncement()));
            this.service.getScheduler().schedule(new DiscordWebhookSender_Async(this.service, streamer), 0L, TimeUnit.SECONDS);
            this.service.getLiveMessageSend().add(streamer.getName().toLowerCase());
        }
        this.service.getStreamerLiveStatus().add(streamer.getName().toLowerCase());
    }

    public boolean isStreamerChatBotEnabled(Streamer streamer) {
        StreamerContainer metaData = this.service.getStreamerMetaData(streamer);
        if (metaData != null) {
            return metaData.isTwitchMessage();
        }
        return false;
    }

    public void resetStreamerMetaConnection(Streamer streamer) {
        StreamerContainer container;
        if (streamer != null && (container = this.service.getStreamerMetaData(streamer)) != null) {
            container.setKnownConnection(streamer.getName());
            container.setTwitchMessage(false);
            this.service.addStreamerMetaData(streamer, container);
        }
    }

    public void resetStreamerMetaConnection(ModuleUser user) {
        if (this.service.isStreamer(user.getPlatformName())) {
            Streamer streamer = this.service.getStreamerByName(user.getPlatformName());
            this.resetStreamerMetaConnection(streamer);
            this.service.getFunctions().syncStreamer(streamer);
        }
    }

    public void syncStreamer(Streamer streamer) {
        Streamer dbStreamer = this.service.getDatabaseManager().getStreamerFromDB(streamer.getName());
        if (dbStreamer == null || dbStreamer.getMetaData() == null) {
            this.service.getDatabaseManager().createOrUpdateStreamer(streamer);
            dbStreamer = streamer;
        }
        streamer.setMetaData(dbStreamer.getMetaData());
        this.service.getStreamerCache().put(streamer.getName().toLowerCase(), streamer);
    }

    public void setStreamerValidation(Streamer streamer) {
        this.service.getStreamerCache().put(streamer.getName().toLowerCase(), streamer);
        this.service.getDatabaseManager().createOrUpdateStreamer(streamer);
    }

    public boolean smChatBot_Command(ModuleUser moduleUser) {
        if (moduleUser.hasPermission("sm.admin.*") || moduleUser.hasPermission("sm.streamer.smchatbot")) {
            if (this.service.isStreamer(moduleUser.getPlatformName())) {
                moduleUser.sendMessage("---------- &5Streamer&f ChatBot ----------");
                moduleUser.sendMessage(this.service.getMessages().getModuleKeyText());
                moduleUser.sendMessage(this.service.getMessages().getModuleKeyStatusText());
            } else {
                moduleUser.sendMessage(this.service.getMessages().getNoStreamerFound());
            }
            return true;
        }
        return false;
    }

    public boolean sendStreamerOnlineList(ModuleUser moduleUser) {
        List onlineStreamer = this.service.getStreamer().getStreamers().stream().filter(streamer -> this.service.getStreamerLiveStatus().contains(streamer.getName().toLowerCase())).collect(Collectors.toList());
        if (!onlineStreamer.isEmpty()) {
            moduleUser.sendMessage(this.service.getMessages().getStreamerLive());
            for (Streamer streamer2 : onlineStreamer) {
                String message = this.service.getSettings().getOnlineStreamerFormat();
                message = message.replace("%streamer%", streamer2.getName());
                moduleUser.sendMessage(message);
            }
            return true;
        }
        return false;
    }
}

