/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.general.function;

import com.google.gson.Gson;
import com.morelaid.shared.StreamerLiveTag;
import com.morelaid.streamingmodule.external.morelib.core.functions.CoreFunctions;
import com.morelaid.streamingmodule.external.morelib.core.functions.ServerSoftware;
import com.morelaid.streamingmodule.general.async.CurrentTimer_Async;
import com.morelaid.streamingmodule.general.async.DropService_Async;
import com.morelaid.streamingmodule.general.async.LiveStatusChecker_Async;
import com.morelaid.streamingmodule.general.async.SaveDatabase_Async;
import com.morelaid.streamingmodule.general.async.SaveDetailDropHistory_Async;
import com.morelaid.streamingmodule.general.async.SaveDetailModuleUser_Async;
import com.morelaid.streamingmodule.general.async.TwitchConnection_Async;
import com.morelaid.streamingmodule.general.async.UserCache_Async;
import com.morelaid.streamingmodule.general.async.WatchTimeChecker_Async;
import com.morelaid.streamingmodule.general.file.chatbot.ChatBot;
import com.morelaid.streamingmodule.general.file.database.DropHistory;
import com.morelaid.streamingmodule.general.file.database.ModuleUser;
import com.morelaid.streamingmodule.general.file.message.Messages;
import com.morelaid.streamingmodule.general.file.settings.Settings;
import com.morelaid.streamingmodule.general.file.streamer.Streamer;
import com.morelaid.streamingmodule.general.file.streamer.Streamers;
import com.morelaid.streamingmodule.general.file.streamer.streamercontainer.StreamerContainer;
import com.morelaid.streamingmodule.general.function.CommandHandler;
import com.morelaid.streamingmodule.general.function.DatabaseManager;
import com.morelaid.streamingmodule.general.function.EventHandler;
import com.morelaid.streamingmodule.general.function.PlaceholderFunctions;
import com.morelaid.streamingmodule.general.function.PlaceholderProxy;
import com.morelaid.streamingmodule.general.function.SMFunctions;
import com.morelaid.streamingmodule.general.platform.general.DropService;
import com.morelaid.streamingmodule.general.platform.twitch.TwitchFunctions;
import com.morelaid.streamingmodule.general.platform.twitch.bot.TwitchBot;
import com.morelaid.streamingmodule.general.platform.twitch.register.TwitchRegisterService;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Scanner;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class ServiceHandler
extends CoreFunctions {
    private SMFunctions functions;
    private EventHandler eventHandler;
    private final CommandHandler commandHandler;
    private TwitchRegisterService twitchRegisterService;
    private Set<String> streamerLiveStatus;
    private TwitchFunctions twitchFunctions;
    private HashMap<String, TwitchBot> botList;
    private List<String> liveMessageSend = new ArrayList<String>();
    private HashMap<String, StreamerLiveTag> streamerLiveTagForPAPI;
    private String settings_path;
    private String messages_path;
    private String database_path;
    private String localDatabaseConnectionString;
    private String chatCommand_path;
    private String streamer_path;
    private Settings settings;
    private Messages messages;
    private ChatBot chatCommands;
    private DatabaseManager databaseManager;
    private Streamers streamer;
    private int currentTime = 0;
    private HashMap<UUID, ModuleUser> userCache;
    private HashMap<String, Streamer> streamerCache;
    private DropService dropService;
    private final PlaceholderFunctions placeholderFunctions;
    private final PlaceholderProxy placeholderProxy;
    private ScheduledExecutorService scheduler;

    public ServiceHandler(Logger logger, String prefix, String pluginName, ServerSoftware software, Object server) {
        super(logger, prefix, pluginName, software, server);
        this.commandHandler = new CommandHandler(this);
        this.placeholderFunctions = new PlaceholderFunctions(this);
        this.placeholderProxy = new PlaceholderProxy(this);
        this.scheduler = new ScheduledThreadPoolExecutor(Runtime.getRuntime().availableProcessors());
        this.reload(true);
    }

    public String getPluginPath() {
        Object defaultPath = System.getProperty("user.dir");
        switch (this.software) {
            case SPIGOT: {
                defaultPath = (String)defaultPath + "/plugins/StreamingModule/";
            }
        }
        return defaultPath;
    }

    private void generateFilePath() {
        Object defaultPath = System.getProperty("user.dir");
        switch (this.software) {
            case SPIGOT: 
            case BUNGEECORD: 
            case VELOCITY: {
                defaultPath = (String)defaultPath + "/plugins/StreamingModule/";
                break;
            }
            default: {
                defaultPath = (String)defaultPath + "/plugins/StreamingModule/";
            }
        }
        this.settings_path = (String)defaultPath + "settings.yml";
        this.messages_path = (String)defaultPath + "messages.yml";
        this.chatCommand_path = (String)defaultPath + "chatbot.yml";
        this.database_path = (String)defaultPath + "data.sm";
        this.streamer_path = (String)defaultPath + "streamer.yml";
        this.localDatabaseConnectionString = "jdbc:sqlite:" + this.database_path;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    public Messages getMessages() {
        return this.messages;
    }

    public void setMessages(Messages messages) {
        this.messages = messages;
    }

    public List<ModuleUser> getUserList() {
        return this.databaseManager.getModuleUserData();
    }

    public boolean reload() {
        return this.reload(false);
    }

    public boolean reload(boolean forceReload) {
        boolean valid = true;
        try {
            this.generateFilePath();
            this.functions = new SMFunctions(this);
            this.eventHandler = new EventHandler(this);
            this.twitchRegisterService = new TwitchRegisterService(this);
            this.settings = new Settings();
            this.settings = (Settings)this.getFileHandler().reloadFile(this.settings_path, this.settings);
            this.messages = new Messages();
            this.messages = (Messages)this.getFileHandler().reloadFile(this.messages_path, this.messages);
            this.chatCommands = new ChatBot();
            this.chatCommands = (ChatBot)this.getFileHandler().reloadFile(this.chatCommand_path, this.chatCommands);
            this.streamer = new Streamers();
            this.streamer = (Streamers)this.getFileHandler().reloadFile(this.streamer_path, this.streamer);
            this.userCache = new HashMap();
            this.streamerCache = new HashMap();
            this.setDebugEnabled(this.getSettings().isDebug());
            this.databaseManager = this.settings.getSqlSettings().isEnable() ? new DatabaseManager(this, this.doubleSlash(this.settings.getSqlSettings().getDriver()) + this.settings.getSqlSettings().getServer() + ":" + this.settings.getSqlSettings().getPort() + "/" + this.settings.getSqlSettings().getDatabase() + "?user=" + this.settings.getSqlSettings().getUser() + "&password=" + this.settings.getSqlSettings().getPassword()) : new DatabaseManager(this, this.localDatabaseConnectionString);
            this.twitchFunctions = new TwitchFunctions(this);
            this.getScheduler().schedule(new TwitchConnection_Async(this), 0L, TimeUnit.SECONDS);
            this.dropService = new DropService(this);
            if (forceReload) {
                this.streamerLiveStatus = new HashSet<String>();
                this.liveMessageSend = new ArrayList<String>();
                this.getScheduler().scheduleWithFixedDelay(new LiveStatusChecker_Async(this), 10L, 180L, TimeUnit.SECONDS);
                this.getScheduler().scheduleWithFixedDelay(new CurrentTimer_Async(this), 0L, 60L, TimeUnit.SECONDS);
                this.setCurrentTime(0);
                this.getScheduler().scheduleWithFixedDelay(new DropService_Async(this), 60L, 60L * (long)this.getSettings().getDropOptions().getInterval(), TimeUnit.SECONDS);
                if (this.getSettings().getWatchTime().isEnabled()) {
                    this.getScheduler().scheduleWithFixedDelay(new WatchTimeChecker_Async(this), 15L, 60L * (long)this.getWatchTimeInterval(), TimeUnit.SECONDS);
                }
                this.getScheduler().scheduleWithFixedDelay(new UserCache_Async(this), 0L, 60L, TimeUnit.SECONDS);
            }
            this.getScheduler().schedule(new SaveDatabase_Async(this), 0L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            valid = false;
            e.printStackTrace();
        }
        return valid;
    }

    private String doubleSlash(String input) {
        Object output = input;
        if (!((String)output).endsWith("//")) {
            output = (String)output + "//";
        }
        return output;
    }

    public SMFunctions getFunctions() {
        return this.functions;
    }

    public EventHandler getEventHandler() {
        return this.eventHandler;
    }

    public CommandHandler getCommandHandler() {
        return this.commandHandler;
    }

    public DropService getDropService() {
        return this.dropService;
    }

    public ModuleUser getUserByPlatform(boolean useNull, String ... args) {
        for (String username : args) {
            List users = this.getUserList().stream().filter(u -> u.getPlatformName().equalsIgnoreCase(username)).collect(Collectors.toList());
            if (users.isEmpty()) continue;
            ModuleUser moduleUser = (ModuleUser)users.get(0);
            moduleUser.setService(this);
            return moduleUser;
        }
        return useNull ? null : new ModuleUser(this, null, args[0], null);
    }

    public ModuleUser getUserByUUID(UUID uuid) {
        List list;
        if (uuid != null && !(list = this.getUserList().stream().filter(u -> u.getUuid().equals(uuid)).collect(Collectors.toList())).isEmpty()) {
            return (ModuleUser)list.get(0);
        }
        return null;
    }

    public ModuleUser getUserByName(String name) {
        return (ModuleUser)this.getUserList().stream().filter(u -> u.getName().equalsIgnoreCase(name)).collect(Collectors.toList()).get(0);
    }

    public boolean isStreamer(String streamerName) {
        return this.streamer.getStreamers().stream().anyMatch(s -> s.getName().equalsIgnoreCase(streamerName));
    }

    public Streamer getStreamerByName(String platformName) {
        return this.getStreamerCache().getOrDefault(platformName.toLowerCase(), null);
    }

    public List<DropHistory> getDropHistory() {
        return this.databaseManager.getHistoryData();
    }

    public void addCommandToOfflineList(ModuleUser user, Streamer streamer, String command) {
        DropHistory history = new DropHistory();
        history.setUser(user);
        history.setBy(streamer);
        history.setCommand(command);
        history.setTransferred(false);
        this.saveDropHistory(history);
        this.debug("Offline Command added: " + command);
    }

    public ChatBot getChatCommands() {
        return this.chatCommands;
    }

    public boolean saveSettings() {
        boolean valid = false;
        try {
            this.getFileHandler().saveFile(this.settings_path, this.settings);
            valid = true;
        }
        catch (Exception e) {
            this.debug(e.getMessage());
        }
        return valid;
    }

    public boolean saveStreamers() {
        boolean valid = false;
        try {
            this.getFileHandler().saveFile(this.streamer_path, this.streamer);
            valid = true;
        }
        catch (Exception e) {
            this.debug(e.getMessage());
        }
        return valid;
    }

    public DatabaseManager getDatabaseManager() {
        return this.databaseManager;
    }

    public void saveModuleUser(ModuleUser moduleUsers) {
        this.getScheduler().schedule(new SaveDetailModuleUser_Async(this, moduleUsers), 0L, TimeUnit.SECONDS);
    }

    public void saveDropHistory(DropHistory dropHistory) {
        this.getDropHistory().add(dropHistory);
        this.getScheduler().schedule(new SaveDetailDropHistory_Async(this, dropHistory), 0L, TimeUnit.SECONDS);
    }

    public TwitchRegisterService getTwitchRegisterService() {
        return this.twitchRegisterService;
    }

    public Set<String> getStreamerLiveStatus() {
        return this.streamerLiveStatus;
    }

    public void setStreamerLiveStatus(Set<String> streamerLiveStatus) {
        this.streamerLiveStatus = streamerLiveStatus;
    }

    public TwitchFunctions getTwitchFunctions() {
        return this.twitchFunctions;
    }

    public TwitchBot getTwitchBot(Streamer streamer) {
        return this.getBotList().get(streamer.getName());
    }

    public HashMap<String, TwitchBot> getBotList() {
        return this.botList;
    }

    public void setBotList(HashMap<String, TwitchBot> botList) {
        this.botList = botList;
    }

    public ModuleUser addModuleUser(ModuleUser moduleUser) {
        ModuleUser user = this.getFunctions().getUserByUuid(moduleUser.getUuid());
        boolean isSaveRequired = false;
        if (user == null) {
            user = moduleUser;
        }
        boolean bl = isSaveRequired = user.getUuid() != null && user.getName() != null;
        if (user.getName() == null || user.getPlatformName() == null) {
            if (user.getName() == null && moduleUser.getName() != null) {
                user.setName(moduleUser.getName());
            }
            if (user.getPlatformName() == null) {
                user.setPlatformName(user.getName());
            }
            isSaveRequired = true;
        }
        if (!moduleUser.getName().equalsIgnoreCase(user.getName())) {
            user.setName(moduleUser.getName());
            isSaveRequired = true;
        }
        if (isSaveRequired) {
            this.saveModuleUser(user);
        }
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getValueFromUrl(String url) {
        String value = "";
        try (Scanner scanner = null;){
            scanner = new Scanner(new URL(url).openStream(), StandardCharsets.UTF_8);
            value = scanner.next();
        }
        return value;
    }

    public boolean parseBoolean(String input, boolean defaultValue) {
        switch (input.trim().toLowerCase()) {
            case "true": 
            case "ja": 
            case "yes": 
            case "1": 
            case "enable": 
            case "y": 
            case "j": 
            case "an": 
            case "on": {
                return true;
            }
            case "false": 
            case "nein": 
            case "no": 
            case "0": 
            case "disable": 
            case "n": 
            case "aus": 
            case "off": {
                return false;
            }
        }
        return defaultValue;
    }

    public String parsePlaceholder(ModuleUser user, Streamer streamer, String message) {
        if (user != null) {
            message = user.parsePlaceholder(message);
            message = message.replace("%watchtime%", Integer.toString(this.getFunctions().getUserWatchTime(user.getPlatformName(), streamer)));
        }
        if (streamer != null) {
            message = message.replace("%streamer%", streamer.getName());
        }
        return message;
    }

    public int getWatchTimeInterval() {
        return this.getSettings().getWatchTime().getInterval();
    }

    public int getCurrentTime() {
        return this.currentTime;
    }

    public void setCurrentTime(int currentTime) {
        this.currentTime = currentTime;
    }

    public Streamers getStreamer() {
        return this.streamer;
    }

    public void setStreamer(Streamers streamer) {
        this.streamer = streamer;
    }

    public ScheduledExecutorService getScheduler() {
        return this.scheduler;
    }

    public List<String> getLiveMessageSend() {
        return this.liveMessageSend;
    }

    public PlaceholderFunctions getPlaceholderFunctions() {
        return this.placeholderFunctions;
    }

    public HashMap<UUID, ModuleUser> getUserCache() {
        return this.userCache;
    }

    public void setUserCache(HashMap<UUID, ModuleUser> userCache) {
        this.userCache = userCache;
    }

    public PlaceholderProxy getPlaceholderProxy() {
        return this.placeholderProxy;
    }

    public void setScheduler(ScheduledExecutorService scheduler) {
        this.scheduler = scheduler;
    }

    public StreamerContainer getStreamerMetaData(Streamer streamer) {
        if (this.isStreamer(streamer.getName())) {
            return (StreamerContainer)new Gson().fromJson(streamer.getMetaData(), StreamerContainer.class);
        }
        return null;
    }

    public void addStreamerMetaData(Streamer streamer, StreamerContainer container) {
        streamer.setMetaData(new Gson().toJson((Object)container));
        this.getDatabaseManager().updateStreamer(streamer);
        this.getStreamerCache().put(streamer.getName().toLowerCase(), streamer);
    }

    public HashMap<String, Streamer> getStreamerCache() {
        return this.streamerCache;
    }

    public void setStreamerCache(HashMap<String, Streamer> streamerCache) {
        this.streamerCache = streamerCache;
    }

    public void fillStreamerLiveTagForPAPI() {
        HashMap<String, StreamerLiveTag> list = new HashMap<String, StreamerLiveTag>();
        for (String streamerName : this.streamerLiveStatus) {
            ModuleUser user = this.getUserByPlatform(false, streamerName);
            if (user == null || user.getUuid() == null) continue;
            this.debug("not null -> fillStreamerLiveTagForPAPI: " + streamerName);
            list.put(user.getUuid().toString(), new StreamerLiveTag(user.getName(), user.getUuid(), this.getSettings().getPlaceholder().getLiveTag()));
        }
        this.setStreamerLiveTagForPAPI(list);
        this.debug("fillStreamerLiveTagForPAPI => done!!! count: " + this.getStreamerLiveTagForPAPI().size());
    }

    public HashMap<String, StreamerLiveTag> getStreamerLiveTagForPAPI() {
        return this.streamerLiveTagForPAPI;
    }

    public void setStreamerLiveTagForPAPI(HashMap<String, StreamerLiveTag> streamerLiveTagForPAPI) {
        this.streamerLiveTagForPAPI = streamerLiveTagForPAPI;
    }
}

