/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.general.platform.twitch.bot;

import com.github.philippheuer.credentialmanager.domain.OAuth2Credential;
import com.github.philippheuer.events4j.simple.SimpleEventHandler;
import com.morelaid.streamingmodule.external.twitch4j.TwitchClient;
import com.morelaid.streamingmodule.external.twitch4j.TwitchClientBuilder;
import com.morelaid.streamingmodule.external.twitch4j.chat.events.channel.ChannelMessageEvent;
import com.morelaid.streamingmodule.external.twitch4j.helix.domain.ChatMessage;
import com.morelaid.streamingmodule.external.twitch4j.helix.domain.Chatter;
import com.morelaid.streamingmodule.external.twitch4j.helix.domain.ChattersList;
import com.morelaid.streamingmodule.external.twitch4j.helix.domain.InboundFollowers;
import com.morelaid.streamingmodule.external.twitch4j.helix.domain.Stream;
import com.morelaid.streamingmodule.external.twitch4j.helix.domain.StreamList;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.events.RewardRedeemedEvent;
import com.morelaid.streamingmodule.general.file.database.ModuleUser;
import com.morelaid.streamingmodule.general.file.streamer.Streamer;
import com.morelaid.streamingmodule.general.function.ServiceHandler;
import com.morelaid.streamingmodule.general.platform.twitch.TwitchFunctions;
import com.morelaid.streamingmodule.general.platform.twitch.bot.event.TwitchChannelMessageEvent;
import com.morelaid.streamingmodule.general.platform.twitch.bot.event.TwitchRewardRedeemedEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class TwitchBot {
    private final ServiceHandler service;
    private OAuth2Credential credential;
    private TwitchClient twitchClient;
    private String botName;
    private final TwitchFunctions functions;
    private final Streamer streamer;

    public TwitchBot(ServiceHandler service, Streamer streamer, String botName, String oAuth) {
        this.service = service;
        this.streamer = streamer;
        this.functions = new TwitchFunctions(service);
        this.reload(botName, oAuth);
    }

    public void reload(String botName, String oAuth) {
        this.botName = botName;
        this.credential = new OAuth2Credential("twitch", oAuth);
        this.reload();
    }

    public void reload() {
        this.twitchClient = TwitchClientBuilder.builder().withEnableChat(Boolean.valueOf(true)).withEnableHelix(Boolean.valueOf(true)).withEnablePubSub(Boolean.valueOf(true)).withChatAccount(this.credential).withDefaultAuthToken(this.credential).withDefaultEventHandler(SimpleEventHandler.class).build();
        this.joinChannel();
    }

    private void joinChannel() {
        if (!this.streamer.getName().equalsIgnoreCase(this.botName)) {
            this.twitchClient.getChat().joinChannel(this.streamer.getName());
        }
        this.twitchClient.getEventManager().onEvent(ChannelMessageEvent.class, (Consumer)new TwitchChannelMessageEvent(this.functions, this.service));
        try {
            this.twitchClient.getPubSub().listenForChannelPointsRedemptionEvents(this.credential, this.functions.getChannelID(this.streamer.getName()));
            this.twitchClient.getEventManager().onEvent(RewardRedeemedEvent.class, (Consumer)new TwitchRewardRedeemedEvent(this.functions, this.service, this.streamer.getName()));
        }
        catch (Exception e) {
            this.service.debug("Twitch rewards: " + e.getMessage());
        }
    }

    public boolean isOnline(String broadcaster) {
        try {
            Optional stream = ((StreamList)this.twitchClient.getHelix().getStreams(this.credential.getAccessToken(), null, null, Integer.valueOf(1), null, null, null, Collections.singletonList(this.streamer.getName())).execute()).getStreams().stream().findFirst();
            if (stream.isPresent()) {
                return ((Stream)stream.get()).getUptime() != null;
            }
        }
        catch (Exception e) {
            this.service.debug(e.getMessage());
        }
        return false;
    }

    public String getBotName() {
        return this.botName;
    }

    public void disconnect() {
        this.twitchClient.getChat().disconnect();
        this.twitchClient.getPubSub().disconnect();
    }

    public List<String> getTwitchChatters(String broadcaster) {
        ChattersList list = (ChattersList)this.twitchClient.getHelix().getChatters(this.credential.getAccessToken(), this.functions.getChannelID(broadcaster), this.functions.getChannelID(this.service.getTwitchRegisterService().getStreamerRegisterList().getBotName()), Integer.valueOf(1000), "").execute();
        List<String> myChattersTwitch = list.getChatters().stream().map(Chatter::getUserLogin).map(String::toLowerCase).collect(Collectors.toList());
        myChattersTwitch.addAll(list.getChatters().stream().map(Chatter::getUserName).map(String::toLowerCase).collect(Collectors.toList()));
        myChattersTwitch = new ArrayList(new HashSet(myChattersTwitch));
        this.service.debug("Twitch chatters: " + list.getChatters().size());
        Streamer streamer = this.service.getStreamerByName(broadcaster);
        if (streamer != null && !streamer.getSettings().getStreamerOptions().isDropFromOwnStream()) {
            myChattersTwitch.removeIf(value -> value.equalsIgnoreCase(broadcaster));
        }
        return myChattersTwitch;
    }

    public List<ModuleUser> getTwitchViewer(String broadcaster) {
        ArrayList<ModuleUser> users = new ArrayList<ModuleUser>();
        List<String> viewers = this.getTwitchChatters(broadcaster);
        for (String viewer : viewers) {
            ModuleUser moduleViewer = this.service.getUserByPlatform(true, viewer);
            if (moduleViewer == null || !moduleViewer.isDropsAllowed() || this.service.getSettings().getDropOptions().isDropsOnlyForFollower() && !this.isFollower(moduleViewer.getPlatformName())) continue;
            users.add(moduleViewer);
        }
        return users;
    }

    public void sendTwitchMessage(String message, String playerName) {
        ChatMessage chatMessage = new ChatMessage(this.functions.getChannelID(this.streamer.getName()), this.functions.getChannelID(this.botName), this.service.parsePAPI(message, playerName), null, null);
        this.twitchClient.getHelix().sendChatMessage(this.credential.getAccessToken(), chatMessage).execute();
    }

    public boolean isGlobalStreamerTwitchTag() {
        try {
            Optional stream = ((StreamList)this.twitchClient.getHelix().getStreams(this.credential.getAccessToken(), null, null, Integer.valueOf(1), null, null, null, Collections.singletonList(this.streamer.getName())).execute()).getStreams().stream().findFirst();
            if (stream.isPresent()) {
                return ((Stream)stream.get()).getTags().stream().anyMatch("StreamingModule"::equalsIgnoreCase) || ((Stream)stream.get()).getTags().stream().anyMatch("StreamingDrops"::equalsIgnoreCase);
            }
        }
        catch (Exception e) {
            this.service.debug(e.getMessage());
        }
        return false;
    }

    public boolean isFollower(String username) {
        if (this.streamer == null || username.equalsIgnoreCase(this.streamer.getName())) {
            return true;
        }
        List twitchFollower = ((InboundFollowers)this.twitchClient.getHelix().getChannelFollowers(this.credential.getAccessToken(), this.functions.getChannelID(this.streamer.getName()), this.functions.getChannelID(username), Integer.valueOf(1), null).execute()).getFollows();
        return twitchFollower != null && !twitchFollower.isEmpty();
    }
}

