/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.external.jackson.databind.ser.std;

import com.morelaid.streamingmodule.external.jackson.core.JsonGenerator;
import com.morelaid.streamingmodule.external.jackson.databind.JavaType;
import com.morelaid.streamingmodule.external.jackson.databind.JsonMappingException;
import com.morelaid.streamingmodule.external.jackson.databind.SerializerProvider;
import com.morelaid.streamingmodule.external.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import com.morelaid.streamingmodule.external.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import com.morelaid.streamingmodule.external.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.morelaid.streamingmodule.external.jackson.databind.ser.std.StdScalarSerializer;
import com.morelaid.streamingmodule.external.jackson.databind.util.ByteBufferBackedInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ByteBufferSerializer
extends StdScalarSerializer<ByteBuffer> {
    public ByteBufferSerializer() {
        super(ByteBuffer.class);
    }

    @Override
    public void serialize(ByteBuffer bbuf, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (bbuf.hasArray()) {
            int pos = bbuf.position();
            gen.writeBinary(bbuf.array(), bbuf.arrayOffset() + pos, bbuf.limit() - pos);
            return;
        }
        ByteBuffer copy = bbuf.asReadOnlyBuffer();
        ByteBufferBackedInputStream in = new ByteBufferBackedInputStream(copy);
        gen.writeBinary(in, copy.remaining());
        in.close();
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        JsonArrayFormatVisitor v2 = visitor.expectArrayFormat(typeHint);
        if (v2 != null) {
            v2.itemsFormat(JsonFormatTypes.INTEGER);
        }
    }
}

