/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.external.morelib.core.file;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public abstract class CoreYaml {
    protected FileConfiguration yml;
    protected String path;

    public CoreYaml(String path) {
        this.path = path;
        this.yml = YamlConfiguration.loadConfiguration((File)new File(path));
        this.createDirectory(path);
        this.reload();
    }

    public abstract void fillDefaultConfig();

    private void createDirectory(String fullPath) {
        String pathNew = new File(fullPath).getParent() + "/";
        File dir = new File(pathNew);
        dir.mkdirs();
    }

    public void reload() {
        this.createDefault();
        this.yml = YamlConfiguration.loadConfiguration((File)new File(this.path));
    }

    public boolean save() {
        try {
            this.yml.save(new File(this.path));
            return true;
        }
        catch (Exception e) {
            System.out.println(e);
            return false;
        }
    }

    public boolean save(FileConfiguration newerYml) {
        this.yml = newerYml;
        return this.save();
    }

    public FileConfiguration getYml() {
        return this.yml;
    }

    public void createDefault() {
        this.fillDefaultConfig();
        this.save();
    }

    public List<String> getCustomKeys(String key) {
        return new ArrayList<String>(this.yml.getConfigurationSection(key).getKeys(false));
    }
}

