/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.external.morelib.core.player;

import com.morelaid.streamingmodule.external.morelib.core.functions.ServerSoftware;
import com.morelaid.streamingmodule.external.morelib.core.player.CorePlayer;
import com.morelaid.streamingmodule.external.morelib.server.bungee.SendBungeeMessage;
import com.morelaid.streamingmodule.external.morelib.server.spigot.SendSpigotMessage;
import com.morelaid.streamingmodule.external.morelib.server.velocity.SendVelocityMessage;

public class MessageSender {
    public static void send(CorePlayer corePlayer, String message) {
        switch (corePlayer.getSoftware()) {
            case SPIGOT: {
                SendSpigotMessage.send(corePlayer, message);
                break;
            }
            case BUNGEECORD: {
                SendBungeeMessage.send(corePlayer, message);
                break;
            }
            case VELOCITY: {
                SendVelocityMessage.send(corePlayer, message);
            }
        }
    }

    public static void cleanSend(CorePlayer corePlayer, String message) {
        switch (corePlayer.getSoftware()) {
            case SPIGOT: {
                SendSpigotMessage.cleanSend(corePlayer, message);
                break;
            }
            case BUNGEECORD: {
                SendBungeeMessage.cleanSend(corePlayer, message);
                break;
            }
            case VELOCITY: {
                SendVelocityMessage.cleanSend(corePlayer, message);
            }
        }
    }

    public static void broadcast(ServerSoftware software, String message, Object server) {
        switch (software) {
            case SPIGOT: {
                SendSpigotMessage.broadcast(message);
                break;
            }
            case VELOCITY: {
                SendVelocityMessage.broadcast(server, message);
                break;
            }
        }
    }
}

