/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.general.base.state;

import java.util.ArrayList;
import java.util.List;

public enum ActiveState {
    UNKNOWN("unknown"),
    ENABLED("on"),
    DISABLED("off");

    private final String text;

    private ActiveState(String text) {
        this.text = text;
    }

    public static ActiveState fromText(String text) {
        for (ActiveState e : ActiveState.values()) {
            if (!e.text.equalsIgnoreCase(text)) continue;
            return e;
        }
        return UNKNOWN;
    }

    public static List<String> toList() {
        ArrayList<String> list = new ArrayList<String>();
        for (ActiveState state : ActiveState.values()) {
            if (state.equals((Object)UNKNOWN)) continue;
            list.add(state.toString());
        }
        return list;
    }

    public String toString() {
        return this.text;
    }
}

