/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.general.file.database;

import com.morelaid.streamingmodule.external.j256.ormlite.field.DataType;
import com.morelaid.streamingmodule.external.j256.ormlite.field.DatabaseField;
import com.morelaid.streamingmodule.external.j256.ormlite.table.DatabaseTable;
import com.morelaid.streamingmodule.external.morelib.core.player.CorePlayer;
import com.morelaid.streamingmodule.general.file.streamer.Streamer;
import com.morelaid.streamingmodule.general.file.streamer.streamercontainer.StreamerContainer;
import com.morelaid.streamingmodule.general.function.ServiceHandler;
import java.util.UUID;

@DatabaseTable(tableName="ModuleUser")
public class ModuleUser
extends CorePlayer {
    @DatabaseField(persisted=false)
    private transient ServiceHandler service;
    @DatabaseField(dataType=DataType.STRING)
    private String platformName;
    @DatabaseField(dataType=DataType.BOOLEAN)
    private boolean verified;
    @DatabaseField(dataType=DataType.BOOLEAN)
    private boolean dropsAllowed = true;
    @DatabaseField(dataType=DataType.BOOLEAN)
    private boolean changed = false;

    public ModuleUser() {
    }

    public ModuleUser(ServiceHandler service, UUID uuid, String name, Object sender) {
        super(service, uuid, name, sender);
        this.service = service;
        this.platformName = name;
        this.verified = false;
    }

    @Override
    public ServiceHandler getService() {
        return this.service;
    }

    public void setService(ServiceHandler service) {
        this.service = service;
        this.software = service.getSoftware();
    }

    public String getPlatformName() {
        return this.platformName;
    }

    public void setPlatformName(String platformName) {
        this.platformName = platformName;
    }

    public boolean isVerified() {
        return this.verified;
    }

    public void setVerified(boolean verified) {
        this.verified = verified;
    }

    @Override
    public String onPlaceholder(String message) {
        return this.parsePlaceholder(message);
    }

    public String parsePlaceholder(String message) {
        Streamer streamer;
        if (this.uuid != null) {
            message = message.replace("%player%", this.name).replace("%twitchuser%", this.platformName).replace("%dropsamount%", Integer.toString(this.service.getFunctions().getDropsAmount(this)).replace("%watchtimecombined%", Integer.toString(this.service.getFunctions().getUserWatchTime(this.platformName))));
        }
        if ((streamer = this.service.getStreamerByName(this.platformName)) != null) {
            message = message.replace("%streamer%", streamer.getName());
            StreamerContainer container = this.service.getStreamerMetaData(streamer);
            if (container != null) {
                String moduleStatus = container.isTwitchMessage() ? this.service.getMessages().getEnabled() : this.service.getMessages().getDisabled();
                message = message.replace("%modulekey%", container.getModuleKey()).replace("%modulekeystatus%", moduleStatus);
            }
        }
        message = this.service.getPlaceholderProxy().parseProxyPAPI(this, message);
        return message;
    }

    public boolean isDropsAllowed() {
        return this.dropsAllowed;
    }

    public void setDropsAllowed(boolean dropsAllowed) {
        this.dropsAllowed = dropsAllowed;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }
}

