/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.general.function;

import com.morelaid.streamingmodule.external.morelib.core.player.MessageSender;
import com.morelaid.streamingmodule.general.async.DropService_Async;
import com.morelaid.streamingmodule.general.base.state.TwitchSettingsState;
import com.morelaid.streamingmodule.general.file.database.ModuleUser;
import com.morelaid.streamingmodule.general.file.streamer.Streamer;
import com.morelaid.streamingmodule.general.file.streamer.streamercontainer.StreamerContainer;
import com.morelaid.streamingmodule.general.function.ServiceHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class CommandHandler {
    private ServiceHandler service;

    public CommandHandler(ServiceHandler service) {
        this.service = service;
    }

    public boolean streamingmodule(ModuleUser moduleUser, String[] args) {
        if (args.length > 0) {
            return this.sm_commands(moduleUser, args);
        }
        return false;
    }

    private boolean sm_commands(ModuleUser moduleUser, String[] args) {
        if (args.length >= 1) {
            switch (args[0].toLowerCase()) {
                case "chatbot": {
                    return this.sm_chatbot(moduleUser, args);
                }
                case "reload": {
                    return this.sm_reload(moduleUser, args);
                }
                case "help": {
                    return this.sm_help(moduleUser);
                }
                case "report": {
                    return this.sm_report(moduleUser);
                }
                case "streamer": {
                    return this.sm_streamer(moduleUser, args);
                }
                case "twitch": {
                    return this.sm_twitch(moduleUser, args);
                }
                case "timer": {
                    return this.sm_timer(moduleUser);
                }
                case "viewers": {
                    return this.smViewersAdmin(moduleUser, args);
                }
            }
        }
        return false;
    }

    public boolean smViewersAdmin(ModuleUser moduleUser, String[] args) {
        if ((moduleUser.hasPermission("sm.admin.*") || moduleUser.hasPermission("sm.admin.smviewers")) && args.length >= 2) {
            return this.smViewers(moduleUser, args[1]);
        }
        return false;
    }

    private boolean sm_timer(ModuleUser moduleUser) {
        if (moduleUser.hasPermission("sm.admin.*") || moduleUser.hasPermission("sm.admin.timer")) {
            moduleUser.sendMessage(this.service.getMessages().getNextDrop());
            return true;
        }
        return false;
    }

    private boolean sm_twitch(ModuleUser moduleUser, String[] args) {
        if (args.length >= 2) {
            switch (args.length) {
                case 2: {
                    return this.sm_twitch_show(moduleUser, args);
                }
                case 3: {
                    return this.sm_twitch_set(moduleUser, args);
                }
            }
        }
        return false;
    }

    private boolean sm_twitch_show(ModuleUser moduleUser, String[] args) {
        if (moduleUser.hasPermission("sm.admin.*") || moduleUser.hasPermission("sm.admin.twitchshow")) {
            ModuleUser user = this.service.getUserList().stream().filter(u -> u.getName().equalsIgnoreCase(args[1])).findFirst().orElse(null);
            if (user != null) {
                moduleUser.sendMessage(user.getPlatformName());
            } else {
                moduleUser.sendMessage(this.service.getMessages().getNotFound());
            }
            return true;
        }
        return false;
    }

    private boolean sm_twitch_set(ModuleUser moduleUser, String[] args) {
        if (moduleUser.hasPermission("sm.admin.*") || moduleUser.hasPermission("sm.admin.twitchset")) {
            Optional<ModuleUser> user = this.service.getUserList().stream().filter(u -> u.getName().equalsIgnoreCase(args[1])).findFirst();
            if (user.isPresent()) {
                user.get().setPlatformName(args[2]);
                this.service.saveModuleUser(user.get());
                this.service.getFunctions().resetStreamerMetaConnection(user.get());
                moduleUser.sendMessage(this.service.getMessages().getValueChanged());
            } else {
                moduleUser.sendMessage(this.service.getMessages().getNotFound());
            }
            return true;
        }
        return false;
    }

    private boolean sm_streamer(ModuleUser moduleUser, String[] args) {
        if (args.length >= 2) {
            switch (args[1].toLowerCase()) {
                case "add": {
                    return this.sm_streamer_add(moduleUser, args);
                }
                case "remove": {
                    return this.sm_streamer_remove(moduleUser, args);
                }
                case "list": {
                    return this.sm_streamer_list(moduleUser);
                }
            }
        }
        return false;
    }

    private boolean sm_streamer_add(ModuleUser moduleUser, String[] args) {
        if (args.length >= 3 && (moduleUser.hasPermission("sm.admin.*") || moduleUser.hasPermission("sm.admin.streameradd"))) {
            String streamerName = args[2];
            if (this.service.getStreamer().getStreamers().stream().filter(s -> s.getName().equalsIgnoreCase(streamerName)).findFirst().orElse(null) == null) {
                Streamer streamer = new Streamer(streamerName);
                this.service.getStreamer().getStreamers().add(streamer);
            }
            this.service.saveStreamers();
            this.service.reload();
            moduleUser.sendMessage(this.service.getMessages().getStreamerAdded());
            return true;
        }
        return false;
    }

    private boolean sm_streamer_remove(ModuleUser moduleUser, String[] args) {
        if (args.length >= 3 && (moduleUser.hasPermission("sm.admin.*") || moduleUser.hasPermission("sm.admin.streamerremove"))) {
            String streamer = args[2];
            this.service.getStreamer().getStreamers().removeIf(s -> s.getName().equalsIgnoreCase(streamer));
            this.service.saveStreamers();
            this.service.reload();
            moduleUser.sendMessage(this.service.getMessages().getStreamerRemove());
            return true;
        }
        return false;
    }

    private boolean sm_streamer_list(ModuleUser moduleUser) {
        if (moduleUser.hasPermission("sm.admin.*") || moduleUser.hasPermission("sm.admin.streamerlist")) {
            List<Streamer> streamers = this.service.getStreamer().getStreamers();
            if (streamers != null) {
                moduleUser.sendMessage(this.service.getMessages().getStreamer());
                for (Streamer streamer : streamers) {
                    moduleUser.sendMessage(streamer.getName());
                }
            } else {
                moduleUser.sendMessage(this.service.getMessages().getNoStreamerFound());
            }
            return true;
        }
        return false;
    }

    private boolean sm_report(ModuleUser moduleUser) {
        if (moduleUser.hasPermission("sm.admin.*") || moduleUser.hasPermission("sm.admin.report")) {
            this.service.createReportFile(moduleUser);
            return true;
        }
        return false;
    }

    private boolean sm_chatbot(ModuleUser moduleUser, String[] args) {
        if (moduleUser.hasPermission("sm.admin.*") || moduleUser.hasPermission("sm.admin.smchatbot")) {
            if (args.length >= 2) {
                if (this.service.isStreamer(args[1])) {
                    Streamer streamer = this.service.getStreamerByName(args[1]);
                    StreamerContainer metaData = this.service.getStreamerMetaData(streamer);
                    moduleUser.sendMessage("---------- &5%streamer%&f ChatBot ----------".replace("%streamer%", streamer.getName()));
                    moduleUser.sendMessage(this.service.getMessages().getModuleKeyText().replace("%modulekey%", metaData.getModuleKey()));
                    String statusMessage = metaData.isTwitchMessage() ? this.service.getMessages().getEnabled() : this.service.getMessages().getDisabled();
                    moduleUser.sendMessage(args[1] + ": " + statusMessage);
                } else {
                    moduleUser.sendMessage(this.service.getMessages().getNotFound());
                }
                return true;
            }
        } else {
            moduleUser.sendMessage(this.service.getMessages().getNoPermission());
            return true;
        }
        return false;
    }

    private boolean sm_reload(ModuleUser moduleUser, String[] args) {
        if (moduleUser.hasPermission("sm.admin.*") || moduleUser.hasPermission("sm.admin.reload")) {
            boolean valid;
            if (args.length >= 2 && args[1].equalsIgnoreCase("force")) {
                this.service.getScheduler().shutdown();
                this.service.setScheduler(new ScheduledThreadPoolExecutor(1));
                valid = this.service.reload(true);
            } else {
                valid = this.service.reload(false);
            }
            if (valid) {
                moduleUser.sendMessage(this.service.getMessages().getReloadMessage());
            } else {
                moduleUser.sendMessage(this.service.getMessages().getFileError());
            }
            return true;
        }
        return false;
    }

    private boolean sm_help(ModuleUser moduleUser) {
        if (moduleUser.hasPermission("sm.admin.*") || moduleUser.hasPermission("sm.admin.help")) {
            moduleUser.sendMessage("########## StreamingModule ##########");
            moduleUser.sendMessage("Check all commands and permissions on the wiki: https://github.com/morelaid/StreamModule/wiki");
            moduleUser.sendMessage("");
            moduleUser.sendMessage("=====> &2[Command /SM or /streamingmodule]&f <=====");
            moduleUser.sendMessage("/sm reload | &6Reloads all configuration files without reset of interval");
            moduleUser.sendMessage("/sm reload force | &6Reloads all configuration files with reset of interval");
            moduleUser.sendMessage("/sm streamer list | &6Shows a list of supported streamer");
            moduleUser.sendMessage("/sm streamer add <player> | &6Adds a streamer to the list");
            moduleUser.sendMessage("/sm streamer remove <player> | &6Removes a streamer from the list");
            moduleUser.sendMessage("/sm twitch <minecraft name> | &6Shows the twitch channel other minecraft players");
            moduleUser.sendMessage("/sm twitch <minecraft name> <twitch channel> | &6Set the twitch channel for other players");
            moduleUser.sendMessage("/sm timer | &6Shows, when the next drop will be given");
            moduleUser.sendMessage("/sm viewers <streamer> | &6Check the twitch viewers, which are connected with Minecraft and Twitch");
            moduleUser.sendMessage("");
            moduleUser.sendMessage("=====> &2[Command /twitch]&f <=====");
            moduleUser.sendMessage("/twitch | &6Shows the Twitch user Name, your account is linked with");
            moduleUser.sendMessage("/twitch <name> | &6Change Twitch Channel name to the new one");
            moduleUser.sendMessage("");
            moduleUser.sendMessage("=====> &2[Command /online]&f <=====");
            moduleUser.sendMessage("/online | &6Shows all streamers, they are currently online and you can get drops from");
            moduleUser.sendMessage("");
            moduleUser.sendMessage("=====> &2[Command /drops]&f <=====");
            moduleUser.sendMessage("/drops | &6Shows a message for some information, which drops are possible");
            moduleUser.sendMessage("");
            moduleUser.sendMessage("=====> &2[Command /twitchsettings]&f <=====");
            moduleUser.sendMessage("/twitchsettings | &6A command for twitch streamers to setup there personal settings");
            moduleUser.sendMessage("");
            moduleUser.sendMessage("=====> &2[Command /chatbot]&f <=====");
            moduleUser.sendMessage("/chatbot | &6A command for twitch streamers to get the streamer chatbot menu");
            return true;
        }
        return false;
    }

    public boolean twitch(ModuleUser moduleUser, String[] args) {
        switch (args.length) {
            case 0: {
                moduleUser.sendMessage(this.service.getMessages().getConnectedWith());
                return true;
            }
            case 1: {
                if (!this.service.getFunctions().isTwitchNameInUse(moduleUser, args[0])) {
                    moduleUser.setPlatformName(args[0]);
                    moduleUser.sendMessage(this.service.getMessages().getPlayerLinked());
                    moduleUser.sendMessage(moduleUser.getPlatformName());
                    moduleUser.setChanged(true);
                    this.service.saveModuleUser(moduleUser);
                    this.service.getFunctions().resetStreamerMetaConnection(moduleUser);
                } else {
                    moduleUser.sendMessage(this.service.getMessages().getAlreadyInUse());
                }
                return true;
            }
        }
        return false;
    }

    public boolean smpublic(ModuleUser moduleUser, String[] args) {
        if (moduleUser.hasPermission("sm.admin.*") || moduleUser.hasPermission("sm.admin.smpublic")) {
            MessageSender.broadcast(moduleUser.getSoftware(), String.join((CharSequence)" ", args), moduleUser.getService().getServer());
            return true;
        }
        return false;
    }

    public boolean smprivate(ModuleUser moduleUser, String[] args) {
        if ((moduleUser.hasPermission("sm.admin.*") || moduleUser.hasPermission("sm.admin.smprivate")) && args.length > 0) {
            String playerName = args[0];
            ArrayList<String> messages = new ArrayList<String>(Arrays.asList(args));
            messages.remove(0);
            ModuleUser target = this.service.getUserByName(playerName);
            if (target != null && target.isOnline()) {
                MessageSender.send(target, String.join((CharSequence)" ", messages));
            }
            return true;
        }
        return false;
    }

    public boolean drops(ModuleUser moduleUser, String[] args) {
        switch (args.length) {
            case 0: {
                moduleUser.sendMessage(this.service.getMessages().getDropsReceived());
                this.service.getFunctions().sendOfflineDrops(moduleUser, true, false);
                return true;
            }
            case 1: {
                return this.drops_1(moduleUser, args);
            }
        }
        return false;
    }

    public boolean drops_1(ModuleUser moduleUser, String[] args) {
        switch (args[0].toLowerCase()) {
            case "test": {
                return this.drops_test(moduleUser, args);
            }
        }
        return false;
    }

    public boolean drops_test(ModuleUser moduleUser, String[] args) {
        if (moduleUser.hasPermission("sm.admin.*") || moduleUser.hasPermission("sm.streamer.dropstest")) {
            Streamer streamer = this.service.getStreamerByName(moduleUser.getPlatformName());
            if (streamer != null) {
                moduleUser.sendMessage(this.service.getMessages().getActionExecuted());
                this.service.getScheduler().schedule(new DropService_Async(this.service, streamer), 0L, TimeUnit.SECONDS);
                return true;
            }
        } else {
            moduleUser.sendMessage(this.service.getMessages().getNoPermission());
        }
        return false;
    }

    public boolean online(ModuleUser moduleUser, String[] args) {
        this.service.debug("Online-Command: MC Name: " + moduleUser.getName() + " | Twitch: " + moduleUser.getPlatformName());
        if (!this.service.getFunctions().sendStreamerOnlineList(moduleUser)) {
            moduleUser.sendMessage(this.service.getMessages().getNoStreamerLive());
        }
        return true;
    }

    public boolean twitchSettings(ModuleUser moduleUser, String[] args) {
        if ((moduleUser.hasPermission("sm.admin.*") || moduleUser.hasPermission("sm.streamer.twitchsettings")) && args.length >= 1) {
            switch (TwitchSettingsState.fromText(args[0])) {
                case TWITCHCHAT: {
                    return this.twitchSettings_twitchChat(moduleUser, args);
                }
                case CHATCOMMAND: {
                    return this.twitchSettings_chatCommands(moduleUser, args);
                }
                case OWNDROPS: {
                    return this.twitchSettings_ownDrops(moduleUser, args);
                }
                case COMMANDFILTER: {
                    return this.twitchSettings_commandFilter(moduleUser, args);
                }
                case USECHATCOLOR: {
                    return this.twitchSettings_useChatColor(moduleUser, args);
                }
                case TWITCHMESSAGES: {
                    return this.twitchSettings_twitchMessage(moduleUser, args);
                }
            }
        }
        return false;
    }

    public boolean twitchSettings_twitchChat(ModuleUser moduleUser, String[] args) {
        Streamer streamer = this.service.getStreamerByName(moduleUser.getPlatformName());
        this.service.debug("TwitchChat - MC: " + moduleUser.getName() + " Streamer: " + streamer.getName() + " Base: " + moduleUser.getPlatformName());
        if (streamer != null) {
            boolean value = streamer.getSettings().getStreamerOptions().isMcChatMessageEnabled();
            if (args.length >= 2) {
                value = this.service.parseBoolean(args[1], value);
                this.service.getStreamerByName(moduleUser.getPlatformName()).getSettings().getStreamerOptions().setMcChatMessageEnabled(value);
                this.service.saveStreamers();
            }
            String textMessage = value ? this.service.getMessages().getEnabledText() : this.service.getMessages().getDisabledText();
            moduleUser.sendMessage(textMessage);
            return true;
        }
        return false;
    }

    public boolean twitchSettings_chatCommands(ModuleUser moduleUser, String[] args) {
        Streamer streamer = this.service.getStreamerByName(moduleUser.getPlatformName());
        if (streamer != null) {
            boolean value = streamer.getSettings().getStreamerOptions().isBotCommandEnabled();
            if (args.length >= 2) {
                value = this.service.parseBoolean(args[1], value);
                this.service.getStreamerByName(moduleUser.getPlatformName()).getSettings().getStreamerOptions().setBotCommandEnabled(value);
                this.service.saveStreamers();
            }
            String textMessage = value ? this.service.getMessages().getEnabledText() : this.service.getMessages().getDisabledText();
            moduleUser.sendMessage(textMessage);
            return true;
        }
        return false;
    }

    public boolean twitchSettings_ownDrops(ModuleUser moduleUser, String[] args) {
        Streamer streamer = this.service.getStreamerByName(moduleUser.getPlatformName());
        if (streamer != null) {
            boolean value = streamer.getSettings().getStreamerOptions().isDropFromOwnStream();
            if (args.length >= 2) {
                value = this.service.parseBoolean(args[1], value);
                this.service.getStreamerByName(moduleUser.getPlatformName()).getSettings().getStreamerOptions().setDropFromOwnStream(value);
                this.service.saveStreamers();
            }
            String textMessage = value ? this.service.getMessages().getEnabledText() : this.service.getMessages().getDisabledText();
            moduleUser.sendMessage(textMessage);
            return true;
        }
        return false;
    }

    public boolean twitchSettings_commandFilter(ModuleUser moduleUser, String[] args) {
        Streamer streamer = this.service.getStreamerByName(moduleUser.getPlatformName());
        if (streamer != null) {
            boolean value = streamer.getSettings().getStreamerOptions().isCommandFilter();
            if (args.length >= 2) {
                value = this.service.parseBoolean(args[1], value);
                this.service.getStreamerByName(moduleUser.getPlatformName()).getSettings().getStreamerOptions().setCommandFilter(value);
                this.service.saveStreamers();
            }
            String textMessage = value ? this.service.getMessages().getEnabledText() : this.service.getMessages().getDisabledText();
            moduleUser.sendMessage(textMessage);
            return true;
        }
        return false;
    }

    public boolean twitchSettings_useChatColor(ModuleUser moduleUser, String[] args) {
        Streamer streamer = this.service.getStreamerByName(moduleUser.getPlatformName());
        if (streamer != null) {
            boolean value = streamer.getSettings().getStreamerOptions().isUseChatColor();
            if (args.length >= 2) {
                value = this.service.parseBoolean(args[1], value);
                this.service.getStreamerByName(moduleUser.getPlatformName()).getSettings().getStreamerOptions().setUseChatColor(value);
                this.service.saveStreamers();
            }
            String textMessage = value ? this.service.getMessages().getEnabledText() : this.service.getMessages().getDisabledText();
            moduleUser.sendMessage(textMessage);
            return true;
        }
        return false;
    }

    public boolean twitchSettings_twitchMessage(ModuleUser moduleUser, String[] args) {
        Streamer streamer = this.service.getStreamerByName(moduleUser.getPlatformName());
        if (streamer != null) {
            boolean value = streamer.getSettings().getStreamerOptions().isTwitchMessages();
            if (args.length >= 2) {
                value = this.service.parseBoolean(args[1], value);
                this.service.getStreamerByName(moduleUser.getPlatformName()).getSettings().getStreamerOptions().setTwitchMessages(value);
                this.service.saveStreamers();
            }
            String textMessage = value ? this.service.getMessages().getEnabledText() : this.service.getMessages().getDisabledText();
            moduleUser.sendMessage(textMessage);
            return true;
        }
        return false;
    }

    public boolean smViewers(ModuleUser moduleUser) {
        return this.smViewers(moduleUser, moduleUser.getPlatformName());
    }

    public boolean smViewers(ModuleUser moduleUser, String platformName) {
        if (moduleUser.hasPermission("sm.admin.*") || moduleUser.hasPermission("sm.streamer.smviewers") || moduleUser.hasPermission("sm.streamer.smviewers")) {
            if (!this.service.isStreamer(platformName)) {
                moduleUser.sendMessage(this.service.getMessages().getNotFound());
                return true;
            }
            Streamer streamer = this.service.getStreamerByName(platformName);
            if (streamer != null) {
                moduleUser.sendMessage(this.service.getMessages().getSearching());
                for (ModuleUser user : this.service.getTwitchBot(streamer).getTwitchViewer(streamer.getName())) {
                    moduleUser.sendMessage(user.getPlatformName());
                }
                return true;
            }
        }
        return false;
    }

    public boolean sendTwitch(ModuleUser moduleUser, String[] args) {
        return this.service.getFunctions().sendTwitchMessage(moduleUser, args);
    }

    public boolean smRandomDrop(ModuleUser moduleUser, String[] args) {
        if (moduleUser.hasPermission("sm.admin.*") || moduleUser.hasPermission("sm.admin.smrandomdrop")) {
            switch (args.length) {
                case 2: {
                    return this.smRandomDrop_2(moduleUser, args);
                }
            }
        }
        return false;
    }

    public boolean smChatBot(ModuleUser moduleUser, String[] args) {
        return this.service.getFunctions().smChatBot_Command(moduleUser);
    }

    public boolean smRandomDrop_2(ModuleUser user, String[] args) {
        Streamer streamer = this.service.getStreamerByName(args[0]);
        String[] viewers = args[1].split(";");
        this.service.getScheduler().schedule(new DropService_Async(this.service, streamer, viewers), 0L, TimeUnit.SECONDS);
        return true;
    }

    public boolean smOptions(ModuleUser moduleUser, String[] args) {
        if (moduleUser.hasPermission("sm.admin.*") || moduleUser.hasPermission("sm.user.smoptions")) {
            switch (args.length) {
                case 1: {
                    return this.smOptions_1(moduleUser, args);
                }
                case 2: {
                    return this.smOptions_2_drops(moduleUser, args);
                }
            }
        }
        return false;
    }

    public boolean smOptions_1(ModuleUser moduleUser, String[] args) {
        switch (args[0].toLowerCase()) {
            case "drops": {
                return this.smOptions_1_drops(moduleUser, args);
            }
        }
        return false;
    }

    public boolean smOptions_1_drops(ModuleUser moduleUser, String[] args) {
        if (moduleUser.isDropsAllowed()) {
            moduleUser.sendMessage(this.service.getMessages().getEnabledText());
        } else {
            moduleUser.sendMessage(this.service.getMessages().getDisabledText());
        }
        return true;
    }

    public boolean smOptions_2_drops(ModuleUser moduleUser, String[] args) {
        moduleUser.setDropsAllowed(this.service.parseBoolean(args[1], moduleUser.isDropsAllowed()));
        this.service.saveModuleUser(moduleUser);
        moduleUser.sendMessage(this.service.getMessages().getValueChanged());
        return true;
    }
}

