/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.general.function;

import com.morelaid.streamingmodule.external.j256.ormlite.dao.Dao;
import com.morelaid.streamingmodule.external.j256.ormlite.dao.DaoManager;
import com.morelaid.streamingmodule.external.j256.ormlite.jdbc.JdbcConnectionSource;
import com.morelaid.streamingmodule.external.j256.ormlite.stmt.QueryBuilder;
import com.morelaid.streamingmodule.external.j256.ormlite.support.ConnectionSource;
import com.morelaid.streamingmodule.external.j256.ormlite.support.DatabaseConnection;
import com.morelaid.streamingmodule.external.j256.ormlite.table.TableUtils;
import com.morelaid.streamingmodule.general.file.database.ChatCommandLog;
import com.morelaid.streamingmodule.general.file.database.DropHistory;
import com.morelaid.streamingmodule.general.file.database.ModuleUser;
import com.morelaid.streamingmodule.general.file.database.WatchedTimeLog;
import com.morelaid.streamingmodule.general.file.streamer.Streamer;
import com.morelaid.streamingmodule.general.function.ServiceHandler;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class DatabaseManager {
    private final ServiceHandler service;
    private final String databaseURL;
    private Dao<DropHistory, Integer> dropHistoryDao;
    private Dao<ModuleUser, UUID> moduleUserDao;
    private Dao<Streamer, String> streamerDao;
    private Dao<WatchedTimeLog, String> watchedTimeLogsDao;
    private Dao<ChatCommandLog, Integer> chatCommandLogsDao;
    private ConnectionSource connectionSource;

    public DatabaseManager(ServiceHandler service, String databaseURL) {
        this.service = service;
        this.databaseURL = databaseURL;
        this.init();
    }

    private void init() {
        try {
            this.connect();
            this.updateDatabase();
            this.dropHistoryDao = DaoManager.createDao((ConnectionSource)this.connectionSource, DropHistory.class);
            this.moduleUserDao = DaoManager.createDao((ConnectionSource)this.connectionSource, ModuleUser.class);
            this.streamerDao = DaoManager.createDao((ConnectionSource)this.connectionSource, Streamer.class);
            this.watchedTimeLogsDao = DaoManager.createDao((ConnectionSource)this.connectionSource, WatchedTimeLog.class);
            this.chatCommandLogsDao = DaoManager.createDao((ConnectionSource)this.connectionSource, ChatCommandLog.class);
            TableUtils.createTableIfNotExists((ConnectionSource)this.connectionSource, DropHistory.class);
            TableUtils.createTableIfNotExists((ConnectionSource)this.connectionSource, ModuleUser.class);
            TableUtils.createTableIfNotExists((ConnectionSource)this.connectionSource, Streamer.class);
            TableUtils.createTableIfNotExists((ConnectionSource)this.connectionSource, WatchedTimeLog.class);
            TableUtils.createTableIfNotExists((ConnectionSource)this.connectionSource, ChatCommandLog.class);
            this.disconnect();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void updateDatabase() {
        if (this.service.getSettings().getSqlSettings().getVersion_DO_NOT_CHANGE() <= 1) {
            this.updateVersion2();
        }
        this.service.getSettings().getSqlSettings().setVersion_DO_NOT_CHANGE(2);
        this.service.saveSettings();
    }

    private void updateVersion2() {
        try {
            DatabaseConnection databaseConnection = this.connectionSource.getReadWriteConnection("");
            if (databaseConnection.isTableExists("streamer")) {
                databaseConnection.executeStatement("ALTER TABLE streamer ADD COLUMN metaData blob", -1);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void connect() {
        if (this.connectionSource == null) {
            try {
                this.connectionSource = new JdbcConnectionSource(this.databaseURL);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public void disconnect() {
        try {
            if (this.connectionSource.isOpen(this.databaseURL)) {
                this.connectionSource.close();
                this.connectionSource = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<DropHistory> getHistoryData() {
        List<DropHistory> dropHistories = new ArrayList<DropHistory>();
        if (this.dropHistoryDao == null) {
            return dropHistories;
        }
        try {
            this.connect();
            dropHistories = this.dropHistoryDao.queryForAll();
            this.disconnect();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return dropHistories;
    }

    public List<ModuleUser> getModuleUserData() {
        List<ModuleUser> moduleUsers = new ArrayList<ModuleUser>();
        if (this.moduleUserDao == null) {
            return moduleUsers;
        }
        try {
            this.connect();
            moduleUsers = this.moduleUserDao.queryForAll();
            this.disconnect();
            for (ModuleUser user : moduleUsers) {
                user.setService(this.service);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return moduleUsers;
    }

    public void updateHistoryData() {
        this.connect();
        if (this.service.getDropHistory() != null) {
            for (DropHistory history : this.service.getDropHistory()) {
                try {
                    this.dropHistoryDao.createOrUpdate((Object)history);
                }
                catch (SQLException e) {
                    this.service.debug(e.getMessage());
                }
            }
        }
        this.disconnect();
    }

    public void updateModuleUserData() {
        if (this.service.getUserList() != null) {
            this.connect();
            for (ModuleUser user : this.service.getUserList()) {
                try {
                    this.moduleUserDao.createOrUpdate((Object)user);
                }
                catch (SQLException e) {
                    this.service.debug(e.getMessage());
                }
            }
            this.disconnect();
        }
    }

    public void updateHistoryData(DropHistory ... dropHistories) {
        if (dropHistories != null) {
            this.connect();
            for (DropHistory history : dropHistories) {
                try {
                    this.dropHistoryDao.createOrUpdate((Object)history);
                }
                catch (SQLException e) {
                    this.service.debug(e.getMessage());
                }
            }
            this.disconnect();
        }
    }

    public void updateModuleUserData(ModuleUser ... moduleUsers) {
        if (moduleUsers != null) {
            this.connect();
            for (ModuleUser user : moduleUsers) {
                try {
                    this.moduleUserDao.createOrUpdate((Object)user);
                }
                catch (SQLException e) {
                    this.service.debug(e.getMessage());
                }
            }
            this.disconnect();
        }
    }

    public void createModuleUser(ModuleUser user) {
        this.connect();
        try {
            this.moduleUserDao.createOrUpdate((Object)user);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.disconnect();
    }

    public List<DropHistory> getDropsAmount(ModuleUser user) {
        List<DropHistory> dropsAmount = new ArrayList<DropHistory>();
        if (user.getUuid() == null) {
            return dropsAmount;
        }
        this.connect();
        QueryBuilder queryBuilder = this.dropHistoryDao.queryBuilder();
        try {
            queryBuilder.where().eq("user_id", (Object)user).and().eq("transferred", (Object)true);
            dropsAmount = queryBuilder.query();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.disconnect();
        return dropsAmount;
    }

    public List<DropHistory> getOpenDropsForUser(ModuleUser user) {
        List<DropHistory> openDrops = new ArrayList<DropHistory>();
        if (user.getUuid() == null) {
            return openDrops;
        }
        this.connect();
        QueryBuilder queryBuilder = this.dropHistoryDao.queryBuilder();
        try {
            queryBuilder.where().eq("user_id", (Object)user).and().eq("transferred", (Object)false);
            openDrops = queryBuilder.query();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.disconnect();
        return openDrops;
    }

    public List<WatchedTimeLog> getAllWatchedTimeLogs() {
        ArrayList<WatchedTimeLog> watchedTimeLogs = new ArrayList();
        this.connect();
        try {
            watchedTimeLogs = this.watchedTimeLogsDao.queryForAll();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.disconnect();
        return watchedTimeLogs;
    }

    public WatchedTimeLog getUsersWatchTime(String user, Streamer streamer) {
        WatchedTimeLog userWatchTime = new WatchedTimeLog();
        userWatchTime.setUser(user);
        userWatchTime.setStreamer(streamer);
        userWatchTime.setWatchTime(0);
        this.connect();
        QueryBuilder queryBuilder = this.watchedTimeLogsDao.queryBuilder();
        try {
            queryBuilder.where().like("user", (Object)user).and().eq("streamer_id", (Object)streamer);
            List logList = queryBuilder.query();
            if (!logList.isEmpty()) {
                userWatchTime = (WatchedTimeLog)logList.get(0);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.disconnect();
        return userWatchTime;
    }

    public List<WatchedTimeLog> getUsersWatchTimeAll(String user) {
        List<WatchedTimeLog> userWatchTime = new ArrayList<WatchedTimeLog>();
        this.connect();
        QueryBuilder queryBuilder = this.watchedTimeLogsDao.queryBuilder();
        try {
            queryBuilder.where().like("user", (Object)user);
            userWatchTime = queryBuilder.query();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.disconnect();
        return userWatchTime;
    }

    public void createOrUpdateCommandLog(ChatCommandLog commandLog) {
        this.connect();
        try {
            this.chatCommandLogsDao.createOrUpdate((Object)commandLog);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.disconnect();
    }

    public void createOrUpdateWatchTime(WatchedTimeLog userWatchTime) {
        this.connect();
        try {
            this.watchedTimeLogsDao.createOrUpdate((Object)userWatchTime);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.disconnect();
    }

    public List<ChatCommandLog> getChatCommandLogs(String user, String chatCommand) {
        List<ChatCommandLog> chatCommandLogList = new ArrayList<ChatCommandLog>();
        this.connect();
        QueryBuilder queryBuilder = this.chatCommandLogsDao.queryBuilder();
        try {
            queryBuilder.where().like("user", (Object)user).and().like("chatCommand", (Object)chatCommand);
            chatCommandLogList = queryBuilder.query();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.disconnect();
        return chatCommandLogList;
    }

    public List<ChatCommandLog> getChatCommandLogs(String user, String chatCommand, Streamer streamer) {
        List<ChatCommandLog> chatCommandLogList = new ArrayList<ChatCommandLog>();
        this.connect();
        QueryBuilder queryBuilder = this.chatCommandLogsDao.queryBuilder();
        try {
            queryBuilder.where().like("user", (Object)user).and().like("chatCommand", (Object)chatCommand).and().eq("streamer_id", (Object)streamer);
            chatCommandLogList = queryBuilder.query();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.disconnect();
        return chatCommandLogList;
    }

    public void createOrUpdateStreamer(Streamer streamer) {
        this.connect();
        try {
            this.streamerDao.createOrUpdate((Object)streamer);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.disconnect();
    }

    public void updateStreamer(Streamer streamer) {
        this.connect();
        try {
            this.streamerDao.update((Object)streamer);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.disconnect();
    }

    public List<Streamer> getStreamerData() {
        List<Streamer> streamers = new ArrayList<Streamer>();
        if (this.streamerDao == null) {
            return streamers;
        }
        try {
            this.connect();
            streamers = this.streamerDao.queryForAll();
            this.disconnect();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return streamers;
    }

    public Streamer getStreamerFromDB(String name) {
        List streamerList = new ArrayList();
        this.connect();
        QueryBuilder queryBuilder = this.streamerDao.queryBuilder();
        try {
            queryBuilder.where().like("name", (Object)name);
            streamerList = queryBuilder.query();
            if (streamerList.isEmpty()) {
                return null;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.disconnect();
        return (Streamer)streamerList.get(0);
    }
}

