/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.general.platform.general;

import com.morelaid.streamingmodule.general.file.database.DropHistory;
import com.morelaid.streamingmodule.general.file.database.ModuleUser;
import com.morelaid.streamingmodule.general.file.streamer.Streamer;
import com.morelaid.streamingmodule.general.function.ServiceHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.regex.Pattern;

public class DropService {
    private ServiceHandler service;

    public DropService(ServiceHandler service) {
        this.service = service;
    }

    public void sendDropsToPlayer(Streamer streamer) {
        if (this.service.getStreamerLiveStatus().contains(streamer.getName().toLowerCase())) {
            List<ModuleUser> viewers = this.service.getTwitchBot(streamer).getTwitchViewer(streamer.getName());
            this.sendDropsToPlayer(streamer, viewers);
        } else {
            this.service.debug("DropService - Streamer not live!");
        }
    }

    public void sendDropsToPlayer(Streamer streamer, List<ModuleUser> viewer) {
        if (this.service.getStreamerLiveStatus().contains(streamer.getName().toLowerCase())) {
            this.sendDropsToPlayer(streamer, viewer, this.getUsersToPick(viewer.size()));
        } else {
            this.service.debug("DropService - Streamer not live!");
        }
    }

    public void sendDropsToPlayer(Streamer streamer, List<ModuleUser> viewer, boolean skipOnlineCheck) {
        if (this.service.getStreamerLiveStatus().contains(streamer.getName().toLowerCase()) || skipOnlineCheck) {
            this.sendDropsToPlayer(streamer, viewer, this.getUsersToPick(viewer.size()));
        } else {
            this.service.debug("DropService - Streamer not live!");
        }
    }

    public void sendDropsToPlayer(Streamer streamer, List<ModuleUser> viewer, int userToPick) {
        if (userToPick <= 0) {
            userToPick = 1;
        }
        if (viewer == null || viewer.isEmpty()) {
            return;
        }
        this.giveDrops(streamer, this.getPickedViewer(viewer, userToPick));
    }

    private int getUsersToPick(int currentViewers) {
        if (this.service.getSettings().getDropOptions().getDropChance() >= 100 || this.service.getSettings().getDropOptions().getDropChance() <= 0) {
            return currentViewers;
        }
        int value = currentViewers * this.service.getSettings().getDropOptions().getDropChance() / 100;
        return value <= 0 ? 1 : value;
    }

    private List<ModuleUser> getPickedViewer(List<ModuleUser> viewer, int userToPick) {
        ArrayList<ModuleUser> pickedUsers = new ArrayList<ModuleUser>();
        if (userToPick > viewer.size()) {
            return pickedUsers;
        }
        for (int i = 0; i < userToPick; ++i) {
            int randomNumber = this.getRandomNumber(viewer.size());
            pickedUsers.add(viewer.get(randomNumber));
            viewer.remove(randomNumber);
        }
        return pickedUsers;
    }

    public boolean isPlayerOnline(ModuleUser user) {
        return user.isOnline() && !this.isBlockedWorld(user) && user.hasInventorySpace();
    }

    private void giveDrops(Streamer streamer, List<ModuleUser> pickedUser) {
        for (ModuleUser user : pickedUser) {
            List<String> commands = this.getDropCommands(streamer, user);
            this.logDrop(streamer, user, commands, this.isPlayerOnline(user));
        }
        if (this.service.getSettings().getDropOptions().isUseAlwaysCommands()) {
            for (String command : this.service.getSettings().getAlwaysCommands()) {
                this.service.getCommandService().console(this.service.parsePlaceholder(null, streamer, command));
            }
        }
    }

    private List<String> getDropCommands(Streamer streamer, ModuleUser user) {
        ArrayList<String> commands = new ArrayList<String>();
        ArrayList<String> drops = new ArrayList<String>(this.service.getSettings().getDrops());
        int amount = this.getDropsAmount();
        for (int i = 0; i < amount && drops.size() > 0; ++i) {
            int randomNumber = this.getRandomNumber(drops.size());
            String command = (String)drops.get(randomNumber);
            command = this.service.parsePlaceholder(user, streamer, command);
            commands.add(command);
            if (amount > drops.size()) continue;
            drops.remove(randomNumber);
        }
        return commands;
    }

    private int getDropsAmount() {
        int amount = this.service.getSettings().getDropOptions().getRandomDrops();
        if (amount <= 0) {
            amount = this.service.getSettings().getDrops().size();
        }
        return amount;
    }

    private boolean isBlockedWorld(ModuleUser user) {
        return this.service.getSettings().getBlacklistWorlds().stream().anyMatch(w -> w.equalsIgnoreCase(user.getWorldName()));
    }

    private List<String> SplitCommandList(String command) {
        ArrayList<String> list = new ArrayList<String>();
        if (command.contains("|")) {
            String[] splitList;
            for (String singleCommand : splitList = command.split(Pattern.quote("|"))) {
                list.add(singleCommand.trim());
            }
        } else {
            list.add(command);
        }
        return list;
    }

    private void logDrop(Streamer streamer, ModuleUser user, List<String> commands, boolean transferred) {
        for (String command : commands) {
            int counter = 0;
            for (String singleCommand : this.SplitCommandList(command)) {
                singleCommand = this.service.parsePlaceholder(user, streamer, singleCommand);
                if (transferred) {
                    this.service.getCommandService().console(singleCommand);
                }
                if (counter == 0) {
                    DropHistory dropCommand = new DropHistory();
                    dropCommand.setUser(user);
                    dropCommand.setBy(streamer);
                    dropCommand.setTransferred(transferred);
                    dropCommand.setCommand(singleCommand);
                    this.service.saveDropHistory(dropCommand);
                }
                ++counter;
            }
        }
    }

    private int getRandomNumber(int maxValue) {
        if (maxValue > 0) {
            Random random = new Random();
            return random.nextInt(maxValue);
        }
        return 0;
    }
}

