/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.general.platform.twitch;

import com.morelaid.streamingmodule.general.file.chatbot.ChatCommand;
import com.morelaid.streamingmodule.general.file.chatbot.WatchTimeOption;
import com.morelaid.streamingmodule.general.file.database.ChatCommandLog;
import com.morelaid.streamingmodule.general.file.database.ModuleUser;
import com.morelaid.streamingmodule.general.file.database.WatchedTimeLog;
import com.morelaid.streamingmodule.general.file.streamer.Streamer;
import com.morelaid.streamingmodule.general.file.streamer.TwitchReward;
import com.morelaid.streamingmodule.general.file.streamer.streamercontainer.StreamerContainer;
import com.morelaid.streamingmodule.general.function.ServiceHandler;
import com.morelaid.streamingmodule.general.platform.twitch.bot.TwitchBot;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class TwitchFunctions {
    private ServiceHandler service;

    public TwitchFunctions(ServiceHandler service) {
        this.service = service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getChannelID(String channel) {
        try (Scanner scanner = null;){
            scanner = new Scanner(new URL(String.format("https://decapi.me/twitch/id/%1s", channel.toLowerCase())).openStream());
            if (scanner.hasNext()) {
                String string = scanner.nextLine();
                return string;
            }
        }
        return "";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sendTwitchRewards(String broadcaster, String twitchUser, String rewardTitle, String rewardMessage, String username) {
        try {
            ModuleUser user = this.service.getUserByPlatform(false, twitchUser, username);
            this.service.debug("Rewards-Message - Broadcaster: " + broadcaster + " user: " + user.getPlatformName() + " message: " + rewardMessage);
            if (!this.service.isStreamer(broadcaster)) return;
            Streamer streamer = this.service.getStreamerByName(broadcaster);
            this.service.debug("Rewards-Title: " + rewardTitle + " reward: " + rewardTitle + " Streamer: " + streamer.getName());
            List rewards = streamer.getSettings().getTwitchRewards().stream().filter(item -> item.getRewardTitle().equalsIgnoreCase(rewardTitle)).collect(Collectors.toList());
            if (rewards.isEmpty()) {
                return;
            }
            TwitchReward reward = (TwitchReward)rewards.get(0);
            List<String> commandList = reward.getCommands();
            TwitchBot twitchBot = this.service.getTwitchBot(streamer);
            if (reward.getWatchTimeOption().isEnabled()) {
                if (!this.commandTimeAllowed(reward.getWatchTimeOption(), user.getPlatformName(), streamer)) {
                    twitchBot.sendTwitchMessage(this.service.getMessages().getChatCommandNotEnoughTime(), user.getName());
                    return;
                }
                if (!this.commandExecutionAllowed(reward.getWatchTimeOption(), user.getPlatformName(), streamer, reward.getRewardTitle())) {
                    twitchBot.sendTwitchMessage(this.service.getMessages().getChatCommandAlreadyUsed(), user.getName());
                    return;
                }
                ChatCommandLog commandLog = new ChatCommandLog();
                commandLog.setChatCommand(reward.getRewardTitle());
                commandLog.setUser(user.getPlatformName());
                commandLog.setStreamer(streamer);
                this.service.getDatabaseManager().createOrUpdateCommandLog(commandLog);
            }
            if (commandList == null) {
                this.service.debug("Reward commands for " + streamer.getName() + " not found or filled!");
                return;
            }
            Iterator<String> iterator = commandList.iterator();
            while (iterator.hasNext()) {
                String command = iterator.next();
                String twitchname = this.getTwitchUserFromRewardMessage(rewardMessage);
                if (twitchname.equalsIgnoreCase("")) {
                    twitchname = twitchUser;
                }
                String string = command = rewardMessage != null ? this.replacePlaceholder(broadcaster, twitchname.toLowerCase(), twitchUser, command, rewardMessage.split(" ")) : this.replacePlaceholder(broadcaster, twitchname.toLowerCase(), twitchUser, command, null);
                if (command.toLowerCase().trim().startsWith("[*]")) {
                    command = command.replace("[*]", "").trim();
                    if (!this.service.getDropService().isPlayerOnline(user)) {
                        this.service.addCommandToOfflineList(user, streamer, command);
                        return;
                    }
                }
                this.service.getCommandService().console(command);
            }
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getTwitchUserFromRewardMessage(String rewardMessage) {
        String username = "";
        if (rewardMessage != null && !((String)rewardMessage).isEmpty()) {
            String[] content;
            rewardMessage = (String)rewardMessage + " ";
            for (String selection : content = ((String)rewardMessage).split(" ")) {
                if (!selection.startsWith("@")) continue;
                username = selection;
                break;
            }
        }
        return username.replace("@", "").replace(" ", "").trim();
    }

    private boolean isValidateChatMessage(String message, String streamerName, String user) {
        if (message.startsWith("?") && streamerName.equalsIgnoreCase(user)) {
            Streamer streamer = this.service.getStreamerByName(streamerName);
            StreamerContainer container = this.service.getStreamerMetaData(streamer);
            return container.getModuleKey().equalsIgnoreCase(message);
        }
        return false;
    }

    private ChatCommand getChatCommand(String message, String streamerName, String user) {
        Streamer streamer = this.service.getStreamerByName(streamerName);
        TwitchBot twitchBot = this.service.getTwitchBot(streamer);
        if (user.equalsIgnoreCase(twitchBot.getBotName())) {
            return null;
        }
        if (!streamer.getSettings().getStreamerOptions().isBotCommandEnabled()) {
            return null;
        }
        String[] splitMessage = message.split(" ");
        if (splitMessage[0].startsWith("!")) {
            String cmd = splitMessage[0].toLowerCase().substring(1);
            ChatCommand chatCommand = this.service.getChatCommands().getChatCommands().stream().filter(c -> c.getCommand().equalsIgnoreCase(cmd)).findFirst().orElse(null);
            if (chatCommand != null && chatCommand.isEnabled() && chatCommand.isUSerAllowed(user) && chatCommand.isStreamerAllowed(streamerName)) {
                if (chatCommand.getOptions().isEnabled()) {
                    if (this.commandTimeAllowed(chatCommand.getOptions(), user, streamer)) {
                        if (this.commandExecutionAllowed(chatCommand.getOptions(), user, streamer, chatCommand.getCommand())) {
                            ChatCommandLog commandLog = new ChatCommandLog();
                            commandLog.setChatCommand(chatCommand.getCommand());
                            commandLog.setUser(user);
                            commandLog.setStreamer(streamer);
                            this.service.getDatabaseManager().createOrUpdateCommandLog(commandLog);
                            return chatCommand;
                        }
                        twitchBot.sendTwitchMessage(this.service.getMessages().getChatCommandAlreadyUsed(), user);
                    } else {
                        twitchBot.sendTwitchMessage(this.service.getMessages().getChatCommandNotEnoughTime(), user);
                    }
                } else {
                    return chatCommand;
                }
            }
        }
        return null;
    }

    private boolean commandExecutionAllowed(WatchTimeOption watchTimeOption, String user, Streamer streamer, String key) {
        if (watchTimeOption.isCombineTime()) {
            return watchTimeOption.getNumberOfUses() > this.service.getDatabaseManager().getChatCommandLogs(user, key).size();
        }
        return watchTimeOption.getNumberOfUses() > this.service.getDatabaseManager().getChatCommandLogs(user, key, streamer).size();
    }

    private boolean commandTimeAllowed(WatchTimeOption watchTimeOption, String user, Streamer streamer) {
        return this.getUserWatchTime(user, streamer, watchTimeOption.isCombineTime()) >= watchTimeOption.getWatchTimeMinutes();
    }

    private int getUserWatchTime(String user, Streamer streamer, boolean useTotal) {
        ArrayList<WatchedTimeLog> watchLogs = new ArrayList<WatchedTimeLog>();
        int time = 0;
        if (useTotal) {
            watchLogs.addAll(this.service.getDatabaseManager().getUsersWatchTimeAll(user));
        } else {
            watchLogs.add(this.service.getDatabaseManager().getUsersWatchTime(user, streamer));
        }
        for (WatchedTimeLog log : watchLogs) {
            time += log.getWatchTime();
        }
        return time;
    }

    public void runChatCommands(String streamerName, String user, String message, String color, String username) {
        Streamer streamer;
        if (streamerName.equalsIgnoreCase("StreamingModule")) {
            return;
        }
        ChatCommand chatCommand = this.getChatCommand(message, streamerName, user);
        if (chatCommand != null) {
            for (String mcCommand : chatCommand.getMcCommandList()) {
                this.service.getCommandService().console(this.replacePlaceholder(streamerName, user, user, mcCommand, message.split(" ")));
            }
        }
        if ((streamer = this.service.getStreamerByName(streamerName)).getSettings().getStreamerOptions().isCommandFilter() && message.startsWith("!")) {
            return;
        }
        if (this.isValidateChatMessage(message, streamerName, user)) {
            this.validateStreamer(streamer);
            return;
        }
        this.sendMessageToMinecraft(streamerName, user, message, color);
    }

    public void validateStreamer(Streamer streamer) {
        StreamerContainer container = this.service.getStreamerMetaData(streamer);
        container.setKnownConnection(streamer.getName());
        container.setTwitchMessage(true);
        this.service.addStreamerMetaData(streamer, container);
        this.service.getFunctions().sendTwitchMessage(streamer.getName(), this.service.getMessages().getTwitchMessageBotEnabled());
    }

    private void sendMessageToMinecraft(String streamerName, String twitchUser, String message, String color) {
        Streamer streamer = this.service.getStreamerByName(streamerName);
        ModuleUser chatter = this.service.getUserByPlatform(false, twitchUser);
        ModuleUser streamerMod = this.service.getUserByPlatform(true, streamerName);
        if (streamer.getSettings().getStreamerOptions().isMcChatMessageEnabled()) {
            if (!streamer.getSettings().getStreamerOptions().isUseChatColor()) {
                message = message.replace("&", "").replace("\u00a7", "").replaceAll("\u00a7.", "");
            }
            message = this.service.getSettings().getTwitchChatFormat().replace("%twitchcolor%", color).replace("%twitchuser%", chatter.getPlatformName()).replace("%twitchplayer%", chatter.getName()).replace("%streamer%", streamerName).replace("%twitchmessage%", message);
            if (streamerMod != null) {
                message = message.replace("%streamername%", streamerMod.getName());
                if (streamerMod.isOnline()) {
                    streamerMod.sendMessage(message);
                }
            }
        }
    }

    public String replacePlaceholder(String streamer, String user, String redeemer, String redeemerMessage, String[] replacements) {
        if (redeemerMessage == null) {
            redeemerMessage = "";
        }
        ModuleUser streamerUser = this.service.getUserByPlatform(false, streamer);
        ModuleUser redeemerUser = this.service.getUserByPlatform(false, redeemer);
        ModuleUser targetUser = this.service.getUserByPlatform(true, user);
        if (targetUser == null) {
            targetUser = redeemerUser;
        }
        String msg = redeemerMessage.replace("%streamer%", streamerUser.getPlatformName()).replace("%streamername%", streamerUser.getName()).replace("%twitchuser%", targetUser.getPlatformName()).replace("%player%", targetUser.getName()).replace("%redeemer%", redeemerUser.getPlatformName()).replace("%redeemerplayer%", redeemerUser.getName()).replace("%twitchmessage%", redeemerMessage).replace("%dropsamount%", Integer.toString(this.service.getFunctions().getDropsAmount(targetUser))).replace("%watchtime%", Integer.toString(this.service.getFunctions().getUserWatchTime(targetUser.getPlatformName(), this.service.getStreamerByName(streamer))));
        msg = this.replaceArgs(msg, replacements);
        msg = this.replaceUrlValues(msg);
        this.service.debug("replacePlaceholder - message: " + msg);
        return msg;
    }

    private String replaceArgs(String message, String[] args) {
        String msg = message;
        try {
            if (args != null && args.length > 0) {
                String checkValue = "%args_";
                String checkValueAll = "%args_*%";
                String allString = String.join((CharSequence)" ", Arrays.copyOfRange(args, 0, args.length));
                msg = msg.replace(checkValueAll, allString);
                Pattern pattern = Pattern.compile("%args_([0-9])%");
                Matcher matcher = pattern.matcher(msg);
                while (msg.contains(checkValue)) {
                    if (!matcher.find()) continue;
                    for (int i = 1; i <= matcher.groupCount(); ++i) {
                        this.service.debug("Matcher Group: " + matcher.group(i));
                        msg = msg.replace(checkValue + matcher.group(i) + "%", args[Integer.parseInt(matcher.group(i))]);
                    }
                }
            }
        }
        catch (Exception e) {
            this.service.debug("args regex error: " + e.getMessage());
        }
        return msg;
    }

    public List<String> urlRequestUrl(String text) {
        ArrayList<String> value = new ArrayList<String>();
        Pattern pattern = Pattern.compile("URL=\"(.*)\"");
        Matcher matcher = pattern.matcher(text);
        if (matcher.find()) {
            for (int i = 1; i <= matcher.groupCount(); ++i) {
                value.add(matcher.group(i));
            }
        }
        return value;
    }

    public String replaceUrlValues(String text) {
        String value = text;
        for (String item : this.urlRequestUrl(value)) {
            this.service.debug("Matcher Value: " + item);
            value = value.replace("URL=\"" + item + "\"", this.service.getValueFromUrl(item));
        }
        return value;
    }

    public void generateOnlineStatus() {
        if (this.service.getStreamer().getStreamers() != null) {
            this.service.setStreamerLiveStatus(new HashSet<String>());
            for (Streamer streamer : this.service.getStreamer().getStreamers()) {
                TwitchBot twitchBot = this.service.getTwitchBot(streamer);
                if (twitchBot == null) continue;
                this.service.debug("LiveCheck for: " + streamer.getName());
                if (twitchBot.isOnline(streamer.getName())) {
                    this.service.debug("LiveCheck: " + streamer.getName() + " is live!");
                    ModuleUser user = this.service.getUserByPlatform(false, streamer.getName());
                    this.service.debug("LiveCheck: Name: " + user.getName() + " | Channel: " + user.getPlatformName());
                    if (this.service.getTwitchBot(streamer).isGlobalStreamerTwitchTag()) {
                        this.service.debug("LiveCheck: " + streamer.getName() + " active globalStreamerTag!");
                        this.service.getFunctions().addGlobalStreamerStatus(streamer);
                    }
                    if (!user.isOnline()) continue;
                    this.service.debug("LiveCheck: " + streamer.getName() + " on the server!");
                    this.service.getFunctions().addGlobalStreamerStatus(streamer);
                    continue;
                }
                this.service.debug(streamer.getName() + " offline - remove from live message");
                this.service.getLiveMessageSend().remove(streamer.getName().toLowerCase());
            }
        }
    }
}

