/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.server.spigot;

import com.morelaid.streamingmodule.external.morelib.core.functions.ServerSoftware;
import com.morelaid.streamingmodule.external.morelib.server.spigot.SpigotMetrics;
import com.morelaid.streamingmodule.general.file.database.ModuleUser;
import com.morelaid.streamingmodule.general.function.ServiceHandler;
import com.morelaid.streamingmodule.server.spigot.command.TabNavigator;
import com.morelaid.streamingmodule.server.spigot.event.PlaceholderAPI_Spigot;
import com.morelaid.streamingmodule.server.spigot.event.SpigotEventHandler;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StreamingModuleSpigot
extends JavaPlugin
implements TabExecutor {
    private ServiceHandler service;

    public void onEnable() {
        this.service = new ServiceHandler(this.getLogger(), this.getDescription().getPrefix(), this.getDescription().getName(), ServerSoftware.SPIGOT, (Object)this);
        this.getServer().getPluginManager().registerEvents((Listener)new SpigotEventHandler(this.service), (Plugin)this);
        this.enableExternalAPI();
        this.getLogger().info(String.format("Version %1s is enabled!", this.getDescription().getVersion()));
    }

    public void onDisable() {
        this.service.getScheduler().shutdown();
        this.getLogger().info(String.format("Version %1s is disabled!", this.getDescription().getVersion()));
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        Player p;
        ModuleUser moduleUser = null;
        if (sender instanceof Player && (moduleUser = this.service.getUserByUUID((p = (Player)sender).getUniqueId())) == null) {
            moduleUser = new ModuleUser(this.service, p.getUniqueId(), p.getName(), (Object)p);
        }
        if (moduleUser == null) {
            moduleUser = new ModuleUser(this.service, null, sender.getName(), (Object)sender);
        }
        switch (command.getName().toLowerCase()) {
            case "sm": {
                return this.service.getCommandHandler().streamingmodule(moduleUser, args);
            }
            case "twitch": {
                return this.service.getCommandHandler().twitch(moduleUser, args);
            }
            case "smpublic": {
                return this.service.getCommandHandler().smpublic(moduleUser, args);
            }
            case "smprivate": {
                return this.service.getCommandHandler().smprivate(moduleUser, args);
            }
            case "drops": {
                return this.service.getCommandHandler().drops(moduleUser, args);
            }
            case "online": {
                return this.service.getCommandHandler().online(moduleUser, args);
            }
            case "twitchsettings": {
                return this.service.getCommandHandler().twitchSettings(moduleUser, args);
            }
            case "smviewers": {
                return this.service.getCommandHandler().smViewers(moduleUser);
            }
            case "sendtwitch": {
                return this.service.getCommandHandler().sendTwitch(moduleUser, args);
            }
            case "smoptions": {
                return this.service.getCommandHandler().smOptions(moduleUser, args);
            }
            case "smrandomdrop": {
                return this.service.getCommandHandler().smRandomDrop(moduleUser, args);
            }
            case "smchatbot": {
                return this.service.getCommandHandler().smChatBot(moduleUser, args);
            }
        }
        return super.onCommand(sender, command, label, args);
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        Player p;
        ModuleUser moduleUser = null;
        if (sender instanceof Player && (moduleUser = this.service.getUserByUUID((p = (Player)sender).getUniqueId())) == null) {
            moduleUser = new ModuleUser(this.service, p.getUniqueId(), p.getName(), (Object)p);
        }
        if (moduleUser != null) {
            switch (command.getName().toLowerCase()) {
                case "sm": {
                    return TabNavigator.Command_SM(this.service, moduleUser, args);
                }
                case "twitchsettings": {
                    return TabNavigator.Command_TS(moduleUser, args);
                }
                case "smoptions": {
                    return TabNavigator.Command_smOptions(moduleUser, args);
                }
                case "drops": {
                    return TabNavigator.Command_drops(moduleUser, args);
                }
            }
        }
        return new ArrayList<String>();
    }

    public void enableExternalAPI() {
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new PlaceholderAPI_Spigot(this.service, this.getDescription().getPrefix(), "Morelaid", this.getDescription().getVersion()).register();
        }
        try {
            SpigotMetrics spigotMetrics = new SpigotMetrics((Plugin)this, 21950);
        }
        catch (Exception e) {
            this.service.debug(e.getMessage());
        }
    }
}

