/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.campfirespawnandtweaks_common_fabric.events;

import com.mojang.datafixers.util.Pair;
import com.natamus.campfirespawnandtweaks_common_fabric.config.ConfigHandler;
import com.natamus.campfirespawnandtweaks_common_fabric.util.Util;
import com.natamus.collective_common_fabric.functions.BlockFunctions;
import com.natamus.collective_common_fabric.functions.EntityFunctions;
import com.natamus.collective_common_fabric.functions.HashMapFunctions;
import com.natamus.collective_common_fabric.functions.MessageFunctions;
import com.natamus.collective_common_fabric.functions.WorldFunctions;
import com.natamus.collective_common_fabric.services.Services;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2244;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2709;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3922;
import net.minecraft.class_3965;
import net.minecraft.class_6880;

public class CampfireEvent {
    public static HashMap<String, Pair<class_1937, class_2338>> playercampfires = new HashMap();
    public static HashMap<class_1937, List<Pair<class_1657, class_2338>>> playerstorespawn = new HashMap();
    private static final HashMap<class_1937, List<class_2338>> firestoextinguish = new HashMap();
    private static final List<class_2248> extinguishblocks = new ArrayList<class_2248>(Arrays.asList(class_2246.field_10566, class_2246.field_10219, class_2246.field_10102, class_2246.field_10534, class_2246.field_10114));

    public static void onWorldLoad(class_3218 level) {
        Util.loadCampfireSpawnsFromWorld((class_1937)level);
    }

    public static void onWorldTick(class_3218 level) {
        if (((List)HashMapFunctions.computeIfAbsent(firestoextinguish, (Object)level, k -> new ArrayList())).size() > 0) {
            class_2338 campfirepos = firestoextinguish.get(level).get(0);
            class_2680 state = level.method_8320(campfirepos);
            if (state.method_26204() instanceof class_3922) {
                level.method_8501(campfirepos, (class_2680)((class_2680)state.method_11657((class_2769)class_3922.field_17352, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)class_3922.field_17354, (Comparable)Boolean.valueOf(false)));
            }
            firestoextinguish.get(level).remove(0);
        }
        if (((List)HashMapFunctions.computeIfAbsent(playerstorespawn, (Object)level, k -> new ArrayList())).size() > 0) {
            Pair<class_1657, class_2338> pair = playerstorespawn.get(level).get(0);
            class_1657 player = (class_1657)pair.getFirst();
            class_2338 respawnpos = (class_2338)pair.getSecond();
            if (player instanceof class_3222) {
                if (level.method_8320(respawnpos).method_26204() instanceof class_3922) {
                    class_243 ts;
                    class_3222 serverplayer = (class_3222)player;
                    int fireresistancems = ConfigHandler.fireResitanceDurationOnRespawnInMs;
                    if (fireresistancems > 0) {
                        ts = new class_243((double)respawnpos.method_10263() + 0.5, (double)respawnpos.method_10264() + 0.5, (double)respawnpos.method_10260() + 0.5);
                        EntityFunctions.addPotionEffect((class_1297)player, (class_6880)class_1294.field_5918, (Integer)fireresistancems);
                    } else {
                        ts = new class_243((double)respawnpos.method_10263() + 1.5, (double)respawnpos.method_10264(), (double)respawnpos.method_10260() + 0.5);
                    }
                    if (ConfigHandler.createAirPocketIfBlocksAboveCampfire) {
                        class_2338 tsbp = class_2338.method_49637((double)ts.field_1352, (double)ts.field_1351, (double)ts.field_1350);
                        Iterator posaround = class_2338.method_17962((int)tsbp.method_10263(), (int)tsbp.method_10264(), (int)tsbp.method_10260(), (int)tsbp.method_10263(), (int)(tsbp.method_10264() + 1), (int)tsbp.method_10260()).iterator();
                        while (posaround.hasNext()) {
                            class_2338 around = (class_2338)posaround.next();
                            class_2248 block = level.method_8320(around).method_26204();
                            if (block.equals(class_2246.field_10124) || block instanceof class_3922) continue;
                            BlockFunctions.dropBlock((class_1937)level, (class_2338)around);
                        }
                    }
                    serverplayer.method_48105(level, ts.field_1352, ts.field_1351, ts.field_1350, class_2709.field_40710, player.method_36454(), player.method_36455(), true);
                } else {
                    String playername = player.method_5477().toString();
                    playercampfires.remove(playername.toLowerCase());
                    if (ConfigHandler.sendMessageOnCampfireSpawnMissing) {
                        MessageFunctions.sendMessage((class_1657)player, (String)"Campfire spawn point missing.", (class_124)class_124.field_1063);
                    }
                }
            }
            playerstorespawn.get(level).remove(0);
        }
    }

    public static boolean onEntityBlockPlace(class_1937 level, class_2338 pos, class_2680 state, class_1309 entity, class_1799 itemStack) {
        if (level.field_9236) {
            return true;
        }
        if (!(entity instanceof class_1657)) {
            return true;
        }
        class_2248 block = state.method_26204();
        if (block instanceof class_3922) {
            class_1657 player = (class_1657)entity;
            if (Services.TOOLFUNCTIONS.isFlintAndSteel(player.method_6047()) || Services.TOOLFUNCTIONS.isFlintAndSteel(player.method_6079())) {
                return true;
            }
            if (ConfigHandler.campfiresStartUnlit) {
                level.method_8501(pos, (class_2680)state.method_11657((class_2769)class_3922.field_17352, (Comparable)Boolean.valueOf(false)));
                return false;
            }
        }
        return true;
    }

    public static boolean onRightClickCampfireBlock(class_1937 level, class_1657 player, class_1268 hand, class_2338 pos, class_3965 hitVec) {
        if (level.field_9236) {
            return true;
        }
        class_2680 state = level.method_8320(pos);
        class_2248 block = state.method_26204();
        boolean allowAction = true;
        if (block instanceof class_3922) {
            String playername = player.method_5477().getString();
            if (player.method_5715() && ConfigHandler.sneakRightClickCampfireToUnset) {
                if (Util.checkForCampfireSpawnRemoval(level, playername, pos) && ConfigHandler.sendMessageOnNewCampfireSpawnSet) {
                    MessageFunctions.sendMessage((class_1657)player, (String)"Campfire spawn point removed.", (class_124)class_124.field_1063);
                }
                return true;
            }
            class_1799 itemstack = player.method_5998(hand);
            class_1792 item = itemstack.method_7909();
            boolean holdinglighter = false;
            if (Services.TOOLFUNCTIONS.isFlintAndSteel(player.method_6047()) || Services.TOOLFUNCTIONS.isFlintAndSteel(player.method_6079())) {
                holdinglighter = true;
                if (((Boolean)state.method_11654((class_2769)class_3922.field_17352)).booleanValue()) {
                    allowAction = false;
                }
            }
            boolean removed = false;
            if (((Boolean)state.method_11654((class_2769)class_3922.field_17352)).booleanValue() || holdinglighter) {
                boolean iswaterbucket = item.equals(class_1802.field_8705);
                class_2248 itemblock = class_2248.method_9503((class_1792)item);
                if (extinguishblocks.contains(itemblock) || iswaterbucket && !holdinglighter) {
                    if (!player.method_68878() && !iswaterbucket) {
                        itemstack.method_7934(1);
                    }
                    allowAction = false;
                    level.method_8501(pos, (class_2680)state.method_11657((class_2769)class_3922.field_17352, (Comparable)Boolean.valueOf(false)));
                    if (iswaterbucket) {
                        ((List)HashMapFunctions.computeIfAbsent(firestoextinguish, (Object)level, k -> new ArrayList())).add(pos);
                    }
                    if (Util.checkForCampfireSpawnRemoval(level, playername, pos) && ConfigHandler.sendMessageOnNewCampfireSpawnSet) {
                        MessageFunctions.sendMessage((class_1657)player, (String)"Campfire spawn point removed.", (class_124)class_124.field_1063);
                    }
                    removed = true;
                }
                if (!removed && hand.equals((Object)class_1268.field_5808) && (holdinglighter || itemstack.method_7960())) {
                    boolean replaced = playercampfires.containsKey(playername.toLowerCase());
                    class_2338 oldpos = null;
                    if (replaced) {
                        oldpos = ((class_2338)playercampfires.get(playername.toLowerCase()).getSecond()).method_10062();
                    }
                    if (Util.setCampfireSpawn(level, playername, pos) && ConfigHandler.sendMessageOnNewCampfireSpawnSet) {
                        if (holdinglighter) {
                            level.method_8501(pos, (class_2680)state.method_11657((class_2769)class_3922.field_17354, (Comparable)Boolean.valueOf(false)));
                            player.method_6104(hand);
                        }
                        if (replaced) {
                            if (oldpos.equals((Object)pos)) {
                                MessageFunctions.sendMessage((class_1657)player, (String)"Campfire spawn point remains the same.", (class_124)class_124.field_1063);
                                return true;
                            }
                            MessageFunctions.sendMessage((class_1657)player, (String)"Campfire spawn point replaced.", (class_124)class_124.field_1063);
                            return true;
                        }
                        MessageFunctions.sendMessage((class_1657)player, (String)"Campfire spawn point set.", (class_124)class_124.field_1063);
                    }
                }
            }
        } else if (block instanceof class_2244 && player.method_5715()) {
            if (!ConfigHandler.bedsOverrideCampfireSpawnOnSneakRightClick) {
                return true;
            }
            String playername = player.method_5477().getString().toLowerCase();
            if (playercampfires.containsKey(playername)) {
                class_2338 newspawn = pos.method_10062();
                Pair<class_1937, class_2338> pair = playercampfires.get(playername);
                class_1937 oldlevel = (class_1937)pair.getFirst();
                class_2338 oldpos = (class_2338)pair.getSecond();
                if (WorldFunctions.getWorldDimensionName((class_1937)level).equals(WorldFunctions.getWorldDimensionName((class_1937)oldlevel)) && newspawn.equals((Object)oldpos)) {
                    return true;
                }
                if (Util.checkForCampfireSpawnRemoval(level, playername, oldpos) && ConfigHandler.sendMessageOnCampfireSpawnOverride) {
                    MessageFunctions.sendMessage((class_1657)player, (String)"Campfire spawn point unset.", (class_124)class_124.field_1063);
                }
            }
        }
        return allowAction;
    }

    public static void onCampfireBreak(class_1937 level, class_1657 player, class_2338 pos, class_2680 state, class_2586 blockEntity) {
        String playername;
        if (level.field_9236) {
            return;
        }
        if (level.method_8320(pos).method_26204() instanceof class_3922 && Util.checkForCampfireSpawnRemoval(level, playername = player.method_5477().getString().toLowerCase(), pos) && ConfigHandler.sendMessageOnNewCampfireSpawnSet) {
            MessageFunctions.sendMessage((class_1657)player, (String)"Campfire spawn point removed.", (class_124)class_124.field_1063);
        }
    }

    public static void onPlayerRespawn(class_3222 oldPlayer, class_3222 newPlayer, boolean alive) {
        class_3218 level = newPlayer.method_51469();
        if (level.field_9236) {
            return;
        }
        String playername = newPlayer.method_5477().getString().toLowerCase();
        if (!playercampfires.containsKey(playername)) {
            return;
        }
        Pair<class_1937, class_2338> pair = playercampfires.get(playername);
        ((List)HashMapFunctions.computeIfAbsent(playerstorespawn, (Object)((class_1937)pair.getFirst()), k -> new ArrayList())).add(new Pair((Object)newPlayer, (Object)((class_2338)pair.getSecond()).method_10062()));
    }
}

