/*
 * Decompiled with CFR 0.152.
 */
package io.github.sjouwer.gammautils.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_310;

public class LightLevelUtil {
    private static final class_310 client = class_310.method_1551();

    private LightLevelUtil() {
    }

    public static Double getAverageLightLevel(int range) {
        return LightLevelUtil.getAverageLightLevel(range, 0.0f);
    }

    public static Double getAverageLightLevel(int range, float skyBrightnessOverride) {
        if (LightLevelUtil.client.field_1687 == null || LightLevelUtil.client.field_1724 == null) {
            return 15.0;
        }
        class_2338 playerPos = LightLevelUtil.client.field_1724.method_24515().method_10084();
        ArrayList<Double> lightLevels = new ArrayList<Double>();
        lightLevels.add(LightLevelUtil.getLightLevel(playerPos, skyBrightnessOverride));
        if (range > 0) {
            for (class_2350 direction : class_2350.values()) {
                LightLevelUtil.addLightLevelsInDirection(lightLevels, playerPos, direction, range, skyBrightnessOverride);
            }
        }
        return lightLevels.stream().mapToDouble(lvl -> lvl).average().orElse(15.0);
    }

    private static void addLightLevelsInDirection(List<Double> lightLevels, class_2338 blockPos, class_2350 direction, int range, float skyBrightnessOverride) {
        class_2338 offsetPos;
        for (int i = 0; i < range && LightLevelUtil.client.field_1687.method_8320(offsetPos = blockPos.method_10079(direction, i)).method_26215(); ++i) {
            lightLevels.add(LightLevelUtil.getLightLevel(offsetPos, skyBrightnessOverride));
        }
    }

    public static double getLightLevel(class_2338 blockPos, float skyBrightnessOverride) {
        if (LightLevelUtil.client.field_1687 == null) {
            return 15.0;
        }
        int blockLight = LightLevelUtil.client.field_1687.method_22336().method_15562(class_1944.field_9282).method_15543(blockPos);
        int skyLight = LightLevelUtil.client.field_1687.method_22336().method_15562(class_1944.field_9284).method_15543(blockPos);
        float skyBrightness = Math.max(LightLevelUtil.client.field_1687.method_23783(1.0f), skyBrightnessOverride);
        return Math.max((float)blockLight, (float)skyLight * skyBrightness);
    }
}

